using System.Net.Sockets;
using System.Net;
using System.Collections.Concurrent;
using System.Net.NetworkInformation;
using System.Text.RegularExpressions;
using System.IO;
using System.Text;
using Microsoft.VisualBasic;
using System.Diagnostics;
using Microsoft.VisualBasic.Devices;
using System.Threading;
using System.Runtime.InteropServices;
using static System.Net.WebRequestMethods;
using System.Reflection;

[StructLayout(LayoutKind.Sequential)]
public struct DeviceInfo
{
    public string SSID;
    public string MacAdrs;
    public string Mode;
    public string Version;
    public string IPAdrs;
}

namespace RS_WF62_terminal_CS
{
    public partial class RSWF62 : Form
    {
        private NetworkStream mStream;
        private TcpClient mClient;
        private Thread LEDMsgThread;
        private Thread LEDThread;
        private Thread DeviceScanMsgThread;
        private Thread DeviceScanThread;
        public static UdpClient rcvClient;
        public FrmScan FrmScanMsg;
        public FrmLED FrmLEDMsg;
        public static EventWaitHandle WaitHandle;


        /// MACAhXEIPAhXEo[Wۊǂ郊Xg
        public static ConcurrentDictionary<int, DeviceInfo> foundList = new ConcurrentDictionary<int, DeviceInfo>();

        delegate void EnableBtnCallback(System.Windows.Forms.Button Btn, bool fEnable);
        private void EnableBtn(System.Windows.Forms.Button Btn, bool fEnable)
        {
            // ĂяõRg[̃XbhقȂ邩mF
            if (Btn.InvokeRequired)
            {
                // ꃁ\bhւ̃R[obN쐬
                EnableBtnCallback delegateMethod = new EnableBtnCallback(EnableBtn);

                // Rg[̐eInvoke()\bhĂяoƂŁAĂяo
                // Rg[̃Xbhł̃\bhs
                this.BeginInvoke(delegateMethod, new object[] { Btn, fEnable });
            }
            else
            {
                // Rg[𒼐ڌĂяo
                Btn.Enabled = fEnable;
            }
        }

        delegate void SetLstCallback(ListView Lst, string str0, string str1, string str2, string str3, string str4);
        private void SetLst(ListView Lst, string str0, string str1, string str2, string str3, string str4)
        {
            // ĂяõRg[̃XbhقȂ邩mF
            if (Lst.InvokeRequired)
            {
                // ꃁ\bhւ̃R[obN쐬
                SetLstCallback delegateMethod = new SetLstCallback(SetLst);

                // Rg[̐eInvoke()\bhĂяoƂŁAĂяo
                // Rg[̃Xbhł̃\bhs
                this.BeginInvoke(delegateMethod, new object[] { Lst, str0, str1, str2, str3, str4 });
            }
            else
            {
                // Rg[𒼐ڌĂяo
                var lvitem = Lst.Items.Add(str0);
                lvitem.Tag = str1;
                lvitem.ToolTipText = str1;
                lvitem.SubItems.Add(str2);
                lvitem.SubItems.Add(str3);
                lvitem.SubItems.Add(str4);
            }
        }

        delegate void ClearLstCallback(ListView Lst);
        private void ClearLst(ListView Lst)
        {
            // ĂяõRg[̃XbhقȂ邩mF
            if (Lst.InvokeRequired)
            {
                // ꃁ\bhւ̃R[obN쐬
                ClearLstCallback delegateMethod = new ClearLstCallback(ClearLst);

                // Rg[̐eInvoke()\bhĂяoƂŁAĂяo
                // Rg[̃Xbhł̃\bhs
                this.BeginInvoke(delegateMethod, new object[] { Lst });
            }
            else
            {
                // Rg[𒼐ڌĂяo
                Lst.Items.Clear();
            }
        }

        delegate void SetCmbCallback(ComboBox Cmb, string str1);
        private void SetCmb(ComboBox Cmb, string str1)
        {
            // ĂяõRg[̃XbhقȂ邩mF
            if (Cmb.InvokeRequired)
            {
                // ꃁ\bhւ̃R[obN쐬
                SetCmbCallback delegateMethod = new SetCmbCallback(SetCmb);

                // Rg[̐eInvoke()\bhĂяoƂŁAĂяo
                // Rg[̃Xbhł̃\bhs
                this.BeginInvoke(delegateMethod, new object[] { Cmb, str1 });
            }
            else
            {
                // Rg[𒼐ڌĂяo
                Cmb.Items.Add(str1);
                // IfoCX
                Cmb.SelectedIndex = 0;
            }
        }

        delegate void ClearCmbCallback(ComboBox Cmb);
        private void ClearCmb(ComboBox Cmb)
        {
            // ĂяõRg[̃XbhقȂ邩mF
            if (Cmb.InvokeRequired)
            {
                // ꃁ\bhւ̃R[obN쐬
                ClearCmbCallback delegateMethod = new ClearCmbCallback(ClearCmb);

                // Rg[̐eInvoke()\bhĂяoƂŁAĂяo
                // Rg[̃Xbhł̃\bhs
                this.BeginInvoke(delegateMethod, new object[] { Cmb });
            }
            else
            {
                // Rg[𒼐ڌĂяo
                Cmb.Items.Clear();
            }
        }


        public RSWF62()
        {
            InitializeComponent();
        }

        // ݒ
        private void RSWF62_Load(object sender, EventArgs e)
        {
            // Cxgnh
            WaitHandle = new EventWaitHandle(false, EventResetMode.ManualReset);
            WaitHandle.Reset();

            // XL
            ReScan();
        }

        // I
        private void RSWF62_FormClosing(object sender, FormClosingEventArgs e)
        {
            if ((FrmScanMsg != null) && (!FrmScanMsg.IsDisposed))
            {
                // bZ[WI
                FrmScanMsg.Close();
                FrmScanMsg.Dispose();
            }
            if ((FrmLEDMsg != null) && (!FrmLEDMsg.IsDisposed))
            {
                // LEDbZ[WI
                FrmLEDMsg.Close();
                FrmLEDMsg.Dispose();
            }

            // CxgN[Y
            WaitHandle.Close();
        }

        // ăXL
        private void BtnReScan_Click(object sender, EventArgs e)
        {
            // XL
            ReScan();
        }

        // I
        private void BtnExit_Click(object sender, EventArgs e)
        {
            // N[Y
            this.Close();
        }

        // LEDmF
        private void BtnLED_Click(object sender, EventArgs e)
        {
            int timeout = 3000;

            if (LstDevice.Items.Count > 0)
            {
                // IĂȂȂI
                if (LstDevice.SelectedIndices.Count == 0)
                {
                    MessageBox.Show("foCXIĂ܂");
                    return;
                }

                // {^
                EnableBtn(BtnReScan, false);
                EnableBtn(BtnLED, false);
                EnableBtn(BtnTCPIP, false);
                EnableBtn(BtnComPort, false);
                EnableBtn(BtnExit, false);

                IPAddress ip = IPAddress.Parse(LstDevice.SelectedItems[0].SubItems[1].Text);
                int port = 5074;

                // IPAhXƃ|[gԍ\PbgEAhX쐬
                mClient = new TcpClient();
                mClient.ReceiveTimeout = mClient.SendTimeout = timeout;

                var result = mClient.BeginConnect(ip, port, null, null);
                var success = result.AsyncWaitHandle.WaitOne(TimeSpan.FromMilliseconds(timeout));

                if (!success)
                {
                    // {^L
                    EnableBtn(BtnReScan, true);
                    EnableBtn(BtnLED, true);
                    EnableBtn(BtnTCPIP, true);
                    EnableBtn(BtnComPort, true);
                    EnableBtn(BtnExit, true);

                    // sAO𓊂
                    return;
                }

                // \Pbgւ̐ڑ
                // \Pbg֐ڑ
                if (mClient.Connected)
                {
                    //return;
                }

                // o̓Xg[擾
                if (mStream == null)
                {
                    mStream = mClient.GetStream();
                }

                // LEDXbh
                LEDThread = new Thread(LEDProc);
                LEDThread.Start();
            }
            else
            {
                MessageBox.Show("foCX܂");
            }
        }

        // LED
        private void LEDProc()
        {
            byte[] writeBuf;
            byte[] resultBuf;

            // LEDbZ[WXbh
            LEDMsgThread = new Thread(LEDMsgProc);
            LEDMsgThread.Start();

            try
            {
                // R}h[hɕύX
                writeBuf = new byte[3 + 2];
                //writeBuf = Encoding.ASCII.GetBytes("$$$\r\n");
                writeBuf[0] = 0x24;// '$'
                writeBuf[1] = 0x24;// '$'
                writeBuf[2] = 0x24;// '$'
                writeBuf[3] = 0x0d;
                writeBuf[4] = 0x0a;
                // M
                writeCommand(mStream, writeBuf);
                // X|Xf[^̎M
                resultBuf = readResponse(mStream);

                // 3񃊃gC
                for (int iii = 0; iii < 3; iii++)
                {
                    writeBuf = new byte[12 + 3 + 2];
                    writeBuf[0] = 0x73;// 's'
                    writeBuf[1] = 0x65;// 'e'
                    writeBuf[2] = 0x74;// 't'
                    writeBuf[3] = 0x20;// ' '
                    writeBuf[4] = 0x73;// 's'
                    writeBuf[5] = 0x79;// 'y'
                    writeBuf[6] = 0x73;// 's'
                    writeBuf[7] = 0x20;// ' '
                    writeBuf[8] = 0x6C;// 'l'
                    writeBuf[9] = 0x65;// 'e'
                    writeBuf[10] = 0x64;// 'd'
                    writeBuf[11] = 0x20;// ' '
                    writeBuf[12] = 0x30;// 3
                    writeBuf[13] = 0x78;// [0x2]
                    writeBuf[14] = 0x32;// Ƃ
                    writeBuf[15] = 0x0d;
                    writeBuf[16] = 0x0a;
                    // M
                    writeCommand(mStream, writeBuf);
                    Thread.Sleep(500);
                    // X|Xf[^̎M
                    resultBuf = readResponse(mStream);

                    Thread.Sleep(1000);

                    writeBuf = new byte[12 + 3 + 2];
                    writeBuf[0] = 0x73;// 's'
                    writeBuf[1] = 0x65;// 'e'
                    writeBuf[2] = 0x74;// 't'
                    writeBuf[3] = 0x20;// ' '
                    writeBuf[4] = 0x73;// 's'
                    writeBuf[5] = 0x79;// 'y'
                    writeBuf[6] = 0x73;// 's'
                    writeBuf[7] = 0x20;// ' '
                    writeBuf[8] = 0x6C;// 'l'
                    writeBuf[9] = 0x65;// 'e'
                    writeBuf[10] = 0x64;// d'
                    writeBuf[11] = 0x20;// ' '
                    writeBuf[12] = 0x30;// 3
                    writeBuf[13] = 0x78;// [0x3]
                    writeBuf[14] = 0x33;// Ƃ
                    writeBuf[15] = 0x0d;
                    writeBuf[16] = 0x0a;
                    // M
                    writeCommand(mStream, writeBuf);
                    Thread.Sleep(500);
                    // X|Xf[^̎M
                    resultBuf = readResponse(mStream);

                    Thread.Sleep(1000);
                }

                // [h߂
                writeBuf = new byte[4 + 2];
                //writeBuf = Encoding.ASCII.GetBytes("exit\r\n");
                writeBuf[0] = 0x65;// 'e'
                writeBuf[1] = 0x78;// 'x'
                writeBuf[2] = 0x69;// 'i'
                writeBuf[3] = 0x74;// 't'
                writeBuf[4] = 0x0d;
                writeBuf[5] = 0x0a;
                // M
                writeCommand(mStream, writeBuf);
                // X|Xf[^̎M
                resultBuf = readResponse(mStream);

                // Xg[N[Y
                if (mStream != null)
                {
                    mStream.Dispose();
                    mStream = null;
                }
                // \PbgN[Y
                if (mClient != null)
                {
                    mClient.Dispose();
                    mClient = null;
                }

                // {^L
                EnableBtn(BtnReScan, true);
                EnableBtn(BtnLED, true);
                EnableBtn(BtnTCPIP, true);
                EnableBtn(BtnComPort, true);
                EnableBtn(BtnExit, true);

                // LEDbZ[WI
                FrmLEDMsg.Close();
                FrmLEDMsg.Dispose();

                // LEDbZ[WXbhI
                LEDMsgThread.Interrupt();
                LEDMsgThread.Join();
            }
            catch (Exception ex)
            {
                // {^L
                EnableBtn(BtnReScan, true);
                EnableBtn(BtnLED, true);
                EnableBtn(BtnTCPIP, true);
                EnableBtn(BtnComPort, true);
                EnableBtn(BtnExit, true);

                // LEDbZ[WI
                FrmLEDMsg.Close();
                FrmLEDMsg.Dispose();

                // LEDbZ[WXbhI
                LEDMsgThread.Interrupt();
                LEDMsgThread.Join();
                return;
            }
        }

        // LEDbZ[W
        private void LEDMsgProc()
        {
            FrmLEDMsg = new FrmLED();
            FrmLEDMsg.ShowDialog();
        }


        public static bool writeCommand(Stream mOutputStream, byte[] writeBuf)
        {
            // obt@łȂ
            if (writeBuf != null)
            {
                try
                {
                    if (mOutputStream != null)
                    {
                        // w肳ꂽoCgzo̓Xg[ɏ
                        mOutputStream.Write(writeBuf, 0, writeBuf.Length);
                        // o̓Xg[
                        //mOutputStream.Flush();
                        return true;
                    }
                }
                catch (Exception ex)
                {
                    Debug.WriteLine(ex.Message);
                }
            }
            return false;
        }

        public static byte[] readResponse(NetworkStream mInputStream)
        {
            int TotalCount = 0;

            using (var memStream = new MemoryStream())
            {
                try
                {
                    if (mInputStream != null)
                    {
                        byte[] rcvBuf = new byte[256];
                        int readCount;
                        mInputStream.ReadTimeout = 1000;
                        while ((readCount = mInputStream.Read(rcvBuf, 0, rcvBuf.Length)) > 0)
                        {
                            //Mf[^~ς
                            memStream.Write(rcvBuf, TotalCount, rcvBuf.Length);
                            TotalCount += readCount;
                        }
                        return memStream.ToArray();
                    }
                }
                catch (IOException ioe)
                {
                    // f[^
                    if (TotalCount > 0)
                        return memStream.ToArray();

                    Debug.WriteLine(ioe.Message);
                }
                catch (SocketException se)
                {
                    // f[^
                    if (TotalCount > 0)
                        return memStream.ToArray();

                    Debug.WriteLine(se.Message);
                }
                catch (Exception ex)
                {
                    // f[^
                    if (TotalCount > 0)
                        return memStream.ToArray();

                    Debug.WriteLine(ex.Message);
                }
                return null;
            }
        }

        // TCP/IPڑ
        private void BtnTCPIP_Click(object sender, EventArgs e)
        {
            if (LstDevice.Items.Count > 0)
            {
                // IĂȂȂI
                if (LstDevice.SelectedIndices.Count == 0)
                {
                    MessageBox.Show("foCXIĂ܂");
                    return;
                }


                Terminal FrmTerminal = new Terminal();
                // \
                this.Visible = false;

                // TCP/IP[h
                FrmTerminal.IPAdrs = LstDevice.SelectedItems[0].SubItems[1].Text;
                FrmTerminal.connectType = 0;
                FrmTerminal.ShowDialog();

                // \
                this.Visible = true;
            }
            else
            {
                MessageBox.Show("foCX܂");
            }
        }

        // COM|[gڑ
        private void BtnComPort_Click(object sender, EventArgs e)
        {
            Terminal FrmTerminal = new Terminal();
            // \
            this.Visible = false;

            // COM[h
            FrmTerminal.PortName = CmbComPort.GetItemText(CmbComPort.SelectedItem);
            FrmTerminal.connectType = 1;
            FrmTerminal.ShowDialog();

            // \
            this.Visible = true;
        }

        // XL
        private void ReScan()
        {
            // foCX폜
            TxtSelectDevice.Text = string.Empty;
            // {^
            EnableBtn(BtnReScan, false);
            EnableBtn(BtnLED, false);
            EnableBtn(BtnTCPIP, false);
            EnableBtn(BtnComPort, false);
            EnableBtn(BtnExit, false);

            // Xbh
            DeviceScanThread = new Thread(DeviceScanProc);
            DeviceScanThread.Start();
        }

        // XLbZ[W
        private void DeviceScanMsgProc()
        {
            try
            {
                FrmScanMsg = new FrmScan();
                FrmScanMsg.ShowDialog();
            }
            catch (ThreadInterruptedException ex)
            {

            }
        }

        // XL
        private void DeviceScanProc()
        {
            // bZ[WXbh
            DeviceScanMsgThread = new Thread(DeviceScanMsgProc);
            DeviceScanMsgThread.Start();

            // TCO/IP
            SearchDevice();
            // COM
            SearchCom();

            // {^L
            EnableBtn(BtnReScan, true);
            EnableBtn(BtnLED, true);
            EnableBtn(BtnTCPIP, true);
            EnableBtn(BtnComPort, true);
            EnableBtn(BtnExit, true);

            // bZ[WI
            FrmScanMsg.Close();
            FrmScanMsg.Dispose();

            // bZ[WXbhI
            DeviceScanMsgThread.Interrupt();
            DeviceScanMsgThread.Join();
        }

        // TCO/IP
        private void SearchDevice()
        {
            bool fCheck = false;
            int timeCount;
            DeviceInfo DevInfo;
            int id;

            // Xg
            ClearLst(LstDevice);
            WaitHandle.Reset();

            // o^Xg
            foundList = new ConcurrentDictionary<int, DeviceInfo>();

            // UDPMp̃NCAg𗧂グ
            Task udpReceiveTask = Task.Run(() => udpReceive(true));

            // Cxg҂
            WaitHandle.WaitOne();

            timeCount = 0;
            while (timeCount < 10)
            {
                // UDPMŃf[^擾ĂΔ
                foreach (KeyValuePair<int, DeviceInfo> device in foundList)
                {
                    fCheck = true;

                    id = device.Key;
                    DevInfo = device.Value;
                    // Xgɒǉ
                    string strSSID = DevInfo.SSID;
                    string strMac = DevInfo.MacAdrs;
                    string strVer = DevInfo.Version;
                    string strMode = DevInfo.Mode;
                    string strIPAdrs = DevInfo.IPAdrs;


                    // Mf[^\
                    SetLst(LstDevice, strSSID, strMac, strIPAdrs, strMode, strVer);
                }
                if (fCheck)
                    break;
                Thread.Sleep(1000);
                timeCount++;
            }
        }

        /// UDPŃf[^MA[XgƂIPAhXEMACAhXɊi[
        public static void udpReceive(bool getWiFiMode)
        {
            DeviceInfo DevInfo;
            int timeCount;
            int id;
            Boolean Status;
            string strdata1;
            string strdata2;
            string strdata3;
            string strdata4;
            int FirstIP = 0;

            try
            {
                // UDPݒ
                rcvClient = new UdpClient(new IPEndPoint(IPAddress.Any, 5073));
                rcvClient.Client.ReceiveTimeout = 20000;

                timeCount = 0;
                while (true)
                {
                    IPEndPoint remoteEP = new IPEndPoint(IPAddress.Any, 0);
                    // NGXgM
                    var result = rcvClient.Receive(ref remoteEP);
                    // |[g5073̏ꍇ
                    if (remoteEP.Port == 5073)
                    {
                        byte[] rcvData = result;
                        int iii;
                        int StartPos = 0;
                        int EndPos = 0;
                        for (iii = 0; iii < rcvData.Length; iii++)
                        {
                            if (rcvData[iii] == 0x56)// 'V'
                                if (rcvData[iii + 1] == 0x65)// 'e'
                                    if (rcvData[iii + 2] == 0x72)// 'r'
                                        StartPos = iii + 3;
                        }
                        for (iii = StartPos; iii < rcvData.Length; iii++)
                        {
                            if (rcvData[iii] == 0x2C)// ','
                                EndPos = iii;
                        }
                        byte[] Verbyte = new byte[EndPos - StartPos];
                        for (iii = StartPos; iii < EndPos; iii++)
                        {
                            Verbyte[iii - StartPos] = rcvData[iii];
                        }
                        string strVer = Encoding.ASCII.GetString(Verbyte);
                        string strMode; ;
                        // 
                        if (rcvData[6] == 0x00)
                            strMode = "CtXgN`";
                        else if (rcvData[6] == 0x01)
                            strMode = "ANZX|Cg";
                        else
                            strMode = "Provisioning";
                        string strMac = string.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:", rcvData[0], rcvData[1], rcvData[2], rcvData[3], rcvData[4], rcvData[5]);

                        string strSSID = Encoding.ASCII.GetString(rcvData, 0x6A, 32);


                        DevInfo.SSID = strSSID;
                        DevInfo.MacAdrs = strMac;
                        DevInfo.Mode = strMode;
                        DevInfo.Version = strVer;
                        DevInfo.IPAdrs = remoteEP.Address.ToString();

                        strdata1 = DevInfo.IPAdrs;
                        // 1ߌ
                        StartPos = strdata1.IndexOf(".");
                        strdata2 = strdata1.Substring(StartPos + 1, strdata1.Length - StartPos - 1);
                        // 2ߌ
                        StartPos = strdata2.IndexOf(".");
                        strdata3 = strdata2.Substring(StartPos + 1, strdata2.Length - StartPos - 1);
                        // 3ߌ
                        StartPos = strdata3.IndexOf(".");
                        strdata4 = strdata3.Substring(StartPos + 1, strdata3.Length - StartPos - 1);

                        // IPAdrs̍ŌIdƂ
                        id = int.Parse(strdata4);

                        if (FirstIP == 0)
                            FirstIP = id;
                        else
                        {
                            // IPAhXM
                            if (id == FirstIP)
                                break;
                        }
                        
                        // MACAhX/ڑIP/o[WXgɊi[
                        Status = foundList.TryAdd(id, DevInfo);
                    }

                    timeCount++;
                    if (timeCount > 10 )
                    {
                        break;
                    }
                }

                // N[Y
                rcvClient.Close();

                // Cxgݒ
                WaitHandle.Set();
            }
            catch (ObjectDisposedException)
            {
                // OŔj(=ؒf)ĂꍇȂ
                // Cxgݒ
                WaitHandle.Set();
            }
            catch (NullReferenceException nre)
            {
                //PlusDebug.WriteLine(nre.Message);
                // Cxgݒ
                WaitHandle.Set();
            }
            catch (SocketException se)
            {
                //PlusDebug.WriteLine(se.Message);
                // Cxgݒ
                WaitHandle.Set();
            }
        }

        private void LstDevice_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (LstDevice.SelectedItems.Count > 0)
            {
                // IĂȂȂI
                if (LstDevice.SelectedItems[0].Index < 0)
                    return;

                // foCX\
                TxtSelectDevice.Text = LstDevice.SelectedItems[0].SubItems[0].Text;
            }
            else
            {
                // foCX폜
                TxtSelectDevice.Text = string.Empty;
            }
        }

        // COM
        private void SearchCom()
        {
            // R{{bNX
            ClearCmb(CmbComPort);

            // WXg猟
            //L[ǂݎpŊJ
            Microsoft.Win32.RegistryKey regkey =
                Microsoft.Win32.Registry.LocalMachine.OpenSubKey("HARDWARE\\DEVICEMAP\\SERIALCOMM", false);
            //L[݂ȂƂ null Ԃ
            if (regkey != null)
            {
                //ǂݍ
                string[] stringValue = regkey.GetValueNames();

                foreach (string k in stringValue)
                {
                    string strings = (string)regkey.GetValue(k);
                    // ǉ
                    SetCmb(CmbComPort, strings);
                }
                // 
                regkey.Close();
            }
        }
    }
}
