
// RS-WF62Dlg.h : wb_[ t@C
//

#pragma once
#include "afxwin.h"
#include "afxcmn.h"

// ꎞpt@C
#define BAT_FILE L"cmd.bat"
#define TABLE_FILE L"arp.txt"

// gp|[g
#define PORT_UDP 5073
#define PORT_TCP 5074

#define UDP_WAIT_TIME 10
#define GPIO_LENGTH 5

#define SOCK_ARG_BLOCKING 0
#define SOCK_ARG_NON_BLOCKING 1

#define SOCK_ARG_NON_BLOCKING 1

#define MAX_AP 20
#define MAX_DEVICE 4	// 4܂Ō
#define IP_LENGTH 16
#define MAC_ADD_LENGTH 20
#define RECEIVE_BUFF_SIZE 2048
#define SEND_BUFF_SIZE 2048
#define COM_NAME_SIZE 256
#define SEND_STR_SIZE 256
#define DEV_COLUMN_COUNT 4

#define DEV_NAME L"RS-WF62_"

#define OLD_VER L"2.38.3"

// R}h
#define CMD_SET_SYS_LED L"set sys led "

#define CMD_PARA_IOFUNC_2 L"0x2"
#define CMD_PARA_IOFUNC_3 L"0x3"

#define COM_WAIT_TIME 500
#define WAIT_CMD_TIME 500
#define MSEC_1000 1000
#define MSEC_30 30
#define MSEC_250 250
#define MSEC_500 500
#define MSEC_5000 5000
#define WAIT_PENDING_TIME 10000

// XbhpbZ[W
#define WM_RECEIVE_THREAD_MESSAGE WMID_RECEIVE_DATA
#define WM_SEND_ERR_MESSAGE WMID_SEND_ERR
#define WM_BLINK_START_MESSAGE WMID_BLINK_START
#define WM_SEARCH_START_MESSAGE WMID_SEARCH_START
#define WM_SEARCH_FINISHED_MESSAGE WMID_SEARCH_FINISHED
#define WM_BLINK_FINISHED_MESSAGE WMID_BLINK_FINISHED


// EBhEbZ[WID
enum
{
	WMID_RECEIVE_DATA = WM_APP+1,
	WMID_SEND_ERR,
	WMID_BLINK_START,
	WMID_SEARCH_START,
	WMID_SEARCH_FINISHED,
	WMID_BLINK_FINISHED
};

// foCXI_CAO̗
enum
{
	DEV_LIST_NAME,
	DEV_LIST_ADDRESS,
	DEV_LIST_MODE,
	DEV_LIST_VERSION
};

// ^C}[ID
#define TMID_STOP_LED 1

// G[R[h
enum
{
	ERR_SUCCESS = 0,
	ERR_SOCK_NO_REC_DATA,
	ERR_SOCK_SEND_DATA_FAILED,
	ERR_WRONG_PASSWD,
	ERR_WRONG_CMD,
	ERR_CMD_ATHER_ERR,
	ERR_OPEN_WLAN_FAILED,
	ERR_ADHOC_ON,
	ERR_ADHOC_OFF,
	ERR_LOCKED_DEVICE,
	ERR_SELECT_TIME_OUT
};

// ڑ[h
enum
{
	CONNECT_SOCK,
	CONNECT_COM
};

//UDPŎM
struct UdpInfo
{
	CString ipAddress;
	CString version;
	CString macadrs;
	CString mode;
};

// RS-WF62̏
struct DeviceInfo
{
	CString name;
	CString ipAddress;
	CString mode;
	CString version;
};

UINT ledCheckThread(LPVOID pDlg);
UINT deviceScanThread(LPVOID pDlg);

// CRSWF62Dlg _CAO
class CRSWF62Dlg : public CDialog
{
// RXgNV
public:
	CRSWF62Dlg(CWnd* pParent = NULL);	// WRXgN^

// _CAO f[^
	enum { IDD = IDD_RSWF62_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV T|[g


// 
protected:
	HICON m_hIcon;

	// ꂽAbZ[W蓖Ċ֐
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	volatile CWinThread* m_deviceScanThread;
	volatile CWinThread* m_ledCheckThread;

	CString m_strSend;
	CString m_strReceive;
	CString m_devPassword;
	CString m_selectedDev;

	CListCtrl m_deviceList;
	CComboBox m_comList;

	afx_msg void OnBnClickedButtonRescan();
	afx_msg void OnBnClickedButtonLed();
	afx_msg void OnBnClickedButtonConnectTelnet();
	afx_msg void OnBnClickedButtonConnectCom();
	afx_msg void OnLvnItemchangedListDevice(NMHDR *pNMHDR, LRESULT *pResult);

	afx_msg LRESULT showScanDialog(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT showLedDialog(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT updateDeviceList(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT hideLedDialog(WPARAM wParam, LPARAM lParam);

	int openSocket(CString address);
	void endSocket(SOCKET socket);
	UINT receiveSockData(BOOL isBlocking = TRUE);
	int sendSockData(CString sendData);
	int enterCmdMode(CString address, BOOL isFromSearch = FALSE);
	CString getParaValue(CString orgString, CString targetPara);
	void searchDevice(void);
	void switchDisable(void);
	CString getSelectedDevice(UINT targetItem);
	void setDeviceList(DeviceInfo deviceInfo[], UINT deviceCount);
	int checkGPIO9(void);
	void searchCom(void);
	BOOL checkSelection(void);
	void blinkLed(void);
};
