// terminalDialog.cpp : t@C
//

#include "stdafx.h"
#include "RS-WF62.h"
#include "terminalDialog.h"
#include "RS-WF62Dlg.h"


extern CRSWF62Dlg* g_mainDlg;
extern SOCKET g_tcpSock;
extern char g_readData[RECEIVE_BUFF_SIZE];
extern BOOL g_isShowReadDataBusy;
extern char g_notDisplayedData[RECEIVE_BUFF_SIZE];
extern BOOL isSockTerminal;

// COM|[g
HANDLE g_hPort = NULL;
static OVERLAPPED g_ovlpdRead;
static OVERLAPPED g_ovlpdSend;
TCHAR g_sendData[SEND_BUFF_SIZE];

// terminalDialog _CAO

IMPLEMENT_DYNAMIC(terminalDialog, CDialog)

terminalDialog::terminalDialog(CWnd* pParent /*=NULL*/)
	: CDialog(terminalDialog::IDD, pParent)
	, m_strSend(_T(""))
	, m_strReceive(_T(""))
	, m_comReadThread(NULL)
	, m_comSendThread(NULL)
	, m_sockReadThread(NULL)
	, m_connectType(FALSE)
{

}

terminalDialog::~terminalDialog()
{
}

void terminalDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_SEND, m_strSend);
	DDX_Text(pDX, IDC_EDIT_RECEIVE, m_strReceive);
}


BEGIN_MESSAGE_MAP(terminalDialog, CDialog)
	ON_MESSAGE(WM_RECEIVE_THREAD_MESSAGE, showReadData)
	ON_MESSAGE(WM_SEND_ERR_MESSAGE, showSendErrorDialog)
	ON_BN_CLICKED(IDC_SEND, &terminalDialog::OnBnClickedSend)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, &terminalDialog::OnBnClickedButtonClear)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, &terminalDialog::OnBnClickedButtonDisconnect)
	ON_WM_DESTROY()
END_MESSAGE_MAP()

//--------------------------------------------------------
//e
// COM|[g̎MpXbh
//
// LPVOID pDlg: Ăяo_CAOւ̃|C^
//߂l
// 0
//--------------------------------------------------------
UINT ComReadThread(LPVOID pDlg)
{
	DWORD dwEvent;
	DWORD dwRead;
	DWORD dwEndtime;
	DWORD err;
	int readDataLen = 0;
	char inBuff[RECEIVE_BUFF_SIZE] = {0};

	// ĎCxg}XNBEV_RXCHAR̓f[^M
	SetCommMask(g_hPort, EV_RXCHAR);
	while(((terminalDialog*)pDlg)->m_comReadThread != NULL)
	{
		// COMCxg҂
		WaitCommEvent(g_hPort, &dwEvent, NULL);
		if((dwEvent & EV_RXCHAR) == EV_RXCHAR)
		{
			while(g_isShowReadDataBusy == TRUE)
			{
				Sleep(MSEC_30);
			}
			dwRead = 0;
			// f[^M
			if(ReadFile(g_hPort, inBuff, RECEIVE_BUFF_SIZE, &dwRead, &g_ovlpdRead) == 0)
			{
				err = GetLastError();
				dwRead = 0;
				// ERROR_IO_PENDINĜƂReadFile()̌ʂG[ł
				if(err == ERROR_IO_PENDING)
				{
					dwEndtime = GetTickCount() + WAIT_PENDING_TIME;
					// TRUEɂȂ
					while(!GetOverlappedResult(g_hPort, &g_ovlpdRead, &dwRead, FALSE))
					{
						if(GetTickCount() > dwEndtime)
						{
							break;
						}
					}
				}
			}
			if(err == 0 || err == ERROR_IO_PENDING)
			{
				if(dwRead)
				{
					// Mf[^Rs[ă_CAOɎMbZ[W𑗂
					readDataLen = dwRead;
					memset(g_notDisplayedData, NULL, RECEIVE_BUFF_SIZE);
					memcpy(g_notDisplayedData, inBuff, readDataLen);

					((CDialog*)pDlg)->PostMessage(WM_RECEIVE_THREAD_MESSAGE, 0, 0);
				}
			}
		}
	}
	
	return 0;
}


//--------------------------------------------------------
//e
// COM|[g̑MpXbh
//
// LPVOID pDlg: Ăяo_CAOւ̃|C^
//߂l
// 0
//--------------------------------------------------------
UINT ComSendThread(LPVOID pDlg)
{
	BOOL ret;
	DWORD dwEndtime;
	CString sendStr;

	sendStr.Format(L"%s", g_sendData);
	memset(g_sendData, 0, sizeof(g_sendData));
	while(((terminalDialog*)pDlg)->m_comSendThread != NULL)
	{
		DWORD dwSendSize;	// Mf[^TCY

		ret = WriteFile(g_hPort, sendStr, sendStr.GetLength()*2, &dwSendSize, &g_ovlpdSend);
		if(ret == FALSE)
		{
			if(GetLastError() == ERROR_IO_PENDING)
			{
				dwEndtime = GetTickCount() + WAIT_PENDING_TIME;
				// TRUEɂȂ
				while(GetOverlappedResult(g_hPort, &g_ovlpdSend, &dwSendSize, FALSE) == FALSE)
				{
					if(GetTickCount() > dwEndtime)
					{
						break;
					}
				}
			}
			else
			{
				CloseHandle(g_hPort);
				g_hPort = NULL;
				((CDialog*)pDlg)->PostMessage(WM_SEND_ERR_MESSAGE, 0, 0);
				return 0;
			}
		}
		sendStr.Empty();
		((terminalDialog*)pDlg)->m_comSendThread = NULL;
		return 0;
	}

	return 0;
}

//--------------------------------------------------------
//e
// socket̎MpXbh
//
// LPVOID pDlg: Ăяo_CAOւ̃|C^
//߂l
// 0
//--------------------------------------------------------
UINT socketReadThread(LPVOID pDlg)
{
	UINT ret;

	memset(g_readData, 0, sizeof(g_readData));
	memset(g_notDisplayedData, 0, sizeof(g_notDisplayedData));

	while(((terminalDialog*)pDlg)->m_sockReadThread != NULL)
    {
		while(g_isShowReadDataBusy == TRUE)
		{
			Sleep(MSEC_30);
		}
		// f[^M
		ret = g_mainDlg->receiveSockData(FALSE);
		if(ret == ERR_SUCCESS)
		{
			// _CAOɎMbZ[W𑗂
			((CDialog*)pDlg)->PostMessage(WM_RECEIVE_THREAD_MESSAGE, 0, 0);
		}
    }
	
	return 0;
}

// terminalDialog bZ[W nh


//--------------------------------------------------------
//e
// RS-WF62̎Mf[^eLXg{bNXɕ`
//:
// WPARAM wParam: bZ[W
// LPARAM lParam: bZ[W
//߂l
// 0
//--------------------------------------------------------
LRESULT terminalDialog::showReadData(WPARAM wParam, LPARAM lParam)
{
	g_isShowReadDataBusy = TRUE;
	// MGfBbg{bNX̕\
	m_strReceive += g_notDisplayedData;

	UpdateData(FALSE);

	// MGfBbg{bNX̃J[\Ō
	int pos = m_strReceive.GetLength();
	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_EDIT_RECEIVE);
	pEdit->SetSel(pos, pos);

	memset(g_notDisplayedData, 0, sizeof(g_notDisplayedData));

	g_isShowReadDataBusy = FALSE;
	return 0;
}

//--------------------------------------------------------
//e
// MXbh̃G[bZ[W{bNXŕ\
//
// WPARAM wParam: bZ[W
// LPARAM lParam: bZ[W
//߂l
// 0
//--------------------------------------------------------
LRESULT terminalDialog::showSendErrorDialog(WPARAM wParam, LPARAM lParam)
{
	AfxMessageBox(IDS_STRING_SEND_ERR);
	return 0;
}

//--------------------------------------------------------
//e
// uMv{^̃NbNCxg
// uMf[^vGfBbg{bNX̕RS-WF62ɑM
//
// Ȃ
//߂l
// Ȃ
//--------------------------------------------------------
void terminalDialog::OnBnClickedSend()
{
	UpdateData(TRUE);

	if(m_strSend == L"")
	{
		return;
	}

	// Mf[^
	CString sendStr = m_strSend;
	char strTmp[SEND_BUFF_SIZE*2];
	int dataLength = 0;
	int i, j;

	// f[^̑M
	// COM
	if(m_connectType == CONNECT_COM)
	{
		// G[̃NA
		COMSTAT Comstat;	//  ʐMfoCX\
		DWORD dwErrorMask;	//  G[R[h󂯎ϐ
		ClearCommError(g_hPort, &dwErrorMask, &Comstat); 

		// XbhŎgp邽char[]ɕϊ
		memset(g_sendData, 0, sizeof(g_sendData));
		memset(strTmp, 0, sizeof(strTmp));
		dataLength = sendStr.GetLength();
		memcpy(strTmp, sendStr, dataLength*2);
		// 1oCg0̂Ŏ菜
		for(i=0, j=0; i<dataLength*2; i+=2, j++)
		{
			g_sendData[j] = strTmp[i];
		}
		// Xbhݒ
		if(m_comSendThread == NULL)
		{
			m_comSendThread = AfxBeginThread(ComSendThread, this);
		}
	}
	// Socket
	else
	{
		// ̑M
		if(g_mainDlg->sendSockData(sendStr) == SOCKET_ERROR)
		{
			AfxMessageBox(IDS_STRING_RECEIVE_DATA_FAILED);
		}
	}
	// eLXgGÃNA
	m_strSend.Empty();

	UpdateData(FALSE);
}

//--------------------------------------------------------
//e
// uMf[^̃NAv{^̃NbNCxg
// uMf[^veLXgGA̕NA
//
// Ȃ
//߂l
// Ȃ
//--------------------------------------------------------
void terminalDialog::OnBnClickedButtonClear()
{
	m_strReceive.Empty();
	UpdateData(FALSE);
}

//--------------------------------------------------------
//e
// uؒfv{^̃NbNCxg
// \[XJA_CAO
//
// Ȃ
//߂l
// Ȃ
//--------------------------------------------------------
void terminalDialog::OnBnClickedButtonDisconnect()
{
	// \[X̊J
	releaseResources();
	OnOK();
}

//--------------------------------------------------------
//e
// C_CAOőI@RS-WF62Ƃ̒ʐMJn
//   uTCP/IPŐڑvNbN:
//     ufoCX̑IvXgRg[őI𒆂IPAhX
//     \PbgŐڑAMXbhJn
//   uCOM|[gɐڑvNbN:
//     I𒆂COM|[gJ
//
// Ȃ
//߂l TRUE
//--------------------------------------------------------
BOOL terminalDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// IME̖
	ImmAssociateContext(GetDlgItem(IDC_EDIT_SEND)->GetSafeHwnd(), NULL);

	CString str;

	// TCP/IP
	if(m_connectType == CONNECT_SOCK)
	{
		if(g_mainDlg->m_deviceList.GetFirstSelectedItemPosition() == NULL)
		{
			AfxMessageBox(IDS_STRING_NOT_SELECTED);
			EndDialog(IDCANCEL);
			return TRUE;
		}

		str.LoadString(IDS_STRING_TITLE_TCP);
		this->SetWindowTextW(str);

		int ret;
		// \Pbg̃I[v
		ret = g_mainDlg->openSocket(g_mainDlg->getSelectedDevice(DEV_LIST_ADDRESS));
		// \Pbg̃I[vɎs
		if(ret != 0)
		{
			AfxMessageBox(IDS_STRING_SOCK_OPEN_ERR);
		}
		else
		{
			// MXbhJn
			if(m_sockReadThread == NULL)
			{
				m_sockReadThread = AfxBeginThread(socketReadThread, this);
			}
		}
	}
	// COM|[g
	else
	{
		str.LoadString(IDS_STRING_TITLE_COM);
		this->SetWindowTextW(str);

		BOOL ret;
		CString comNum;		// COM|[gԍ
		CString comName;	// \\.\COM|[g
		g_mainDlg->m_comList.GetLBText(g_mainDlg->m_comList.GetCurSel(), comNum);
		comName = L"\\\\.\\" + comNum;

		// COM|[g̃I[v
		g_hPort = CreateFile(comName, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
		if(g_hPort == INVALID_HANDLE_VALUE)
		{
			AfxMessageBox(IDS_STRING_COM_OPEN_FAILED);
			EndDialog(IDCANCEL);
			return TRUE;
		}

		// Mobt@
		// COM̐ݒ
		ret = SetupComm(g_hPort, RECEIVE_BUFF_SIZE, SEND_BUFF_SIZE);
		if(ret == FALSE)
		{
			AfxMessageBox(IDS_STRING_COM_SET_FAILED);
			CloseHandle(g_hPort);
			g_hPort = NULL;
			EndDialog(IDCANCEL);
			return TRUE;
		}
		// 
		ret = PurgeComm(g_hPort, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
		if(ret == FALSE)
		{
			AfxMessageBox(IDS_STRING_COM_PURGE_FAILED);
			CloseHandle(g_hPort);
			g_hPort = NULL;
			EndDialog(IDCANCEL);
			return TRUE;
		}

		// ʐM̐ݒ
		DCB dcb;
		ret = GetCommState(g_hPort, &dcb);
		dcb.DCBlength = sizeof(DCB);

		dcb.BaudRate = 115200;		// {[[g115200
		dcb.ByteSize = 8;			// f[^TCY8bit
		dcb.StopBits = ONESTOPBIT;	// Xgbvrbg1bit		
		dcb.fParity = NOPARITY;		// peB`FbNȂ

		dcb.fOutxCtsFlow = FALSE;	// n[hEFAt[Ȃ
		dcb.fRtsControl = RTS_CONTROL_DISABLE;		

		dcb.fOutX = FALSE;			// \tgEFAt[Ȃ
		dcb.fInX = FALSE;

		dcb.fNull = TRUE;			// G[֘A
		dcb.fAbortOnError = TRUE;
		dcb.fErrorChar = FALSE;
		dcb.ErrorChar = 0x00;

		// dcb̒l𔽉f
		ret = SetCommState(g_hPort, &dcb);
		if(ret == FALSE)
		{
			AfxMessageBox(IDS_STRING_COM_SET_FAILED);
			CloseHandle(g_hPort);
			g_hPort = NULL;
			EndDialog(IDCANCEL);
			return TRUE;
		}

		// ^CAEgԂ̐ݒ
		COMMTIMEOUTS timeout;
		timeout.ReadIntervalTimeout = COM_WAIT_TIME;
		timeout.ReadTotalTimeoutMultiplier = 0;
		timeout.ReadTotalTimeoutConstant = COM_WAIT_TIME;
		timeout.WriteTotalTimeoutMultiplier = 0;
		timeout.WriteTotalTimeoutConstant = COM_WAIT_TIME;
		SetCommTimeouts(g_hPort, &timeout);

		// Xbhݒ
		if(m_comReadThread == NULL)
		{
			m_comReadThread = AfxBeginThread(ComReadThread, this);
		}
	}
	isSockTerminal = TRUE;
	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

//--------------------------------------------------------
//e
// XbhIA\[XJ
//
// Ȃ
//߂l
// Ȃ
//--------------------------------------------------------
void terminalDialog::releaseResources(void)
{
	// ʐMł΃\[XJ
	if(m_comReadThread != NULL)
	{
		if(!((g_hPort == NULL) || (g_hPort == INVALID_HANDLE_VALUE)))
		{
			CloseHandle(g_hPort);
			g_hPort = NULL;
		}
		m_comReadThread = NULL;
	}
	if(m_comSendThread != NULL)
	{
		if(!((g_hPort == NULL) || (g_hPort == INVALID_HANDLE_VALUE)))
		{
			CloseHandle(g_hPort);
			g_hPort = NULL;
		}
		m_comSendThread = NULL;
	}
	if(m_sockReadThread != NULL)
	{
		g_mainDlg->endSocket(g_tcpSock);
		m_sockReadThread = NULL;
	}
	isSockTerminal = FALSE;
}

//--------------------------------------------------------
//e
// _CAOICxg
// IRS-WF62ɐڑ̏ꍇ͐ؒf
//
// Ȃ
//߂l
// Ȃ
//--------------------------------------------------------
void terminalDialog::OnDestroy()
{
	CDialog::OnDestroy();

	// \[X̊J
	releaseResources();
}
