using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace RSSG2010
{
    public partial class RSSG2010 : Form
    {
        UInt32 hCom;
        byte[] MacAdrs = new byte [17*8];
        byte[] CmbMacAdrsBuf = new byte[8];
        Boolean fStart;
        Boolean[] fGP10Start = new Boolean[17];

        private RSSG2000.DLL.ErrorCallback ErrorFunc;
        private RSSG2000.DLL.TriggerCallback TriggerFunc;
        private RSSG2000.DLL.RegistCallback RegistFunc;


        delegate void SetTextCallback(TextBox textBox, string text);
        private void SetText(TextBox textBox, string text)
        {
            // 呼び出し元のコントロールのスレッドが異なるか確認をする
            if (textBox.InvokeRequired)
            {
                // 同一メソッドへのコールバックを作成する
                SetTextCallback delegateMethod = new SetTextCallback(SetText);

                // コントロールの親のInvoke()メソッドを呼び出すことで、呼び出し元の
                // コントロールのスレッドでこのメソッドを実行する
                this.BeginInvoke(delegateMethod, new object[] { textBox, text });
            }
            else
            {
                // コントロールを直接呼び出す
                textBox.Text = text;
            }
        }

        // コールバック
        unsafe private void CallBackErrorFunc(Byte* pData)
        {
            SetText(TxtMsg, String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackErrorFunc[{8:X2}]", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7], pData[8]));
        }
        unsafe private void CallBackTriggerFunc(Byte* pData)
        {
            byte[] MacAdrsBuf = new byte[8];
            SetText(TxtMsg, String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackTriggerFunc[{8:X2}]", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7], pData[8]));
            // MACアドレス
            MacAdrsBuf[0] = pData[0];   MacAdrsBuf[1] = pData[1];   MacAdrsBuf[2] = pData[2];   MacAdrsBuf[3] = pData[3];
            MacAdrsBuf[4] = pData[4];   MacAdrsBuf[5] = pData[5];   MacAdrsBuf[6] = pData[6];   MacAdrsBuf[7] = pData[7];
            // トリガ無効
            // トリガ設定(ビットマスク:0x00)
            RSSG2000.DLL.RPiGP10Trigger(hCom, MacAdrsBuf, false, Convert.ToByte(TxtTrigger.Text, 16), 0x00);
        }
        unsafe private void CallBackRegistFunc(Byte* pData)
        {
            byte[] MacAdrsBuf = new byte[8];
            SetText(TxtMsg, String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackRegistFunc", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7]));
            // MACアドレス
            MacAdrsBuf[0] = pData[0]; MacAdrsBuf[1] = pData[1]; MacAdrsBuf[2] = pData[2]; MacAdrsBuf[3] = pData[3];
            MacAdrsBuf[4] = pData[4]; MacAdrsBuf[5] = pData[5]; MacAdrsBuf[6] = pData[6]; MacAdrsBuf[7] = pData[7];
            // 登録
            RSSG2000.DLL.RSSG2000RegistMacAdrs(hCom, MacAdrsBuf);

            // コンボボックス追加
            CmbMacAdrs.Items.Add(String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}", MacAdrsBuf[0], MacAdrsBuf[1], MacAdrsBuf[2], MacAdrsBuf[3], MacAdrsBuf[4], MacAdrsBuf[5], MacAdrsBuf[6], MacAdrsBuf[7]));
            CmbMacAdrs.SelectedIndex = 0;
        }


        unsafe public RSSG2010()
        {
            InitializeComponent();

            ErrorFunc = new RSSG2000.DLL.ErrorCallback(CallBackErrorFunc);
            TriggerFunc = new RSSG2000.DLL.TriggerCallback(CallBackTriggerFunc);
            RegistFunc = new RSSG2000.DLL.RegistCallback(CallBackRegistFunc);
        }

        private void RSSG2010_Load(object sender, EventArgs e)
        {
            byte iii;

            // COMポート番号
            TxtCOM.Text = "16";
            // チャンネル
            TxtChannel.Text = "4";
            // 検索台数
            TxtSG20Count.Text = "1";
            // ストローブパルス幅
            TxtStrobe.Text = "100";
            // トリガ発生時の出力データ
            TxtTrigger.Text = "FF";
            // 出力
            TxtOutPort.Text = "FF";
            // 開始フラグ
            for (iii = 0; iii < 17; iii++)
                fGP10Start[iii] = false;
            fStart = false;

            // 無効
            BtnStop.Enabled = false;
            BtnGP10Start.Enabled = false;
            BtnGP10Stop.Enabled = false;
            BtnStrobe.Enabled = false;
            BtnTriggerStart.Enabled = false;
            BtnTriggerStop.Enabled = false;
            BtnOutPort.Enabled = false;
            BtnInPort.Enabled = false;
            BtnGet.Enabled = false;
        }

        private void BtnClear_Click(object sender, EventArgs e)
        {
            // メッセージ削除
            TxtMsg.Text = "";
            BtnClear.Focus();
        }

        unsafe private void BtnStart_Click(object sender, EventArgs e)
        {
            byte iii;
            byte[] Version = new byte[8];
            SByte RSSI;
            double Temp, Humidity;
            byte Count;

            if ((TxtCOM.Text.Length == 0) || (Int32.Parse(TxtCOM.Text) < 1) || (Int32.Parse(TxtCOM.Text) > 255))
            {
                MessageBox.Show("1-255のCOMポート番号を指定してください");
                return;
            }
            if ((TxtChannel.Text.Length == 0) || (Int32.Parse(TxtChannel.Text) < 4) || (Int32.Parse(TxtChannel.Text) > 17))
            {
                MessageBox.Show("4-17のチャンネルを指定してください");
                return;
            }
            if ((TxtSG20Count.Text.Length == 0) || (Int32.Parse(TxtSG20Count.Text) < 1) || (Int32.Parse(TxtSG20Count.Text) > 17))
            {
                MessageBox.Show("1-17の台数を指定してください");
                return;
            }

            Count = 0;
            TxtMsg.Text = "開始中...";
            Application.DoEvents();
            // オープン
            hCom = RSSG2000.DLL.RSSG2000Open(Byte.Parse(TxtCOM.Text), Byte.Parse(TxtChannel.Text), Byte.Parse(TxtSG20Count.Text), RegistFunc);
            if (hCom != 0xFFFFFFFF)
            {
                Array.Clear(MacAdrs, 0, MacAdrs.Length);
                // アドレス取得
                RSSG2000.DLL.RSSG2000GetMacAdrs(hCom, MacAdrs);
                // 表示
                for (iii = 0; iii < 16 * 8; iii += 8)
                {
                    if ((MacAdrs[iii + 0] == 0x00) && (MacAdrs[iii + 1] == 0x00) && (MacAdrs[iii + 2] == 0x00) && (MacAdrs[iii + 3] == 0x00) && (MacAdrs[iii + 4] == 0x00) && (MacAdrs[iii + 5] == 0x00) && (MacAdrs[iii + 6] == 0x00) && (MacAdrs[iii + 7] == 0x00))
                    {
                        ;
                    }
                    else
                    {
                        CmbMacAdrsBuf[0] = MacAdrs[iii + 0];
                        CmbMacAdrsBuf[1] = MacAdrs[iii + 1];
                        CmbMacAdrsBuf[2] = MacAdrs[iii + 2];
                        CmbMacAdrsBuf[3] = MacAdrs[iii + 3];
                        CmbMacAdrsBuf[4] = MacAdrs[iii + 4];
                        CmbMacAdrsBuf[5] = MacAdrs[iii + 5];
                        CmbMacAdrsBuf[6] = MacAdrs[iii + 6];
                        CmbMacAdrsBuf[7] = MacAdrs[iii + 7];

                        // 登録
                        RSSG2000.DLL.RSSG2000RegistMacAdrs(hCom, CmbMacAdrsBuf);

                        // 無効
                        BtnStart.Enabled = false;
                        // 有効
                        BtnStop.Enabled = true;

                        // コンボボックス追加
                        CmbMacAdrs.Items.Add(String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}", MacAdrs[iii + 0], MacAdrs[iii + 1], MacAdrs[iii + 2], MacAdrs[iii + 3], MacAdrs[iii + 4], MacAdrs[iii + 5], MacAdrs[iii + 6], MacAdrs[iii + 7]));
                        Count++;
                    }
                }
                if (Count != 0)
                {
                    CmbMacAdrs.SelectedIndex = 0;
                    // 開始
                    RSSG2000.DLL.RSSG2000Start(hCom);

                    System.Threading.Thread.Sleep(500);
                    // バージョン取得
                    RSSG2000.DLL.RSSG2000GetVersion(hCom, CmbMacAdrsBuf, Version);
                    TxtVersion.Text = String.Format("{0:x}.{1:X2}", Version[0], Version[1]);
                    // RSSI 取得
                    RSSG2000.DLL.RSSG2000GetRSSI(hCom, CmbMacAdrsBuf, &RSSI);
                    TxtRSSI.Text = String.Format("{0:D}", RSSI);
                    // 温湿度取得
                    RSSG2000.DLL.RSSG2000GetTemp(hCom, CmbMacAdrsBuf, &Temp, &Humidity);
                    TxtTemp.Text = String.Format("{0:F1}", Temp);
                    TxtHumidity.Text = String.Format("{0:F1}", Humidity);

                    // 有効
                    BtnGP10Start.Enabled = true;
                    BtnGet.Enabled = true;

                    // 読み取り専用
                    TxtCOM.ReadOnly = true;
                    TxtChannel.ReadOnly = true;
                    TxtSG20Count.ReadOnly = true;

                    fStart = true;
                    if (Count != Byte.Parse(TxtSG20Count.Text))
                    {
                        MessageBox.Show("指定台数のSubGiga入出力ベースボードが見つかりません");
                    }
                }
                else
                {
                    // クローズ
                    RSSG2000.DLL.RSSG2000Close(hCom);
                    hCom = 0xFFFFFFFF;
                    MessageBox.Show("SubGiga入出力ベースボードが見つかりません");
                }
            }
            else
            {
                MessageBox.Show("COMオープンエラー");
            }
            TxtMsg.Text = "";
            BtnStart.Focus();
        }

        private void BtnStop_Click(object sender, EventArgs e)
        {
            byte iii;

            TxtMsg.Text = "停止中...";
            Application.DoEvents();

            if (fStart)
            {
                // 停止
                RSSG2000.DLL.RSSG2000Stop(hCom);

                for (iii = 0; iii < 16 * 8; iii += 8)
                {
                    if ((MacAdrs[iii + 0] == 0x00) && (MacAdrs[iii + 1] == 0x00) && (MacAdrs[iii + 2] == 0x00) && (MacAdrs[iii + 3] == 0x00) && (MacAdrs[iii + 4] == 0x00) && (MacAdrs[iii + 5] == 0x00) && (MacAdrs[iii + 6] == 0x00) && (MacAdrs[iii + 7] == 0x00))
                    {
                        ;
                    }
                    else
                    {
                        CmbMacAdrsBuf[0] = MacAdrs[iii + 0];
                        CmbMacAdrsBuf[1] = MacAdrs[iii + 1];
                        CmbMacAdrsBuf[2] = MacAdrs[iii + 2];
                        CmbMacAdrsBuf[3] = MacAdrs[iii + 3];
                        CmbMacAdrsBuf[4] = MacAdrs[iii + 4];
                        CmbMacAdrsBuf[5] = MacAdrs[iii + 5];
                        CmbMacAdrsBuf[6] = MacAdrs[iii + 6];
                        CmbMacAdrsBuf[7] = MacAdrs[iii + 7];

                        // 削除
                        RSSG2000.DLL.RSSG2000DeleteMacAdrs(hCom, CmbMacAdrsBuf);
                    }
                }
                // クローズ
                RSSG2000.DLL.RSSG2000Close(hCom);
                hCom = 0xFFFFFFFF;
            }

            // 開始フラグ
            for (iii = 0; iii < 17; iii++)
                fGP10Start[iii] = false;
            fStart = false;

            // 有効
            BtnStart.Enabled = true;
            // 無効
            BtnStop.Enabled = false;
            BtnGP10Start.Enabled = false;
            BtnGP10Stop.Enabled = false;
            BtnStrobe.Enabled = false;
            BtnTriggerStart.Enabled = false;
            BtnTriggerStop.Enabled = false;
            BtnOutPort.Enabled = false;
            BtnInPort.Enabled = false;
            BtnGet.Enabled = false;
            // コンボボックス削除
            CmbMacAdrs.Items.Clear();
            TxtMsg.Text = "";
            TxtVersion.Text = "";
            TxtRSSI.Text = "";
            TxtTemp.Text = "";
            TxtHumidity.Text = "";
            // 読み取り専用解除
            TxtCOM.ReadOnly = false;
            TxtChannel.ReadOnly = false;
            TxtSG20Count.ReadOnly = false;
            BtnStop.Focus();
        }

        private void BtnGP10Start_Click(object sender, EventArgs e)
        {
            UInt32 Status;

            TxtMsg.Text = "開始中...";
            Application.DoEvents();

            // GP10オープン
            Status = RSSG2000.DLL.RPiGP10Open(hCom, CmbMacAdrsBuf, TriggerFunc, ErrorFunc);

            if (Status == 0)
            {
                TxtMsg.Text = "";
                // 無効
                BtnGP10Start.Enabled = false;
                // 有効
                BtnGP10Stop.Enabled = true;
                BtnStrobe.Enabled = true;
                BtnTriggerStart.Enabled = true;
                BtnTriggerStop.Enabled = true;
                BtnOutPort.Enabled = true;
                BtnInPort.Enabled = true;
                BtnGet.Enabled = true;

                // 開始フラグ
                fGP10Start[CmbMacAdrs.SelectedIndex] = true;
            }
            else
            {
                TxtMsg.Text = String.Format("RPiGP10Open エラー : {0:X}", Status);
            }
            BtnGP10Start.Focus();
        }

        private void BtnGP10Stop_Click(object sender, EventArgs e)
        {
            TxtMsg.Text = "停止中...";
            Application.DoEvents();

            // 開始フラグ
            fGP10Start[CmbMacAdrs.SelectedIndex] = false;

            RSSG2000.DLL.RPiGP10Trigger(hCom, CmbMacAdrsBuf, false, 0x00, 0x00);
            // GP10クローズ
            RSSG2000.DLL.RPiGP10Close(hCom, CmbMacAdrsBuf);
            TxtMsg.Text = "";

            // 有効
            BtnGP10Start.Enabled = true;
            // 無効
            BtnGP10Stop.Enabled = false;
            BtnInPort.Enabled = false;
            BtnOutPort.Enabled = false;
            BtnTriggerStart.Enabled = false;
            BtnTriggerStop.Enabled = false;
            BtnStrobe.Enabled = false;
            BtnGP10Stop.Focus();
        }

        private void BtnStrobe_Click(object sender, EventArgs e)
        {
            UInt32 Status;

            if ((TxtStrobe.Text.Length == 0) || (Int32.Parse(TxtStrobe.Text) < 0) || (Int32.Parse(TxtStrobe.Text) > 65536))
            {
                MessageBox.Show("0-65536のストローブパルス幅を指定してください");
                return;
            }

            // 無効
            BtnGP10Stop.Enabled = false;
            BtnStrobe.Enabled = false;
            BtnTriggerStart.Enabled = false;
            BtnTriggerStop.Enabled = false;
            BtnOutPort.Enabled = false;
            BtnInPort.Enabled = false;
            BtnGet.Enabled = false;

            // ストローブ設定
            Status = RSSG2000.DLL.RPiGP10StrobeSetting(hCom, CmbMacAdrsBuf, false, UInt32.Parse( TxtStrobe.Text ));
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP10StrobeSetting エラー : {0:X}", Status);
            }
            else
            {
                // ストローブ出力
                Status = RSSG2000.DLL.RPiGP10StrobeOutput(hCom, CmbMacAdrsBuf);
                if (Status != 0)
                {
                    TxtMsg.Text = String.Format("RPiGP10StrobeOutput エラー : {0:X}", Status);
                }
            }

            // 有効
            BtnGP10Stop.Enabled = true;
            BtnStrobe.Enabled = true;
            BtnTriggerStart.Enabled = true;
            BtnTriggerStop.Enabled = true;
            BtnOutPort.Enabled = true;
            BtnInPort.Enabled = true;
            BtnGet.Enabled = true;
            BtnStrobe.Focus();
        }

        private void BtnTriggerStart_Click(object sender, EventArgs e)
        {
            UInt32 Status;

            // 無効
            BtnGP10Stop.Enabled = false;
            BtnStrobe.Enabled = false;
            BtnTriggerStart.Enabled = false;
            BtnTriggerStop.Enabled = false;
            BtnOutPort.Enabled = false;
            BtnInPort.Enabled = false;
            BtnGet.Enabled = false;

            // トリガ有効
            // トリガ設定(ビットマスク:0xFF)
            Status = RSSG2000.DLL.RPiGP10Trigger(hCom, CmbMacAdrsBuf, true, Convert.ToByte(TxtTrigger.Text, 16), 0xFF);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP10Trigger エラー : {0:X}", Status);
            }

            // 有効
            BtnGP10Stop.Enabled = true;
            BtnStrobe.Enabled = true;
            BtnTriggerStart.Enabled = true;
            BtnTriggerStop.Enabled = true;
            BtnOutPort.Enabled = true;
            BtnInPort.Enabled = true;
            BtnGet.Enabled = true;
            BtnTriggerStart.Focus();
        }

        private void BtnTriggerStop_Click(object sender, EventArgs e)
        {
            UInt32 Status;

            // 無効
            BtnGP10Stop.Enabled = false;
            BtnStrobe.Enabled = false;
            BtnTriggerStart.Enabled = false;
            BtnTriggerStop.Enabled = false;
            BtnOutPort.Enabled = false;
            BtnInPort.Enabled = false;
            BtnGet.Enabled = false;

            // トリガ無効
            // トリガ設定(ビットマスク:0x00)
            Status = RSSG2000.DLL.RPiGP10Trigger(hCom, CmbMacAdrsBuf, false, Convert.ToByte(TxtTrigger.Text, 16), 0x00);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP10Trigger エラー : {0:X}", Status);
            }

            // 有効
            BtnGP10Stop.Enabled = true;
            BtnStrobe.Enabled = true;
            BtnTriggerStart.Enabled = true;
            BtnTriggerStop.Enabled = true;
            BtnOutPort.Enabled = true;
            BtnInPort.Enabled = true;
            BtnGet.Enabled = true;
            BtnTriggerStop.Focus();
        }


        private void BtnOutPort_Click(object sender, EventArgs e)
        {
            UInt32 Status;
            Byte bStrobe;

            if (ChkStrobe.Checked == true)
            {
                if ((TxtStrobe.Text.Length == 0) || (Int32.Parse(TxtStrobe.Text) < 0) || (Int32.Parse(TxtStrobe.Text) > 65536))
                {
                    MessageBox.Show("0-65536のストローブパルス幅を指定してください");
                    return;
                }
            }

            // 無効
            BtnGP10Stop.Enabled = false;
            BtnStrobe.Enabled = false;
            BtnTriggerStart.Enabled = false;
            BtnTriggerStop.Enabled = false;
            BtnOutPort.Enabled = false;
            BtnInPort.Enabled = false;
            BtnGet.Enabled = false;

            bStrobe = 0;
            if (ChkStrobe.Checked == true)
            {
                // ストローブ設定
                Status = RSSG2000.DLL.RPiGP10StrobeSetting(hCom, CmbMacAdrsBuf, false, UInt32.Parse(TxtStrobe.Text));
                if (Status != 0)
                {
                    TxtMsg.Text = String.Format("RPiGP10StrobeSetting エラー : {0:X}", Status);
                }
                else
                {
                    // ストローブ出力する
                    bStrobe = 1;
                }
            }
            else
            {
                // ストローブ出力しない
                bStrobe = 0;
            }

            // 出力(ビットマスク:0xFF)
            Status = RSSG2000.DLL.RPiGP10OutPort(hCom, CmbMacAdrsBuf, Convert.ToByte(TxtOutPort.Text, 16), 0xFF, bStrobe);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP10OutPort エラー : {0:X}", Status);
            }

            // 有効
            BtnGP10Stop.Enabled = true;
            BtnStrobe.Enabled = true;
            BtnTriggerStart.Enabled = true;
            BtnTriggerStop.Enabled = true;
            BtnOutPort.Enabled = true;
            BtnInPort.Enabled = true;
            BtnGet.Enabled = true;
            BtnOutPort.Focus();
        }

        unsafe private void BtnInPort_Click(object sender, EventArgs e)
        {
            UInt32 Status;
            Byte bInData;

            // 無効
            BtnGP10Stop.Enabled = false;
            BtnStrobe.Enabled = false;
            BtnTriggerStart.Enabled = false;
            BtnTriggerStop.Enabled = false;
            BtnOutPort.Enabled = false;
            BtnInPort.Enabled = false;
            BtnGet.Enabled = false;

            // 入力
            Status = RSSG2000.DLL.RPiGP10InPort(hCom, CmbMacAdrsBuf, &bInData);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP10InPort エラー : {0:X}", Status);
            }
            else
            {
                TxtInPort.Text = String.Format("{0:X2}", bInData);
            }

            // 有効
            BtnGP10Stop.Enabled = true;
            BtnStrobe.Enabled = true;
            BtnTriggerStart.Enabled = true;
            BtnTriggerStop.Enabled = true;
            BtnOutPort.Enabled = true;
            BtnInPort.Enabled = true;
            BtnGet.Enabled = true;
            BtnInPort.Focus();
        }

        unsafe private void BtnGet_Click(object sender, EventArgs e)
        {
            UInt32 Status;
            byte[] Version = new byte[8];
            SByte RSSI;
            double Temp;
            double Humidity;

            // 無効
            BtnGP10Stop.Enabled = false;
            BtnStrobe.Enabled = false;
            BtnTriggerStart.Enabled = false;
            BtnTriggerStop.Enabled = false;
            BtnOutPort.Enabled = false;
            BtnInPort.Enabled = false;
            BtnGet.Enabled = false;

            // バージョン取得
            Status = RSSG2000.DLL.RSSG2000GetVersion(hCom, CmbMacAdrsBuf, Version);
            if (Status != 0)
                TxtMsg.Text = String.Format("RSSG2000GetVersion エラー : {0:X}", Status);
            else
                TxtVersion.Text = String.Format("{0:x}.{1:X2}", Version[0], Version[1]);

            // RSSI取得
            Status = RSSG2000.DLL.RSSG2000GetRSSI(hCom, CmbMacAdrsBuf, &RSSI);
            if (Status != 0)
                TxtMsg.Text = String.Format("RSSG2000GetRSSI エラー : {0:X}", Status);
            else
                TxtRSSI.Text = String.Format("{0:D}", RSSI);

            // 温湿度取得
            Status = RSSG2000.DLL.RSSG2000GetTemp(hCom, CmbMacAdrsBuf, &Temp, &Humidity);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RSSG2000GetTemp エラー : {0:X}", Status);
            }
            else
            {
                TxtTemp.Text = String.Format("{0:F1}", Temp);
                TxtHumidity.Text = String.Format("{0:F1}", Humidity);
            }

            // 開始フラグ
            if (fGP10Start[CmbMacAdrs.SelectedIndex])
            {
                // 無効
                BtnGP10Start.Enabled = false;
                // 有効
                BtnGP10Stop.Enabled = true;
                BtnInPort.Enabled = true;
                BtnOutPort.Enabled = true;
                BtnTriggerStart.Enabled = true;
                BtnTriggerStop.Enabled = true;
                BtnStrobe.Enabled = true;
            }
            else
            {
                // 有効
                BtnGP10Start.Enabled = true;
                // 無効
                BtnGP10Stop.Enabled = false;
                BtnInPort.Enabled = false;
                BtnOutPort.Enabled = false;
                BtnTriggerStart.Enabled = false;
                BtnTriggerStop.Enabled = false;
                BtnStrobe.Enabled = false;
            }
            BtnGet.Enabled = true;
            BtnGet.Focus();
        }


        private void BtnExit_Click(object sender, EventArgs e)
        {
            byte iii;

            TxtMsg.Text = "停止中...";
            Application.DoEvents();

            if (fStart)
            {
                // 停止
                RSSG2000.DLL.RSSG2000Stop(hCom);

                for (iii = 0; iii < 16 * 8; iii += 8)
                {
                    if ((MacAdrs[iii + 0] == 0x00) && (MacAdrs[iii + 1] == 0x00) && (MacAdrs[iii + 2] == 0x00) && (MacAdrs[iii + 3] == 0x00) && (MacAdrs[iii + 4] == 0x00) && (MacAdrs[iii + 5] == 0x00) && (MacAdrs[iii + 6] == 0x00) && (MacAdrs[iii + 7] == 0x00))
                    {
                        ;
                    }
                    else
                    {
                        CmbMacAdrsBuf[0] = MacAdrs[iii + 0];
                        CmbMacAdrsBuf[1] = MacAdrs[iii + 1];
                        CmbMacAdrsBuf[2] = MacAdrs[iii + 2];
                        CmbMacAdrsBuf[3] = MacAdrs[iii + 3];
                        CmbMacAdrsBuf[4] = MacAdrs[iii + 4];
                        CmbMacAdrsBuf[5] = MacAdrs[iii + 5];
                        CmbMacAdrsBuf[6] = MacAdrs[iii + 6];
                        CmbMacAdrsBuf[7] = MacAdrs[iii + 7];

                        // 削除
                        RSSG2000.DLL.RSSG2000DeleteMacAdrs(hCom, CmbMacAdrsBuf);
                    }
                }
                // クローズ
                RSSG2000.DLL.RSSG2000Close(hCom);
                hCom = 0xFFFFFFFF;
            }
            
            this.Close();
        }

        unsafe private void CmbMacAdrs_SelectedIndexChanged(object sender, EventArgs e)
        {
            string strMacAdrs;
            byte[] Version = new byte[8];
            SByte RSSI;
            double Temp, Humidity;

            // コンボボックスから取得
            strMacAdrs = CmbMacAdrs.GetItemText(CmbMacAdrs.SelectedItem);

            CmbMacAdrsBuf[0] = byte.Parse(strMacAdrs.Substring(0, 2), System.Globalization.NumberStyles.HexNumber );
            CmbMacAdrsBuf[1] = byte.Parse(strMacAdrs.Substring(3, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[2] = byte.Parse(strMacAdrs.Substring(6, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[3] = byte.Parse(strMacAdrs.Substring(9, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[4] = byte.Parse(strMacAdrs.Substring(12, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[5] = byte.Parse(strMacAdrs.Substring(15, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[6] = byte.Parse(strMacAdrs.Substring(18, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[7] = byte.Parse(strMacAdrs.Substring(21, 2), System.Globalization.NumberStyles.HexNumber);

            if (fStart)
            {
                // バージョン取得
                RSSG2000.DLL.RSSG2000GetVersion(hCom, CmbMacAdrsBuf, Version);
                TxtVersion.Text = String.Format("{0:x}.{1:X2}", Version[0], Version[1]);
                // RSSI 取得
                RSSG2000.DLL.RSSG2000GetRSSI(hCom, CmbMacAdrsBuf, &RSSI);
                TxtRSSI.Text = String.Format("{0:D}", RSSI);
                // 温湿度取得
                RSSG2000.DLL.RSSG2000GetTemp(hCom, CmbMacAdrsBuf, &Temp, &Humidity);
                TxtTemp.Text = String.Format("{0:F1}", Temp);
                TxtHumidity.Text = String.Format("{0:F1}", Humidity);           
            }

            // 開始フラグ
            if (fGP10Start[CmbMacAdrs.SelectedIndex])
            {
                // 無効
                BtnGP10Start.Enabled = false;
                // 有効
                BtnGP10Stop.Enabled = true;
                BtnInPort.Enabled = true;
                BtnOutPort.Enabled = true;
                BtnTriggerStart.Enabled = true;
                BtnTriggerStop.Enabled = true;
                BtnStrobe.Enabled = true;
            }
            else
            {
                if (fStart)
                {
                    // 有効
                    BtnGP10Start.Enabled = true;
                    // 無効
                    BtnGP10Stop.Enabled = false;
                    BtnInPort.Enabled = false;
                    BtnOutPort.Enabled = false;
                    BtnTriggerStart.Enabled = false;
                    BtnTriggerStop.Enabled = false;
                    BtnStrobe.Enabled = false;
                }
            }
        }

    }
}
