Public Class RSSG2010
    Public hCom As UInt32
    Public MacAdrs(17 * 8) As Byte
    Public CmbMacAdrsBuf(8) As Byte
    Public CallBackCount As UShort
    Public fStart As Boolean
    Public fGP10Start(17) As Boolean

    Private ChkDevice() As System.Windows.Forms.CheckBox

    Private ErrorFunc As New ErrorCallback(AddressOf CallBackErrorFunc)
    Private TriggerFunc As New TriggerCallback(AddressOf CallBackTrigeerFunc)
    Private RegistFunc As New RegistCallback(AddressOf CallBackRegistFunc)

    ' イベントコールバック
    Private Sub CallBackErrorFunc(ByRef pData As Byte)
        Dim strData As String
        Dim Length As UInt32
        Dim pBuf As Byte()

        ' エラーデータ取得
        ReDim pBuf(16)
        Length = RSSG2000GetErrorData(pBuf)

        strData = String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackErrorFunc[{8:X2}]", pBuf(0), pBuf(1), pBuf(2), pBuf(3), pBuf(4), pBuf(5), pBuf(6), pBuf(7), pBuf(8))
        TxtMsg.Text = strData
    End Sub
    Private Sub CallBackTrigeerFunc(ByRef pData As Byte)
        Dim strData As String
        Dim Length As UInt32
        Dim pBuf As Byte()
        Dim MacAdrsBuf(8) As Byte

        ' トリガーデータ取得
        ReDim pBuf(16)
        Length = RSSG2000GetTriggerData(pBuf)

        strData = String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackTrigeerFunc[{8:X2}]", pBuf(0), pBuf(1), pBuf(2), pBuf(3), pBuf(4), pBuf(5), pBuf(6), pBuf(7), pBuf(8))
        TxtMsg.Text = strData

        ' MACアドレス
        MacAdrsBuf(0) = pBuf(0)
        MacAdrsBuf(1) = pBuf(1)
        MacAdrsBuf(2) = pBuf(2)
        MacAdrsBuf(3) = pBuf(3)
        MacAdrsBuf(4) = pBuf(4)
        MacAdrsBuf(5) = pBuf(5)
        MacAdrsBuf(6) = pBuf(6)
        MacAdrsBuf(7) = pBuf(7)
        ' トリガ無効
        ' トリガ設定(ビットマスク:0x00)
        RPiGP10Trigger(hCom, MacAdrsBuf(0), False, Convert.ToByte(TxtTrigger.Text, 16), &H0)
    End Sub
    Private Sub CallBackRegistFunc(ByRef pData As Byte)
        Dim strData As String
        Dim Length As UInt32
        Dim pBuf As Byte()
        Dim MacAdrsBuf(8) As Byte

        ' エラーデータ取得
        ReDim pBuf(16)
        Length = RSSG2000GetRegistData(pBuf)

        strData = String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackRegistFunc", pBuf(0), pBuf(1), pBuf(2), pBuf(3), pBuf(4), pBuf(5), pBuf(6), pBuf(7))
        TxtMsg.Text = strData

        ' MACアドレス
        MacAdrsBuf(0) = pBuf(0)
        MacAdrsBuf(1) = pBuf(1)
        MacAdrsBuf(2) = pBuf(2)
        MacAdrsBuf(3) = pBuf(3)
        MacAdrsBuf(4) = pBuf(4)
        MacAdrsBuf(5) = pBuf(5)
        MacAdrsBuf(6) = pBuf(6)
        MacAdrsBuf(7) = pBuf(7)
        ' 登録
        RSSG2000RegistMacAdrs(hCom, MacAdrsBuf(0))
        ' コンボボックス追加
        CmbMacAdrs.Items.Add(String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}", MacAdrsBuf(0), MacAdrsBuf(1), MacAdrsBuf(2), MacAdrsBuf(3), MacAdrsBuf(4), MacAdrsBuf(5), MacAdrsBuf(6), MacAdrsBuf(7)))
        CmbMacAdrs.SelectedIndex = 0
    End Sub


    Private Sub RSSG2010_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim iii As Byte

        CallBackCount = 0
        ' COMポート番号
        TxtCOM.Text = 16
        ' チャンネル
        TxtChannel.Text = 4
        ' 検索台数
        TxtSG20Count.Text = 1
        ' ストローブパルス幅
        TxtStrobe.Text = 100
        ' トリガ発生時の出力データ
        TxtTrigger.Text = "FF"
        ' 出力
        TxtOutPort.Text = "FF"
        ' 開始フラグ
        For iii = 0 To 16
            fGP10Start(iii) = False
        Next
        fStart = False

        ' 無効
        BtnStop.Enabled = False
        BtnGP10Start.Enabled = False
        BtnGP10Stop.Enabled = False
        BtnStrobe.Enabled = False
        BtnTriggerStart.Enabled = False
        BtnTriggerStop.Enabled = False
        BtnOutPort.Enabled = False
        BtnInPort.Enabled = False
        BtnGet.Enabled = False

    End Sub

    Private Sub BtnClear_Click(sender As System.Object, e As System.EventArgs) Handles BtnClear.Click
        ' メッセージ削除
        TxtMsg.Text = ""
        BtnClear.Focus()
    End Sub

    Private Sub BtnStart_Click(sender As System.Object, e As System.EventArgs) Handles BtnStart.Click
        Dim iii As Byte
        Dim Version(8) As Byte
        Dim RSSI As SByte
        Dim Temp As Double
        Dim Humidity As Double
        Dim Count As Byte

        If (TxtCOM.Text.Length = 0) Then
            MessageBox.Show("1-255のCOMポート番号を指定してください")
            Exit Sub
        End If
        If ((Int32.Parse(TxtCOM.Text) < 1) Or (Int32.Parse(TxtCOM.Text) > 255)) Then
            MessageBox.Show("1-255のCOMポート番号を指定してください")
            Exit Sub
        End If
        If (TxtChannel.Text.Length = 0) Then
            MessageBox.Show("4-17のチャンネルを指定してください")
            Exit Sub
        End If
        If ((Int32.Parse(TxtChannel.Text) < 4) Or (Int32.Parse(TxtChannel.Text) > 17)) Then
            MessageBox.Show("4-17のチャンネルを指定してください")
            Exit Sub
        End If
        If (TxtSG20Count.Text.Length = 0) Then
            MessageBox.Show("1-17の台数を指定してください")
            Exit Sub
        End If
        If ((Int32.Parse(TxtSG20Count.Text) < 1) Or (Int32.Parse(TxtSG20Count.Text) > 17)) Then
            MessageBox.Show("1-17の台数を指定してください")
            Exit Sub
        End If

        Count = 0
        TxtMsg.Text = "開始中..."
        Application.DoEvents()
        ' オープン
        hCom = RSSG2000Open(Byte.Parse(TxtCOM.Text), Byte.Parse(TxtChannel.Text), Byte.Parse(TxtSG20Count.Text), RegistFunc)
        If hCom <> &HFFFFFFFFL Then
            Array.Clear(MacAdrs, 0, MacAdrs.Length)
            ' アドレス取得
            RSSG2000GetMacAdrs(hCom, MacAdrs(0))
            ' 表示
            For iii = 0 To 16 * 8 - 1 Step 8
                If ((MacAdrs(iii + 0) = &H0) And (MacAdrs(iii + 1) = &H0) And (MacAdrs(iii + 2) = &H0) And (MacAdrs(iii + 3) = &H0) And (MacAdrs(iii + 4) = &H0) And (MacAdrs(iii + 5) = &H0) And (MacAdrs(iii + 6) = &H0) And (MacAdrs(iii + 7) = &H0)) Then

                Else
                    CmbMacAdrsBuf(0) = MacAdrs(iii + 0)
                    CmbMacAdrsBuf(1) = MacAdrs(iii + 1)
                    CmbMacAdrsBuf(2) = MacAdrs(iii + 2)
                    CmbMacAdrsBuf(3) = MacAdrs(iii + 3)
                    CmbMacAdrsBuf(4) = MacAdrs(iii + 4)
                    CmbMacAdrsBuf(5) = MacAdrs(iii + 5)
                    CmbMacAdrsBuf(6) = MacAdrs(iii + 6)
                    CmbMacAdrsBuf(7) = MacAdrs(iii + 7)

                    ' 登録
                    RSSG2000RegistMacAdrs(hCom, CmbMacAdrsBuf(0))
                    ' 無効
                    BtnStart.Enabled = False
                    ' 有効
                    BtnStop.Enabled = True

                    ' コンボボックス追加
                    CmbMacAdrs.Items.Add(String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}", MacAdrs(iii + 0), MacAdrs(iii + 1), MacAdrs(iii + 2), MacAdrs(iii + 3), MacAdrs(iii + 4), MacAdrs(iii + 5), MacAdrs(iii + 6), MacAdrs(iii + 7)))
                    Count = Count + 1
                End If

            Next
            If Count <> 0 Then

                CmbMacAdrs.SelectedIndex = 0

                ' 開始
                RSSG2000Start(hCom)

                System.Threading.Thread.Sleep(500)
                ' バージョン取得
                RSSG2000GetVersion(hCom, CmbMacAdrsBuf(0), Version(0))
                TxtVersion.Text = String.Format("{0:X}.{1:X2}", Version(0), Version(1))
                ' RSSI取得
                RSSG2000GetRSSI(hCom, CmbMacAdrsBuf(0), RSSI)
                TxtRSSI.Text = String.Format("{0:D}", RSSI)
                ' 温湿度取得
                RSSG2000GetTemp(hCom, CmbMacAdrsBuf(0), Temp, Humidity)
                TxtTemp.Text = String.Format("{0:F1}", Temp)
                TxtHumidity.Text = String.Format("{0:F1}", Humidity)

                ' 有効
                BtnGP10Start.Enabled = True
                BtnGet.Enabled = True

                ' 読み取り専用
                TxtCOM.ReadOnly = True
                TxtChannel.ReadOnly = True
                TxtSG20Count.ReadOnly = True

                fStart = True
                If Count <> Byte.Parse(TxtSG20Count.Text) Then
                    MessageBox.Show("指定台数のSubGiga入出力ベースボードが見つかりません")
                End If
            Else
                ' クローズ
                RSSG2000Close(hCom)
                hCom = &HFFFFFFFFL
                MessageBox.Show("SubGiga入出力ベースボードが見つかりません")
            End If
        Else
            MessageBox.Show("COMオープンエラー")
        End If
        TxtMsg.Text = ""
        BtnStart.Focus()

    End Sub



    Private Sub BtnStop_Click(sender As System.Object, e As System.EventArgs) Handles BtnStop.Click
        Dim iii As Byte

        TxtMsg.Text = "停止中..."
        Application.DoEvents()

        If fStart = True Then
            ' 停止
            RSSG2000Stop(hCom)

            For iii = 0 To 16 * 8 - 1 Step 8
                If ((MacAdrs(iii + 0) = &H0) And (MacAdrs(iii + 1) = &H0) And (MacAdrs(iii + 2) = &H0) And (MacAdrs(iii + 3) = &H0) And (MacAdrs(iii + 4) = &H0) And (MacAdrs(iii + 5) = &H0) And (MacAdrs(iii + 6) = &H0) And (MacAdrs(iii + 7) = &H0)) Then

                Else
                    CmbMacAdrsBuf(0) = MacAdrs(iii + 0)
                    CmbMacAdrsBuf(1) = MacAdrs(iii + 1)
                    CmbMacAdrsBuf(2) = MacAdrs(iii + 2)
                    CmbMacAdrsBuf(3) = MacAdrs(iii + 3)
                    CmbMacAdrsBuf(4) = MacAdrs(iii + 4)
                    CmbMacAdrsBuf(5) = MacAdrs(iii + 5)
                    CmbMacAdrsBuf(6) = MacAdrs(iii + 6)
                    CmbMacAdrsBuf(7) = MacAdrs(iii + 7)

                    ' 削除
                    RSSG2000DeleteMacAdrs(hCom, CmbMacAdrsBuf(0))
                End If
            Next iii

            ' クローズ
            RSSG2000Close(hCom)
            hCom = &HFFFFFFFFL
        End If

        ' 開始フラグ
        For iii = 0 To 16
            fGP10Start(iii) = False
        Next
        fStart = False
        ' 有効
        BtnStart.Enabled = True
        ' 無効
        BtnStop.Enabled = False
        BtnGP10Start.Enabled = False
        BtnGP10Stop.Enabled = False
        BtnStrobe.Enabled = False
        BtnTriggerStart.Enabled = False
        BtnTriggerStop.Enabled = False
        BtnOutPort.Enabled = False
        BtnInPort.Enabled = False
        BtnGet.Enabled = False

        ' コンボボックス削除
        CmbMacAdrs.Items.Clear()
        TxtMsg.Text = ""
        TxtVersion.Text = ""
        TxtRSSI.Text = ""
        TxtTemp.Text = ""
        TxtHumidity.Text = ""
        ' 読み取り専用解除
        TxtCOM.ReadOnly = False
        TxtChannel.ReadOnly = False
        TxtSG20Count.ReadOnly = False
        BtnStop.Focus()

    End Sub

    Private Sub BtnGP10Start_Click(sender As System.Object, e As System.EventArgs) Handles BtnGP10Start.Click
        Dim Status As UInt32

        TxtMsg.Text = "開始中..."
        Application.DoEvents()

        ' GP10オープン
        Status = RPiGP10Open(hCom, CmbMacAdrsBuf(0), TriggerFunc, ErrorFunc)
        Status = 0
        If Status = 0 Then
            TxtMsg.Text = ""
            ' 無効
            BtnGP10Start.Enabled = False
            ' 有効
            BtnGP10Stop.Enabled = True
            BtnStrobe.Enabled = True
            BtnTriggerStart.Enabled = True
            BtnTriggerStop.Enabled = True
            BtnOutPort.Enabled = True
            BtnInPort.Enabled = True
            BtnGet.Enabled = True

            ' 開始フラグ
            fGP10Start(CmbMacAdrs.SelectedIndex) = True
        Else
            TxtMsg.Text = String.Format("RPiGP10Open エラー : {0:X}", Status)
        End If
        BtnGP10Start.Focus()
    End Sub

    Private Sub BtnGP10Stop_Click(sender As System.Object, e As System.EventArgs) Handles BtnGP10Stop.Click
        TxtMsg.Text = "停止中..."
        Application.DoEvents()

        ' 開始フラグ
        fGP10Start(CmbMacAdrs.SelectedIndex) = False

        RPiGP10Trigger(hCom, CmbMacAdrsBuf(0), False, &H0, &H0)
        ' GP10クローズ
        RPiGP10Close(hCom, CmbMacAdrsBuf(0))
        TxtMsg.Text = ""

        ' 有効
        BtnGP10Start.Enabled = True
        ' 無効
        BtnGP10Stop.Enabled = False
        BtnStrobe.Enabled = False
        BtnTriggerStart.Enabled = False
        BtnTriggerStop.Enabled = False
        BtnOutPort.Enabled = False
        BtnInPort.Enabled = False
        BtnGP10Stop.Focus()

    End Sub

    Private Sub BtnStrobe_Click(sender As System.Object, e As System.EventArgs) Handles BtnStrobe.Click
        Dim Status As UInt32

        If (TxtStrobe.Text.Length = 0) Then
            MessageBox.Show("0-65536のストローブパルス幅を指定してください")
            Exit Sub
        End If
        If ((Int32.Parse(TxtStrobe.Text) < 0) Or (Int32.Parse(TxtStrobe.Text) > 65536)) Then
            MessageBox.Show("0-65536のストローブパルス幅を指定してください")
            Exit Sub
        End If

        ' 無効
        BtnGP10Stop.Enabled = False
        BtnStrobe.Enabled = False
        BtnTriggerStart.Enabled = False
        BtnTriggerStop.Enabled = False
        BtnOutPort.Enabled = False
        BtnInPort.Enabled = False
        BtnGet.Enabled = False

        ' ストローブ設定
        Status = RPiGP10StrobeSetting(hCom, CmbMacAdrsBuf(0), False, UInt32.Parse(TxtStrobe.Text))
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP10StrobeSetting エラー : {0:X}", Status)
        Else
            ' ストローブ出力
            Status = RPiGP10StrobeOutput(hCom, CmbMacAdrsBuf(0))
            If Status <> 0 Then
                TxtMsg.Text = String.Format("RPiGP10StrobeOutput エラー : {0:X}", Status)
            Else

            End If
        End If

        ' 有効
        BtnGP10Stop.Enabled = True
        BtnStrobe.Enabled = True
        BtnTriggerStart.Enabled = True
        BtnTriggerStop.Enabled = True
        BtnOutPort.Enabled = True
        BtnInPort.Enabled = True
        BtnGet.Enabled = True
        BtnStrobe.Focus()
    End Sub

    Private Sub BtnTriggerStart_Click(sender As System.Object, e As System.EventArgs) Handles BtnTriggerStart.Click
        Dim Status As UInt32

        ' 無効
        BtnGP10Stop.Enabled = False
        BtnStrobe.Enabled = False
        BtnTriggerStart.Enabled = False
        BtnTriggerStop.Enabled = False
        BtnOutPort.Enabled = False
        BtnInPort.Enabled = False
        BtnGet.Enabled = False

        ' トリガ有効
        ' トリガ設定(ビットマスク:0xFF)
        Status = RPiGP10Trigger(hCom, CmbMacAdrsBuf(0), True, Convert.ToByte(TxtTrigger.Text, 16), &HFF)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP10Trigger エラー : {0:X}", Status)
        End If

        ' 有効
        BtnGP10Stop.Enabled = True
        BtnStrobe.Enabled = True
        BtnTriggerStart.Enabled = True
        BtnTriggerStop.Enabled = True
        BtnOutPort.Enabled = True
        BtnInPort.Enabled = True
        BtnGet.Enabled = True
        BtnTriggerStart.Focus()
    End Sub

    Private Sub BtnTriggerStop_Click(sender As System.Object, e As System.EventArgs) Handles BtnTriggerStop.Click
        Dim Status As UInt32

        ' 無効
        BtnGP10Stop.Enabled = False
        BtnStrobe.Enabled = False
        BtnTriggerStart.Enabled = False
        BtnTriggerStop.Enabled = False
        BtnOutPort.Enabled = False
        BtnInPort.Enabled = False
        BtnGet.Enabled = False

        ' トリガ無効
        ' トリガ設定(ビットマスク:0x00)
        Status = RPiGP10Trigger(hCom, CmbMacAdrsBuf(0), False, Convert.ToByte(TxtTrigger.Text, 16), &H0)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP10Trigger エラー : {0:X}", Status)
        End If

        ' 有効
        BtnGP10Stop.Enabled = True
        BtnStrobe.Enabled = True
        BtnTriggerStart.Enabled = True
        BtnTriggerStop.Enabled = True
        BtnOutPort.Enabled = True
        BtnInPort.Enabled = True
        BtnGet.Enabled = True
        BtnTriggerStop.Focus()
    End Sub

    Private Sub BtnOutPort_Click(sender As System.Object, e As System.EventArgs) Handles BtnOutPort.Click
        Dim Status As UInt32
        Dim bStrobe As Byte

        If ChkStrobe.Checked = True Then
            If (TxtStrobe.Text.Length = 0) Then
                MessageBox.Show("0-65536のストローブパルス幅を指定してください")
                Exit Sub
            End If
            If ((Int32.Parse(TxtStrobe.Text) < 0) Or (Int32.Parse(TxtStrobe.Text) > 65536)) Then
                MessageBox.Show("0-65536のストローブパルス幅を指定してください")
                Exit Sub
            End If
        End If

        ' 無効
        BtnGP10Stop.Enabled = False
        BtnStrobe.Enabled = False
        BtnTriggerStart.Enabled = False
        BtnTriggerStop.Enabled = False
        BtnOutPort.Enabled = False
        BtnInPort.Enabled = False
        BtnGet.Enabled = False

        bStrobe = 0
        If ChkStrobe.Checked = True Then

            ' ストローブ設定
            Status = RPiGP10StrobeSetting(hCom, CmbMacAdrsBuf(0), False, UInt32.Parse(TxtStrobe.Text))
            If Status <> 0 Then
                TxtMsg.Text = String.Format("RPiGP10StrobeSetting エラー : {0:X}", Status)
            Else
                ' ストローブ出力する
                bStrobe = 1
            End If
        Else
            ' ストローブ出力しない
            bStrobe = 0
        End If


        ' 出力(ビットマスク:0xFF)
        Status = RPiGP10OutPort(hCom, CmbMacAdrsBuf(0), Convert.ToByte(TxtOutPort.Text, 16), &HFF, bStrobe)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP10OutPort エラー : {0:X}", Status)
        End If

        ' 有効
        BtnGP10Stop.Enabled = True
        BtnStrobe.Enabled = True
        BtnTriggerStart.Enabled = True
        BtnTriggerStop.Enabled = True
        BtnOutPort.Enabled = True
        BtnInPort.Enabled = True
        BtnGet.Enabled = True
        BtnOutPort.Focus()
    End Sub

    Private Sub BtnInPort_Click(sender As System.Object, e As System.EventArgs) Handles BtnInPort.Click
        Dim Status As UInt32
        Dim bInData As Byte

        ' 無効
        BtnGP10Stop.Enabled = False
        BtnStrobe.Enabled = False
        BtnTriggerStart.Enabled = False
        BtnTriggerStop.Enabled = False
        BtnOutPort.Enabled = False
        BtnInPort.Enabled = False
        BtnGet.Enabled = False

        ' 入力
        Status = RPiGP10InPort(hCom, CmbMacAdrsBuf(0), bInData)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP10InPort エラー : {0:X}", Status)
        Else
            TxtInPort.Text = String.Format("{0:X2}", bInData)
        End If

        ' 有効
        BtnGP10Stop.Enabled = True
        BtnStrobe.Enabled = True
        BtnTriggerStart.Enabled = True
        BtnTriggerStop.Enabled = True
        BtnOutPort.Enabled = True
        BtnInPort.Enabled = True
        BtnGet.Enabled = True
        BtnInPort.Focus()
    End Sub

    Private Sub BtnGet_Click(sender As System.Object, e As System.EventArgs) Handles BtnGet.Click
        Dim Status As UInt32
        Dim Version(8) As Byte
        Dim RSSI As SByte
        Dim Temp As Double
        Dim Humidity As Double

        ' 無効
        BtnGP10Stop.Enabled = False
        BtnStrobe.Enabled = False
        BtnTriggerStart.Enabled = False
        BtnTriggerStop.Enabled = False
        BtnOutPort.Enabled = False
        BtnInPort.Enabled = False
        BtnGet.Enabled = False

        ' バージョン取得
        Status = RSSG2000GetVersion(hCom, CmbMacAdrsBuf(0), Version(0))
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RSSG2000GetVersion エラー : {0:X}", Status)
        Else
            TxtVersion.Text = String.Format("{0:X}.{1:X2}", Version(0), Version(1))
        End If

        ' RSSI取得
        Status = RSSG2000GetRSSI(hCom, CmbMacAdrsBuf(0), RSSI)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RSSG2000GetRSSI エラー : {0:X}", Status)
        Else
            TxtRSSI.Text = String.Format("{0:D}", RSSI)
        End If

        ' 温湿度取得
        Status = RSSG2000GetTemp(hCom, CmbMacAdrsBuf(0), Temp, Humidity)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RSSG2000GetTemp エラー : {0:X}", Status)
        Else
            TxtTemp.Text = String.Format("{0:F1}", Temp)
            TxtHumidity.Text = String.Format("{0:F1}", Humidity)
        End If

        ' 開始フラグ
        If fGP10Start(CmbMacAdrs.SelectedIndex) = True Then
            ' 無効
            BtnGP10Start.Enabled = False
            ' 有効
            BtnGP10Stop.Enabled = True
            BtnStrobe.Enabled = True
            BtnTriggerStart.Enabled = True
            BtnTriggerStop.Enabled = True
            BtnOutPort.Enabled = True
            BtnInPort.Enabled = True
        Else
            ' 有効
            BtnGP10Start.Enabled = True
            ' 無効
            BtnGP10Stop.Enabled = False
            BtnStrobe.Enabled = False
            BtnTriggerStart.Enabled = False
            BtnTriggerStop.Enabled = False
            BtnOutPort.Enabled = False
            BtnInPort.Enabled = False
        End If
        BtnGet.Enabled = True
        BtnGet.Focus()
    End Sub

    Private Sub BtnExit_Click(sender As System.Object, e As System.EventArgs) Handles BtnExit.Click
        Dim iii As Byte

        TxtMsg.Text = "停止中..."
        Application.DoEvents()

        If fStart = True Then
            ' 停止
            RSSG2000Stop(hCom)

            For iii = 0 To 16 * 8 - 1 Step 8
                If ((MacAdrs(iii + 0) = &H0) And (MacAdrs(iii + 1) = &H0) And (MacAdrs(iii + 2) = &H0) And (MacAdrs(iii + 3) = &H0) And (MacAdrs(iii + 4) = &H0) And (MacAdrs(iii + 5) = &H0) And (MacAdrs(iii + 6) = &H0) And (MacAdrs(iii + 7) = &H0)) Then

                Else
                    CmbMacAdrsBuf(0) = MacAdrs(iii + 0)
                    CmbMacAdrsBuf(1) = MacAdrs(iii + 1)
                    CmbMacAdrsBuf(2) = MacAdrs(iii + 2)
                    CmbMacAdrsBuf(3) = MacAdrs(iii + 3)
                    CmbMacAdrsBuf(4) = MacAdrs(iii + 4)
                    CmbMacAdrsBuf(5) = MacAdrs(iii + 5)
                    CmbMacAdrsBuf(6) = MacAdrs(iii + 6)
                    CmbMacAdrsBuf(7) = MacAdrs(iii + 7)

                    ' 削除
                    RSSG2000DeleteMacAdrs(hCom, CmbMacAdrsBuf(0))
                End If
            Next iii

            ' クローズ
            RSSG2000Close(hCom)
            hCom = &HFFFFFFFFL
        End If

        Me.Close()
    End Sub

    Private Sub CmbMacAdrs_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles CmbMacAdrs.SelectedIndexChanged
        Dim strMacAdrs As String
        Dim Version(8) As Byte
        Dim RSSI As SByte
        Dim Temp As Double
        Dim Humidity As Double

        ' コンボボックスから取得
        strMacAdrs = CmbMacAdrs.GetItemText(CmbMacAdrs.SelectedItem)

        CmbMacAdrsBuf(0) = Byte.Parse(strMacAdrs.Substring(0, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(1) = Byte.Parse(strMacAdrs.Substring(3, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(2) = Byte.Parse(strMacAdrs.Substring(6, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(3) = Byte.Parse(strMacAdrs.Substring(9, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(4) = Byte.Parse(strMacAdrs.Substring(12, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(5) = Byte.Parse(strMacAdrs.Substring(15, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(6) = Byte.Parse(strMacAdrs.Substring(18, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(7) = Byte.Parse(strMacAdrs.Substring(21, 2), Globalization.NumberStyles.HexNumber)

        If fStart = True Then
            ' バージョン取得
            RSSG2000GetVersion(hCom, CmbMacAdrsBuf(0), Version(0))
            TxtVersion.Text = String.Format("{0:X}.{1:X2}", Version(0), Version(1))
            ' RSSI取得
            RSSG2000GetRSSI(hCom, CmbMacAdrsBuf(0), RSSI)
            TxtRSSI.Text = String.Format("{0:D}", RSSI)
            ' 温湿度取得
            RSSG2000GetTemp(hCom, CmbMacAdrsBuf(0), Temp, Humidity)
            TxtTemp.Text = String.Format("{0:F1}", Temp)
            TxtHumidity.Text = String.Format("{0:F1}", Humidity)

        End If

        ' 開始フラグ
        If fGP10Start(CmbMacAdrs.SelectedIndex) = True Then
            ' 無効
            BtnGP10Start.Enabled = False
            ' 有効
            BtnGP10Stop.Enabled = True
            BtnStrobe.Enabled = True
            BtnTriggerStart.Enabled = True
            BtnTriggerStop.Enabled = True
            BtnOutPort.Enabled = True
            BtnInPort.Enabled = True
        Else
            If fStart = True Then
                ' 有効
                BtnGP10Start.Enabled = True
                ' 無効
                BtnGP10Stop.Enabled = False
                BtnStrobe.Enabled = False
                BtnTriggerStart.Enabled = False
                BtnTriggerStop.Enabled = False
                BtnOutPort.Enabled = False
                BtnInPort.Enabled = False
            End If
        End If
    End Sub
End Class
