
// RSSG2010Dlg.cpp : t@C
//

#include "stdafx.h"
#include "RSSG2010.h"
#include "RSSG2010Dlg.h"
#include "afxdialogex.h"
#include "RSSG2000.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

HWND hwnd;
HANDLE hComPort;

// CRSSG2010Dlg _CAO

VOID CALLBACK TriggerCallBackFunc( PUCHAR pData )
{
	char MsgBuf[256];
	UCHAR MacAdrsBuf[8];
	char TriggerBuf[16];

	// gK͎̏o̓f[^
	memset( TriggerBuf, 0x00, sizeof(TriggerBuf) );
	GetDlgItemText( hwnd, IDE_TRIGGER, TriggerBuf, sizeof(TriggerBuf) );

	sprintf_s( MsgBuf, sizeof(MsgBuf), "[%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X] TriggerCallBackFunc[%02X]", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7], pData[8] );
	SetDlgItemText( hwnd, IDE_MSG, MsgBuf );

	// MACAhX
	MacAdrsBuf[0] = pData[0];	MacAdrsBuf[1] = pData[1];	MacAdrsBuf[2] = pData[2];	MacAdrsBuf[3] = pData[3];
	MacAdrsBuf[4] = pData[4];	MacAdrsBuf[5] = pData[5];	MacAdrsBuf[6] = pData[6];	MacAdrsBuf[7] = pData[7];
	// gK
	// gKݒ(rbg}XN:0x00)
	RPiGP10Trigger( hComPort, MacAdrsBuf, FALSE, (BYTE)strtol( TriggerBuf, NULL, 16 ), 0x00 );
}
VOID CALLBACK ErrorCallBackFunc( PUCHAR pData )
{
	char MsgBuf[256];

	sprintf_s( MsgBuf, sizeof(MsgBuf), "[%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X] ErrorCallBackFunc[%02X]", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7], pData[8] );
	SetDlgItemText( hwnd, IDE_MSG, MsgBuf );
}
VOID CALLBACK RegistCallBackFunc( PUCHAR pData )
{
	char MsgBuf[256];
	UCHAR MacAdrsBuf[8];
	HWND hCombo;

	sprintf_s( MsgBuf, sizeof(MsgBuf), "[%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X] RegistCallBackFunc", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7] );
	SetDlgItemText( hwnd, IDE_MSG, MsgBuf );

	// MACAhX
	MacAdrsBuf[0] = pData[0];	MacAdrsBuf[1] = pData[1];	MacAdrsBuf[2] = pData[2];	MacAdrsBuf[3] = pData[3];
	MacAdrsBuf[4] = pData[4];	MacAdrsBuf[5] = pData[5];	MacAdrsBuf[6] = pData[6];	MacAdrsBuf[7] = pData[7];
	// o^
	RSSG2000RegistMacAdrs( hComPort, MacAdrsBuf );

	memset( MsgBuf, 0x00, sizeof(MsgBuf) );
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X", MacAdrsBuf[0], MacAdrsBuf[1], MacAdrsBuf[2], MacAdrsBuf[3], MacAdrsBuf[4], MacAdrsBuf[5], MacAdrsBuf[6], MacAdrsBuf[7] );
	// R{{bNXǉ
	// R{{bNXǉ
	hCombo = GetDlgItem(hwnd, IDC_MACADRS);
	SendMessage(hCombo, CB_ADDSTRING, 0, (LPARAM)MsgBuf);
	SendMessage(hCombo, CB_SETCURSEL, 0, 0);
}


CRSSG2010Dlg::CRSSG2010Dlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CRSSG2010Dlg::IDD, pParent)
	, m_StrMsg(_T(""))
	, m_StrVersion(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_Channel = 0;
	m_Com = 0;
	m_SG20Count = 0;
	m_StrInPort = _T("");
	m_StrStrobe = _T("");
	m_StrTrigger = _T("");
	m_StrOutPort = _T("");
	m_StrRSSI = _T("");
	m_StrTemp = _T("");
	m_StrHumidity = _T("");
}

void CRSSG2010Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDB_START, m_BtnStart);
	DDX_Control(pDX, IDB_STOP, m_BtnStop);
	DDX_Text(pDX, IDE_CHANNEL, m_Channel);
	DDX_Text(pDX, IDE_COM, m_Com);
	DDX_Control(pDX, IDC_MACADRS, m_CmbMacAdrs);
	DDX_Control(pDX, IDB_GP10START, m_BtnGP10Start);
	DDX_Text(pDX, IDE_SG20COUNT, m_SG20Count);
	DDX_Control(pDX, IDB_GP10STOP, m_BtnGP10Stop);
	DDX_Control(pDX, IDB_CLEAR, m_BtnClear);
	DDX_Control(pDX, IDB_INPORT, m_BtnInPort);
	DDX_Control(pDX, IDB_OUTPORT, m_BtnOutPort);
	DDX_Control(pDX, IDB_TRIGGERSTART, m_BtnTriggerStart);
	DDX_Control(pDX, IDB_TRIGGERSTOP, m_BtnTriggerStop);
	DDX_Control(pDX, IDB_STROBE, m_BtnStrobe);
	DDX_Text(pDX, IDE_INPORT, m_StrInPort);
	DDX_Text(pDX, IDE_STROBE, m_StrStrobe);
	DDX_Text(pDX, IDE_TRIGGER, m_StrTrigger);
	DDV_MaxChars(pDX, m_StrTrigger, 2);
	DDX_Text(pDX, IDE_OUTPORT, m_StrOutPort);
	DDV_MaxChars(pDX, m_StrOutPort, 2);
	DDX_Text(pDX, IDE_MSG, m_StrMsg);
	DDX_Control(pDX, IDC_STROBE, m_ChkStrobe);
	DDX_Text(pDX, IDE_VERSION, m_StrVersion);
	DDX_Control(pDX, IDB_GET, m_BtnGet);
	DDX_Text(pDX, IDE_RSSI, m_StrRSSI);
	DDX_Text(pDX, IDE_TEMP, m_StrTemp);
	DDX_Text(pDX, IDE_HUMIDITY, m_StrHumidity);
}

BEGIN_MESSAGE_MAP(CRSSG2010Dlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDB_START, &CRSSG2010Dlg::OnBnClickedStart)
	ON_BN_CLICKED(IDB_STOP, &CRSSG2010Dlg::OnBnClickedStop)
	ON_BN_CLICKED(IDB_GP10START, &CRSSG2010Dlg::OnBnClickedGP10Start)
	ON_BN_CLICKED(IDB_GP10STOP, &CRSSG2010Dlg::OnBnClickedGP10Stop)
	ON_BN_CLICKED(IDB_CLEAR, &CRSSG2010Dlg::OnBnClickedClear)
	ON_BN_CLICKED(IDB_OUTPORT, &CRSSG2010Dlg::OnBnClickedOutport)
	ON_BN_CLICKED(IDB_INPORT, &CRSSG2010Dlg::OnBnClickedInport)
	ON_BN_CLICKED(IDB_STROBE, &CRSSG2010Dlg::OnBnClickedStrobe)
	ON_BN_CLICKED(IDCANCEL, &CRSSG2010Dlg::OnBnClickedCancel)
	ON_CBN_SELCHANGE(IDC_MACADRS, &CRSSG2010Dlg::OnCbnSelchangeMacadrs)
	ON_BN_CLICKED(IDB_TRIGGERSTART, &CRSSG2010Dlg::OnBnClickedTriggerstart)
	ON_BN_CLICKED(IDB_TRIGGERSTOP, &CRSSG2010Dlg::OnBnClickedTriggerstop)
	ON_BN_CLICKED(IDB_GET, &CRSSG2010Dlg::OnBnClickedGet)
END_MESSAGE_MAP()


// CRSSG2010Dlg bZ[W nh[

BOOL CRSSG2010Dlg::OnInitDialog()
{
	UCHAR	iii;

	CDialogEx::OnInitDialog();

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B
	hwnd = m_hWnd;
	// COM|[gԍ
	m_Com = 16;
	// `l
	m_Channel = 4;
	// 䐔
	m_SG20Count = 1;
    // Xg[upX
    m_StrStrobe = "100";
    // gK̏o̓f[^
    m_StrTrigger = "FF";
    // o
    m_StrOutPort = "FF";
	// JntO
	for( iii = 0; iii < MaxCount; iii++ )
		fGP10Start[iii] = FALSE;
	fStart = FALSE;

	// 
	m_BtnStop.EnableWindow( FALSE );
	m_BtnGP10Start.EnableWindow( FALSE );
	m_BtnGP10Stop.EnableWindow( FALSE );
	m_BtnInPort.EnableWindow( FALSE );
	m_BtnOutPort.EnableWindow( FALSE );
	m_BtnTriggerStart.EnableWindow( FALSE );
	m_BtnTriggerStop.EnableWindow( FALSE );
	m_BtnStrobe.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );

	UpdateData( FALSE );
	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CRSSG2010Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CRSSG2010Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CRSSG2010Dlg::OnBnClickedClear()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	// bZ[W폜
	m_StrMsg = "";
	m_BtnClear.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2010Dlg::OnBnClickedStart()
{
	BYTE	iii;
	char	MacBuf[32];
	BYTE	Count = 0;
	UCHAR	Version[8];
	CHAR	RSSI;
	double	Temp, Humidity;

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	if( !UpdateData( TRUE ) )
		return;
	if( ( m_Com < 1 ) || ( m_Com > 255 ) )
	{
		MessageBox( "1-255COM|[gԍw肵Ă", "", MB_OK );
		return;
	}
	if( ( m_Channel < 4 ) || ( m_Channel > 17 ) )
	{
		MessageBox( "4-17̃`lw肵Ă", "", MB_OK );
		return;
	}
	if( ( m_SG20Count < 1 ) || ( m_SG20Count > 17 ) )
	{
		MessageBox( "1-17̑䐔w肵Ă", "", MB_OK );
		return;
	}

	m_StrMsg = "Jn...";
	UpdateData( FALSE );
	UpdateWindow(); 

	ZeroMemory( MacAdrs, MaxCount*8 );
	// I[v
	hCom = RSSG2000Open( m_Com, m_Channel, m_SG20Count, RegistCallBackFunc );
	if( hCom != INVALID_HANDLE_VALUE )
	{
		hComPort = hCom;
		ZeroMemory( MacAdrs, sizeof(MacAdrs) );
		// AhX擾
		RSSG2000GetMacAdrs( hCom, MacAdrs );
		// \
		for( iii = 0; iii < MaxCount*8; iii+=8  )
		{
			if( ( MacAdrs[iii+0] == 0x00 ) && ( MacAdrs[iii+1] == 0x00 ) && ( MacAdrs[iii+2] == 0x00 ) && ( MacAdrs[iii+3] == 0x00 ) && ( MacAdrs[iii+4] == 0x00 ) && ( MacAdrs[iii+5] == 0x00 ) && ( MacAdrs[iii+6] == 0x00 ) && ( MacAdrs[iii+7] == 0x00 ) )
				;
			else
			{
				// o^
				RSSG2000RegistMacAdrs( hCom, (PUCHAR)(MacAdrs + iii) );
				// 
				m_BtnStart.EnableWindow( FALSE );
				// L
				m_BtnStop.EnableWindow( TRUE );

				sprintf_s( MacBuf, sizeof(MacBuf), "%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X", MacAdrs[iii+0], MacAdrs[iii+1], MacAdrs[iii+2], MacAdrs[iii+3], MacAdrs[iii+4], MacAdrs[iii+5], MacAdrs[iii+6], MacAdrs[iii+7] );
				// R{{bNXǉ
				m_CmbMacAdrs.AddString( MacBuf );

				CmbMacAdrsBuf[0] = MacAdrs[iii+0];
				CmbMacAdrsBuf[1] = MacAdrs[iii+1];
				CmbMacAdrsBuf[2] = MacAdrs[iii+2];
				CmbMacAdrsBuf[3] = MacAdrs[iii+3];
				CmbMacAdrsBuf[4] = MacAdrs[iii+4];
				CmbMacAdrsBuf[5] = MacAdrs[iii+5];
				CmbMacAdrsBuf[6] = MacAdrs[iii+6];
				CmbMacAdrsBuf[7] = MacAdrs[iii+7];

				m_CmbMacAdrs.SetCurSel( Count );
				Count++;
			}
		}

		if( Count != 0 )
		{
			CmbMacAdrsBuf[0] = MacAdrs[0];
			CmbMacAdrsBuf[1] = MacAdrs[1];
			CmbMacAdrsBuf[2] = MacAdrs[2];
			CmbMacAdrsBuf[3] = MacAdrs[3];
			CmbMacAdrsBuf[4] = MacAdrs[4];
			CmbMacAdrsBuf[5] = MacAdrs[5];
			CmbMacAdrsBuf[6] = MacAdrs[6];
			CmbMacAdrsBuf[7] = MacAdrs[7];
			m_CmbMacAdrs.SetCurSel( 0 );

			// Jn
			RSSG2000Start( hCom );

			Sleep(500);
			// o[W擾
			RSSG2000GetVersion( hCom, CmbMacAdrsBuf, Version );
			m_StrVersion.Format( "%x.%02x", Version[0], Version[1] );
			// RSSI擾
			RSSG2000GetRSSI( hCom, CmbMacAdrsBuf, &RSSI );
			m_StrRSSI.Format( "%d", RSSI );
			// x擾
			RSSG2000GetTemp( hCom, CmbMacAdrsBuf, &Temp, &Humidity );
			m_StrTemp.Format( "%.2f", Temp );
			m_StrHumidity.Format( "%.2f", Humidity );

			// L
			m_BtnGP10Start.EnableWindow( TRUE );
			m_BtnGet.EnableWindow( TRUE );

			// ǂݎp
			( (CEdit*)GetDlgItem( IDE_COM ) )->SetReadOnly(TRUE);
			( (CEdit*)GetDlgItem( IDE_CHANNEL ) )->SetReadOnly(TRUE);
			( (CEdit*)GetDlgItem( IDE_SG20COUNT ) )->SetReadOnly(TRUE);
			fStart = TRUE;
			UpdateData( FALSE );

			if( Count != m_SG20Count )
			{
				MessageBox( "w䐔SubGigao̓x[X{[h܂", "", MB_OK );
			}
		}
		else
		{
			// N[Y
			RSSG2000Close( hCom );
			hCom = INVALID_HANDLE_VALUE;
			MessageBox( "SubGigao̓x[X{[h܂", "", MB_OK );
		}
	}
	else
	{
		MessageBox( "COMI[vG[", "", MB_OK );
	}
	m_StrMsg = "";
	m_BtnStart.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2010Dlg::OnBnClickedStop()
{
	BYTE	iii;

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	m_StrMsg = "~...";
	UpdateData( FALSE );
	UpdateWindow(); 

	if( fStart )
	{
		// ~
		RSSG2000Stop( hCom );

		for( iii = 0; iii < MaxCount*8; iii+=8  )
		{
			if( ( MacAdrs[iii+0] == 0x00 ) && ( MacAdrs[iii+1] == 0x00 ) && ( MacAdrs[iii+2] == 0x00 ) && ( MacAdrs[iii+3] == 0x00 ) && ( MacAdrs[iii+4] == 0x00 ) && ( MacAdrs[iii+5] == 0x00 ) && ( MacAdrs[iii+6] == 0x00 ) && ( MacAdrs[iii+7] == 0x00 ) )
				;
			else
			{
				// 폜
				RSSG2000DeleteMacAdrs( hCom, (PUCHAR)(MacAdrs + iii) );
			}
		}

		// N[Y
		RSSG2000Close( hCom );
		hCom = INVALID_HANDLE_VALUE;
	}

	// JntO
	for( iii = 0; iii < MaxCount; iii++ )
		fGP10Start[iii] = FALSE;
	fStart = FALSE;

	// L
	m_BtnStart.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	// 
	m_BtnStop.EnableWindow( FALSE );
	m_BtnGP10Start.EnableWindow( FALSE );
	m_BtnGP10Stop.EnableWindow( FALSE );
	m_BtnInPort.EnableWindow( FALSE );
	m_BtnOutPort.EnableWindow( FALSE );
	m_BtnTriggerStart.EnableWindow( FALSE );
	m_BtnTriggerStop.EnableWindow( FALSE );
	m_BtnStrobe.EnableWindow( FALSE );
	
	// R{{bNX폜
	m_CmbMacAdrs.ResetContent();
	m_StrMsg = "";
	m_StrVersion = "";
	m_StrRSSI = "";
	m_StrTemp = "";
	m_StrHumidity = "";


	// ǂݎp
	( (CEdit*)GetDlgItem( IDE_COM ) )->SetReadOnly(FALSE);
	( (CEdit*)GetDlgItem( IDE_CHANNEL ) )->SetReadOnly(FALSE);
	( (CEdit*)GetDlgItem( IDE_SG20COUNT ) )->SetReadOnly(FALSE);
	m_BtnStop.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2010Dlg::OnBnClickedGP10Start()
{
	DWORD	Status;
	char MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	m_StrMsg = "Jn...";
	UpdateData( FALSE );
	UpdateWindow(); 

	// GP10I[v
	Status = RPiGP10Open( hCom, CmbMacAdrsBuf, TriggerCallBackFunc, ErrorCallBackFunc );

	if( Status == 0 )
	{
		m_StrMsg = "";
		// 
		m_BtnGP10Start.EnableWindow( FALSE );
		// L
		m_BtnGP10Stop.EnableWindow( TRUE );
		m_BtnInPort.EnableWindow( TRUE );
		m_BtnOutPort.EnableWindow( TRUE );
		m_BtnTriggerStart.EnableWindow( TRUE );
		m_BtnTriggerStop.EnableWindow( TRUE );
		m_BtnStrobe.EnableWindow( TRUE );

		// JntO
		fGP10Start[m_CmbMacAdrs.GetCurSel()] = TRUE;
	}
	else
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP10Open G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	m_BtnGP10Start.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2010Dlg::OnBnClickedGP10Stop()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	m_StrMsg = "~...";
	UpdateData( FALSE );
	UpdateWindow(); 

	// JntO
	fGP10Start[m_CmbMacAdrs.GetCurSel()] = FALSE;

	RPiGP10Trigger( hCom, CmbMacAdrsBuf, FALSE, 0x00, 0x00 );
	// GP10N[Y
	RPiGP10Close( hCom, CmbMacAdrsBuf );
	m_StrMsg = "";

	// L
	m_BtnGP10Start.EnableWindow( TRUE );
	// 
	m_BtnGP10Stop.EnableWindow( FALSE );
	m_BtnInPort.EnableWindow( FALSE );
	m_BtnOutPort.EnableWindow( FALSE );
	m_BtnTriggerStart.EnableWindow( FALSE );
	m_BtnTriggerStop.EnableWindow( FALSE );
	m_BtnStrobe.EnableWindow( FALSE );
	m_BtnGP10Stop.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2010Dlg::OnBnClickedStrobe()
{
	DWORD	Status;
	char MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );

	if( ( strtol( m_StrStrobe.GetBuffer(m_StrStrobe.GetLength()), NULL, 10 ) < 0 ) || ( strtol( m_StrStrobe.GetBuffer(m_StrStrobe.GetLength()), NULL, 10 ) > 65536 ) )
	{
		MessageBox( "0-65536̃Xg[upXw肵Ă", "", MB_OK );
		return;
	}

	// 
	m_BtnGP10Stop.EnableWindow( FALSE );
	m_BtnInPort.EnableWindow( FALSE );
	m_BtnOutPort.EnableWindow( FALSE );
	m_BtnTriggerStart.EnableWindow( FALSE );
	m_BtnTriggerStop.EnableWindow( FALSE );
	m_BtnStrobe.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// Xg[uݒ
	Status = RPiGP10StrobeSetting( hCom, CmbMacAdrsBuf, FALSE, strtol( m_StrStrobe.GetBuffer(m_StrStrobe.GetLength()), NULL, 10 ) );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP10StrobeSetting G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		// Xg[uo
		Status = RPiGP10StrobeOutput( hCom, CmbMacAdrsBuf );
		if( Status != 0 )
		{
			sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP10StrobeOutput G[ [%X]", Status );
			m_StrMsg = MsgBuf;
		}
	}

	// L
	m_BtnGP10Stop.EnableWindow( TRUE );
	m_BtnInPort.EnableWindow( TRUE );
	m_BtnOutPort.EnableWindow( TRUE );
	m_BtnTriggerStart.EnableWindow( TRUE );
	m_BtnTriggerStop.EnableWindow( TRUE );
	m_BtnStrobe.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnStrobe.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2010Dlg::OnBnClickedTriggerstart()
{
	DWORD	Status;
	char MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );

	// 
	m_BtnGP10Stop.EnableWindow( FALSE );
	m_BtnInPort.EnableWindow( FALSE );
	m_BtnOutPort.EnableWindow( FALSE );
	m_BtnTriggerStart.EnableWindow( FALSE );
	m_BtnTriggerStop.EnableWindow( FALSE );
	m_BtnStrobe.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// gKL
	// gKݒ(rbg}XN:0xFF)
	Status = RPiGP10Trigger( hCom, CmbMacAdrsBuf, TRUE, (BYTE)strtol( m_StrTrigger.GetBuffer(m_StrTrigger.GetLength()), NULL, 16 ), 0xFF );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP10Trigger G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}

	// L
	m_BtnGP10Stop.EnableWindow( TRUE );
	m_BtnInPort.EnableWindow( TRUE );
	m_BtnOutPort.EnableWindow( TRUE );
	m_BtnTriggerStart.EnableWindow( TRUE );
	m_BtnTriggerStop.EnableWindow( TRUE );
	m_BtnStrobe.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnTriggerStart.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2010Dlg::OnBnClickedTriggerstop()
{
	DWORD	Status;
	char MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	// 
	m_BtnGP10Stop.EnableWindow( FALSE );
	m_BtnInPort.EnableWindow( FALSE );
	m_BtnOutPort.EnableWindow( FALSE );
	m_BtnTriggerStart.EnableWindow( FALSE );
	m_BtnTriggerStop.EnableWindow( FALSE );
	m_BtnStrobe.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// gK
	// gKݒ(rbg}XN:0x00)
	Status = RPiGP10Trigger( hCom, CmbMacAdrsBuf, FALSE, (BYTE)strtol( m_StrTrigger.GetBuffer(m_StrTrigger.GetLength()), NULL, 16 ), 0x00 );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP10Trigger G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}

	// L
	m_BtnGP10Stop.EnableWindow( TRUE );
	m_BtnInPort.EnableWindow( TRUE );
	m_BtnOutPort.EnableWindow( TRUE );
	m_BtnTriggerStart.EnableWindow( TRUE );
	m_BtnTriggerStop.EnableWindow( TRUE );
	m_BtnStrobe.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnTriggerStop.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2010Dlg::OnBnClickedOutport()
{
	DWORD	Status;
	char MsgBuf[256];
	BYTE	bStrobe;

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );

	if( m_ChkStrobe.GetCheck() )
	{
		if( ( strtol( m_StrStrobe.GetBuffer(m_StrStrobe.GetLength()), NULL, 10 ) < 0 ) || ( strtol( m_StrStrobe.GetBuffer(m_StrStrobe.GetLength()), NULL, 10 ) > 65536 ) )
		{
			MessageBox( "0-65536̃Xg[upXw肵Ă", "", MB_OK );
			return;
		}
	}

	// 
	m_BtnGP10Stop.EnableWindow( FALSE );
	m_BtnInPort.EnableWindow( FALSE );
	m_BtnOutPort.EnableWindow( FALSE );
	m_BtnTriggerStart.EnableWindow( FALSE );
	m_BtnTriggerStop.EnableWindow( FALSE );
	m_BtnStrobe.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	bStrobe = 0;
	if( m_ChkStrobe.GetCheck() )
	{
		// Xg[uݒ
		Status = RPiGP10StrobeSetting( hCom, CmbMacAdrsBuf, FALSE, strtol( m_StrStrobe.GetBuffer(m_StrStrobe.GetLength()), NULL, 10 ) );
		if( Status != 0 )
		{
			sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP10StrobeSetting G[ [%X]", Status );
			m_StrMsg = MsgBuf;
		}
		else
		{
			// Xg[uo͂
			bStrobe = 1;
		}
	}
	else
	{
		// Xg[uo͂Ȃ
		bStrobe = 0;
	}


	// o(rbg}XN:0xFF)
	Status = RPiGP10OutPort( hCom, CmbMacAdrsBuf, (BYTE)strtol( m_StrOutPort.GetBuffer(m_StrOutPort.GetLength()), NULL, 16 ), 0xFF, bStrobe );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP10OutPort G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}

	// L
	m_BtnGP10Stop.EnableWindow( TRUE );
	m_BtnInPort.EnableWindow( TRUE );
	m_BtnOutPort.EnableWindow( TRUE );
	m_BtnTriggerStart.EnableWindow( TRUE );
	m_BtnTriggerStop.EnableWindow( TRUE );
	m_BtnStrobe.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnOutPort.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2010Dlg::OnBnClickedInport()
{
	DWORD	Status;
	BYTE	bInData;
	char MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	// 
	m_BtnGP10Stop.EnableWindow( FALSE );
	m_BtnInPort.EnableWindow( FALSE );
	m_BtnOutPort.EnableWindow( FALSE );
	m_BtnTriggerStart.EnableWindow( FALSE );
	m_BtnTriggerStop.EnableWindow( FALSE );
	m_BtnStrobe.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// 
	Status = RPiGP10InPort( hCom, CmbMacAdrsBuf, &bInData );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP10OutPort G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%02X", bInData );
		m_StrInPort = MsgBuf;
	}

	// L
	m_BtnGP10Stop.EnableWindow( TRUE );
	m_BtnInPort.EnableWindow( TRUE );
	m_BtnOutPort.EnableWindow( TRUE );
	m_BtnTriggerStart.EnableWindow( TRUE );
	m_BtnTriggerStop.EnableWindow( TRUE );
	m_BtnStrobe.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnInPort.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2010Dlg::OnBnClickedGet()
{
	DWORD	Status;
	UCHAR Version[8];
	CHAR	RSSI;
	double	Temp, Humidity;
	char MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	// 
	m_BtnGP10Stop.EnableWindow( FALSE );
	m_BtnInPort.EnableWindow( FALSE );
	m_BtnOutPort.EnableWindow( FALSE );
	m_BtnTriggerStart.EnableWindow( FALSE );
	m_BtnTriggerStop.EnableWindow( FALSE );
	m_BtnStrobe.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// o[W擾
	Status = RSSG2000GetVersion( hCom, CmbMacAdrsBuf, Version );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RSSG2000GetVersion G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		m_StrVersion.Format( "%x.%02x", Version[0], Version[1] );
	}

	// RSSI擾
	Status = RSSG2000GetRSSI( hCom, CmbMacAdrsBuf, &RSSI );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RSSG2000GetRSSI G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%d", RSSI );
		m_StrRSSI = MsgBuf;
	}

	// x擾
	Status = RSSG2000GetTemp( hCom, CmbMacAdrsBuf, &Temp, &Humidity );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RSSG2000GetTemp G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", Temp );
		m_StrTemp = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", Humidity );
		m_StrHumidity = MsgBuf;
	}

	// JntO
	if( fGP10Start[m_CmbMacAdrs.GetCurSel()] )
	{
		// 
		m_BtnGP10Start.EnableWindow( FALSE );
		// L
		m_BtnGP10Stop.EnableWindow( TRUE );
		m_BtnInPort.EnableWindow( TRUE );
		m_BtnOutPort.EnableWindow( TRUE );
		m_BtnTriggerStart.EnableWindow( TRUE );
		m_BtnTriggerStop.EnableWindow( TRUE );
		m_BtnStrobe.EnableWindow( TRUE );
	}
	else
	{
		// L
		m_BtnGP10Start.EnableWindow( TRUE );
		// 
		m_BtnGP10Stop.EnableWindow( FALSE );
		m_BtnInPort.EnableWindow( FALSE );
		m_BtnOutPort.EnableWindow( FALSE );
		m_BtnTriggerStart.EnableWindow( FALSE );
		m_BtnTriggerStop.EnableWindow( FALSE );
		m_BtnStrobe.EnableWindow( FALSE );
	}
	m_BtnGet.EnableWindow( TRUE );
	m_BtnGet.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2010Dlg::OnCbnSelchangeMacadrs()
{
	CString strMacAdrs;
	UCHAR Version[8];
	CHAR	RSSI;
	double	Temp, Humidity;

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );

	// R{{bNX擾
	m_CmbMacAdrs.GetLBText( m_CmbMacAdrs.GetCurSel(), strMacAdrs );

	CmbMacAdrsBuf[0] = (UCHAR)strtoul( strMacAdrs.Mid( 0, 2), NULL, 16 );
	CmbMacAdrsBuf[1] = (UCHAR)strtoul( strMacAdrs.Mid( 3, 2), NULL, 16 );
	CmbMacAdrsBuf[2] = (UCHAR)strtoul( strMacAdrs.Mid( 6, 2), NULL, 16 );
	CmbMacAdrsBuf[3] = (UCHAR)strtoul( strMacAdrs.Mid( 9, 2), NULL, 16 );
	CmbMacAdrsBuf[4] = (UCHAR)strtoul( strMacAdrs.Mid(12, 2), NULL, 16 );
	CmbMacAdrsBuf[5] = (UCHAR)strtoul( strMacAdrs.Mid(15, 2), NULL, 16 );
	CmbMacAdrsBuf[6] = (UCHAR)strtoul( strMacAdrs.Mid(18, 2), NULL, 16 );
	CmbMacAdrsBuf[7] = (UCHAR)strtoul( strMacAdrs.Mid(21, 2), NULL, 16 );

	if( fStart )
	{
		// o[W擾
		RSSG2000GetVersion( hCom, CmbMacAdrsBuf, Version );
		m_StrVersion.Format( "%x.%02x", Version[0], Version[1] );
		// RSSI擾
		RSSG2000GetRSSI( hCom, CmbMacAdrsBuf, &RSSI );
		m_StrRSSI.Format( "%d", RSSI );
		// x擾
		RSSG2000GetTemp( hCom, CmbMacAdrsBuf, &Temp, &Humidity );
		m_StrTemp.Format( "%.2f", Temp );
		m_StrHumidity.Format( "%.2f", Humidity );
	}

	// JntO
	if( fGP10Start[m_CmbMacAdrs.GetCurSel()] )
	{
		// 
		m_BtnGP10Start.EnableWindow( FALSE );
		// L
		m_BtnGP10Stop.EnableWindow( TRUE );
		m_BtnInPort.EnableWindow( TRUE );
		m_BtnOutPort.EnableWindow( TRUE );
		m_BtnTriggerStart.EnableWindow( TRUE );
		m_BtnTriggerStop.EnableWindow( TRUE );
		m_BtnStrobe.EnableWindow( TRUE );
	}
	else
	{
		if( fStart )
		{
			// L
			m_BtnGP10Start.EnableWindow( TRUE );
			// 
			m_BtnGP10Stop.EnableWindow( FALSE );
			m_BtnInPort.EnableWindow( FALSE );
			m_BtnOutPort.EnableWindow( FALSE );
			m_BtnTriggerStart.EnableWindow( FALSE );
			m_BtnTriggerStop.EnableWindow( FALSE );
			m_BtnStrobe.EnableWindow( FALSE );
		}
	}


	UpdateData( FALSE );
}

void CRSSG2010Dlg::OnBnClickedCancel()
{
	BYTE	iii;

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	m_StrMsg = "~...";
	UpdateData( FALSE );
	UpdateWindow(); 

	if( fStart )
	{
		// ~
		RSSG2000Stop( hCom );

		for( iii = 0; iii < MaxCount*8; iii+=8  )
		{
			if( ( MacAdrs[iii+0] == 0x00 ) && ( MacAdrs[iii+1] == 0x00 ) && ( MacAdrs[iii+2] == 0x00 ) && ( MacAdrs[iii+3] == 0x00 ) && ( MacAdrs[iii+4] == 0x00 ) && ( MacAdrs[iii+5] == 0x00 ) && ( MacAdrs[iii+6] == 0x00 ) && ( MacAdrs[iii+7] == 0x00 ) )
				;
			else
			{
				// 폜
				RSSG2000DeleteMacAdrs( hCom, (PUCHAR)(MacAdrs + iii) );
			}
		}
		// N[Y
		RSSG2000Close( hCom );
		hCom = INVALID_HANDLE_VALUE;
	}

	CDialogEx::OnCancel();
}

