using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;


namespace RSSG20GP40
{
    public partial class RSSG2040 : Form
    {
        UInt32 hCom;
        byte[] MacAdrs = new byte [17*8];
        byte[] CmbMacAdrsBuf = new byte[8];
        Boolean fStart;
        Boolean[] fGP40Start = new Boolean[17];

        private RSSG2000.DLL.ErrorCallback ErrorFunc;
        private RSSG2000.DLL.TimerDataCallback TimerDataFunc;
        private RSSG2000.DLL.AlarmCallback AlarmFunc;
        private RSSG2000.DLL.RegistCallback RegistFunc;

        delegate void SetTextCallback(TextBox textBox, string text);
        private void SetText(TextBox textBox, string text)
        {
            // 呼び出し元のコントロールのスレッドが異なるか確認をする
            if (textBox.InvokeRequired)
            {
                // 同一メソッドへのコールバックを作成する
                SetTextCallback delegateMethod = new SetTextCallback(SetText);

                // コントロールの親のInvoke()メソッドを呼び出すことで、呼び出し元の
                // コントロールのスレッドでこのメソッドを実行する
                this.BeginInvoke(delegateMethod, new object[] { textBox, text });
            }
            else
            {
                // コントロールを直接呼び出す
                textBox.Text = text;
            }
        }

        // コールバック
        unsafe private void CallBackErrorFunc(Byte* pData)
        {
            SetText(TxtMsg, String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackErrorFunc[{8:X2}]", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7], pData[8]));
        }
        unsafe private void CallBackTimerDataFunc(Byte* pData)
        {
            SetText(TxtMsg, String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackTimerDataFunc\r\n[{8:F2}][{9:F2}][{10:F2}][{11:F2}][{12:F2}][{13:F2}][{14:F2}][{15:F2}]", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7], GetdbValue(0, (ushort)(pData[8] * 256 + pData[9])), GetdbValue(1, (ushort)(pData[10] * 256 + pData[11])), GetdbValue(2, (ushort)(pData[12] * 256 + pData[13])), GetdbValue(3, (ushort)(pData[14] * 256 + pData[15])), GetdbValue(4, (ushort)(pData[16] * 256 + pData[17])), GetdbValue(5, (ushort)(pData[18] * 256 + pData[19])), GetdbValue(6, (ushort)(pData[20] * 256 + pData[21])), GetdbValue(7, (ushort)(pData[22] * 256 + pData[23]))) );
        }
        unsafe private void CallBackAlarmFunc(Byte* pData)
        {
            DateTime CurrentTime;
            string FileName;
            System.IO.Stream hWrite;
            byte[] CsvData = new byte[64];
            string strCsv;
            byte[] Dest = new byte[816];
            ushort iii;

            // Byte[]変換
            Marshal.Copy((IntPtr)pData, Dest, 0, 816); 

            SetText(TxtMsg, String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackAlarmFunc", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7]));

            if (pData[8] == 0)
            {
                CurrentTime = DateTime.Now;
                FileName = String.Format("{0:d}{1:d2}{2:d2}_{3:d2}{4:d2}{5:d2}.csv", CurrentTime.Year, CurrentTime.Month, CurrentTime.Day, CurrentTime.Hour, CurrentTime.Minute, CurrentTime.Second);

                SaveFileDialog saveFileDialog = new SaveFileDialog();

                // 選択可能ﾌｧｲﾙ
                saveFileDialog.Filter = "CSV files{*.csv}|*.csv";
                // ｶﾚﾝﾄﾃﾞｨﾚｸﾄﾘ名
                saveFileDialog.InitialDirectory = Application.ExecutablePath;
                // ｶﾚﾝﾄﾌｧｲﾙ名
                saveFileDialog.FileName = FileName;

                // ﾌｧｲﾙを開く
                hWrite = saveFileDialog.OpenFile();
                if (hWrite == null)
                    return;
                // MACアドレス/トリガーチャンネル(bit表示)/件数
                strCsv = String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}], 0x{8:X2}, {9:D}\r\n", Dest[0], Dest[1], Dest[2], Dest[3], Dest[4], Dest[5], Dest[6], Dest[7], Dest[9], Dest[10] );
                CsvData = System.Text.Encoding.ASCII.GetBytes( strCsv );
                hWrite.Write(CsvData, 0, strCsv.Length);
                //ヘッダ
                strCsv = String.Format("CH0,CH1,CH2,CH3,CH4,CH5,CH6,CH7\r\n" );
                CsvData = System.Text.Encoding.ASCII.GetBytes( strCsv );
                hWrite.Write(CsvData, 0, strCsv.Length);
                // データ
                for( iii = 0; iii < 800; iii+=16 )
                {
                    strCsv = String.Format("{0:F2},{1:F2},{2:F2},{3:F2},{4:F2},{5:F2},{6:F2},{7:F2}\r\n", GetdbValue(0, (ushort)(Dest[16 + iii + 0] * 256 + Dest[16 + iii + 1])), GetdbValue(1, (ushort)(Dest[16 + iii + 2] * 256 + Dest[16 + iii + 3])), GetdbValue(2, (ushort)(Dest[16 + iii + 4] * 256 + Dest[16 + iii + 5])), GetdbValue(3, (ushort)(Dest[16 + iii + 6] * 256 + Dest[16 + iii + 7])), GetdbValue(4, (ushort)(Dest[16 + iii + 8] * 256 + Dest[16 + iii + 9])), GetdbValue(5, (ushort)(Dest[16 + iii + 10] * 256 + Dest[16 + iii + 11])), GetdbValue(6, (ushort)(Dest[16 + iii + 12] * 256 + Dest[16 + iii + 13])), GetdbValue(7, (ushort)(Dest[16 + iii + 14] * 256 + Dest[16 + iii + 15])));
                    CsvData = System.Text.Encoding.ASCII.GetBytes( strCsv );
                    hWrite.Write(CsvData, 0, strCsv.Length);
                }
                
                // ﾌｧｲﾙを閉じる
                hWrite.Close();
            }
        }
        unsafe private void CallBackRegistFunc(Byte* pData)
        {
            byte[] MacAdrsBuf = new byte[8];
            SetText(TxtMsg, String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackRegistFunc", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7]));
            // MACアドレス
            MacAdrsBuf[0] = pData[0]; MacAdrsBuf[1] = pData[1]; MacAdrsBuf[2] = pData[2]; MacAdrsBuf[3] = pData[3];
            MacAdrsBuf[4] = pData[4]; MacAdrsBuf[5] = pData[5]; MacAdrsBuf[6] = pData[6]; MacAdrsBuf[7] = pData[7];
            // 登録
            RSSG2000.DLL.RSSG2000RegistMacAdrs(hCom, MacAdrsBuf);

            // コンボボックス追加
            CmbMacAdrs.Items.Add(String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}", MacAdrsBuf[0], MacAdrsBuf[1], MacAdrsBuf[2], MacAdrsBuf[3], MacAdrsBuf[4], MacAdrsBuf[5], MacAdrsBuf[6], MacAdrsBuf[7]));
            CmbMacAdrs.SelectedIndex = 0;
        }


        unsafe public RSSG2040()
        {
            InitializeComponent();

            ErrorFunc = new RSSG2000.DLL.ErrorCallback(CallBackErrorFunc);
            TimerDataFunc = new RSSG2000.DLL.TimerDataCallback(CallBackTimerDataFunc);
            AlarmFunc = new RSSG2000.DLL.AlarmCallback(CallBackAlarmFunc);
            RegistFunc = new RSSG2000.DLL.RegistCallback(CallBackRegistFunc);
        }

        private void RSSG20GP40_Load(object sender, EventArgs e)
        {
            Byte iii;
            string[] RangeBuf;
            //RangeBuf = new string[9] { "±10.24V", "±5.12V", "±2.56V", "±1.28V", "±0.64V", "0～10.24V", "0～5.12V", "0～2.56V", "0～1.28V" };
            RangeBuf = new string[9] { "±10V", "±5V", "±2.5V", "±1V", "±0.5V", "0～10V", "0～5V", "0～2.5V", "0～1V" };

            // COMポート番号
            TxtCOM.Text = "16";
            // チャンネル
            TxtChannel.Text = "4";
            // 検索台数
            TxtSG20Count.Text = "1";
            // 開始フラグ
            for (iii = 0; iii < 17; iii++)
                fGP40Start[iii] = false;
            fStart = false;

            // 無効
            BtnStop.Enabled = false;
            BtnGP40Start.Enabled = false;
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // サンプリング設定
            ChkCH0.Checked = true;
            ChkCH1.Checked = true;
            ChkCH2.Checked = true;
            ChkCH3.Checked = true;
            ChkCH4.Checked = true;
            ChkCH5.Checked = true;
            ChkCH6.Checked = true;
            ChkCH7.Checked = true;

            // Range設定
            for (iii = 0; iii < 9; iii++)
            {
                CmbCH0.Items.Add(RangeBuf[iii]);
                CmbCH1.Items.Add(RangeBuf[iii]);
                CmbCH2.Items.Add(RangeBuf[iii]);
                CmbCH3.Items.Add(RangeBuf[iii]);
                CmbCH4.Items.Add(RangeBuf[iii]);
                CmbCH5.Items.Add(RangeBuf[iii]);
                CmbCH6.Items.Add(RangeBuf[iii]);
                CmbCH7.Items.Add(RangeBuf[iii]);
            }
            CmbCH0.SelectedIndex = 0;
            CmbCH1.SelectedIndex = 0;
            CmbCH2.SelectedIndex = 0;
            CmbCH3.SelectedIndex = 0;
            CmbCH4.SelectedIndex = 0;
            CmbCH5.SelectedIndex = 0;
            CmbCH6.SelectedIndex = 0;
            CmbCH7.SelectedIndex = 0;
            // 閾値設定
            TxtLowerCH0.Text = "-10.24";
            TxtLowerCH1.Text = "-10.24";
            TxtLowerCH2.Text = "-10.24";
            TxtLowerCH3.Text = "-10.24";
            TxtLowerCH4.Text = "-10.24";
            TxtLowerCH5.Text = "-10.24";
            TxtLowerCH6.Text = "-10.24";
            TxtLowerCH7.Text = "-10.24";
            TxtUpperCH0.Text = "10.24";
            TxtUpperCH1.Text = "10.24";
            TxtUpperCH2.Text = "10.24";
            TxtUpperCH3.Text = "10.24";
            TxtUpperCH4.Text = "10.24";
            TxtUpperCH5.Text = "10.24";
            TxtUpperCH6.Text = "10.24";
            TxtUpperCH7.Text = "10.24";
            // サンプリング間隔
            TxtSampling.Text = "100";
            // トリガポイント
            TxtTrigger.Text = "25";
        }

        private void BtnClear_Click(object sender, EventArgs e)
        {
            // メッセージ削除
            TxtMsg.Text = "";
            BtnClear.Focus();
        }

        unsafe private void BtnStart_Click(object sender, EventArgs e)
        {
            byte iii;
            byte[] Version = new byte[8];
            SByte RSSI;
            double Temp, Humidity;
            byte Count;

            if ((TxtCOM.Text.Length == 0) || (Int32.Parse(TxtCOM.Text) < 1) || (Int32.Parse(TxtCOM.Text) > 255))
            {
                MessageBox.Show("1-255のCOMポート番号を指定してください");
                return;
            }
            if ((TxtChannel.Text.Length == 0) || (Int32.Parse(TxtChannel.Text) < 4) || (Int32.Parse(TxtChannel.Text) > 17))
            {
                MessageBox.Show("4-17のチャンネルを指定してください");
                return;
            }
            if ((TxtSG20Count.Text.Length == 0) || (Int32.Parse(TxtSG20Count.Text) < 1) || (Int32.Parse(TxtSG20Count.Text) > 17))
            {
                MessageBox.Show("1-17の台数を指定してください");
                return;
            }

            Count = 0;
            TxtMsg.Text = "開始中...";
            Application.DoEvents();
            // オープン
            hCom = RSSG2000.DLL.RSSG2000Open(Byte.Parse(TxtCOM.Text), Byte.Parse(TxtChannel.Text), Byte.Parse(TxtSG20Count.Text), RegistFunc);
            if (hCom != 0xFFFFFFFF)
            {
                Array.Clear(MacAdrs, 0, MacAdrs.Length);
                // アドレス取得
                RSSG2000.DLL.RSSG2000GetMacAdrs(hCom, MacAdrs);
                // 表示
                for (iii = 0; iii < 16 * 8; iii += 8)
                {
                    if ((MacAdrs[iii + 0] == 0x00) && (MacAdrs[iii + 1] == 0x00) && (MacAdrs[iii + 2] == 0x00) && (MacAdrs[iii + 3] == 0x00) && (MacAdrs[iii + 4] == 0x00) && (MacAdrs[iii + 5] == 0x00) && (MacAdrs[iii + 6] == 0x00) && (MacAdrs[iii + 7] == 0x00))
                    {
                        ;
                    }
                    else
                    {
                        CmbMacAdrsBuf[0] = MacAdrs[iii + 0];
                        CmbMacAdrsBuf[1] = MacAdrs[iii + 1];
                        CmbMacAdrsBuf[2] = MacAdrs[iii + 2];
                        CmbMacAdrsBuf[3] = MacAdrs[iii + 3];
                        CmbMacAdrsBuf[4] = MacAdrs[iii + 4];
                        CmbMacAdrsBuf[5] = MacAdrs[iii + 5];
                        CmbMacAdrsBuf[6] = MacAdrs[iii + 6];
                        CmbMacAdrsBuf[7] = MacAdrs[iii + 7];

                        // 登録
                        RSSG2000.DLL.RSSG2000RegistMacAdrs(hCom, CmbMacAdrsBuf);

                        // 無効
                        BtnStart.Enabled = false;
                        // 有効
                        BtnStop.Enabled = true;

                        // コンボボックス追加
                        CmbMacAdrs.Items.Add(String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}", MacAdrs[iii + 0], MacAdrs[iii + 1], MacAdrs[iii + 2], MacAdrs[iii + 3], MacAdrs[iii + 4], MacAdrs[iii + 5], MacAdrs[iii + 6], MacAdrs[iii + 7]));
                        Count++;
                    }
                }
                if (Count != 0)
                {
                    CmbMacAdrs.SelectedIndex = 0;

                    // 開始
                    RSSG2000.DLL.RSSG2000Start(hCom);

                    System.Threading.Thread.Sleep(500);
                    // バージョン取得
                    RSSG2000.DLL.RSSG2000GetVersion(hCom, CmbMacAdrsBuf, Version);
                    TxtVersion.Text = String.Format("{0:x}.{1:X2}", Version[0], Version[1]);
                    // RSSI 取得
                    RSSG2000.DLL.RSSG2000GetRSSI(hCom, CmbMacAdrsBuf, &RSSI);
                    TxtRSSI.Text = String.Format("{0:D}", RSSI);
                    // 温湿度取得
                    RSSG2000.DLL.RSSG2000GetTemp(hCom, CmbMacAdrsBuf, &Temp, &Humidity);
                    TxtTemp.Text = String.Format("{0:F1}", Temp);
                    TxtHumidity.Text = String.Format("{0:F1}", Humidity);

                    // 有効
                    BtnGP40Start.Enabled = true;
                    BtnGet.Enabled = true;

                    // 読み取り専用
                    TxtCOM.ReadOnly = true;
                    TxtChannel.ReadOnly = true;
                    TxtSG20Count.ReadOnly = true;

                    fStart = true;
                    if (Count != Byte.Parse(TxtSG20Count.Text))
                    {
                        MessageBox.Show("指定台数のSubGiga入出力ベースボードが見つかりません");
                    }
                }
                else
                {
                    // クローズ
                    RSSG2000.DLL.RSSG2000Close(hCom);
                    hCom = 0xFFFFFFFF;
                    MessageBox.Show("SubGiga入出力ベースボードが見つかりません");
                }
            }
            else
            {
                MessageBox.Show("COMオープンエラー");
            }
            TxtMsg.Text = "";
            BtnStart.Focus();
        }

        private void BtnStop_Click(object sender, EventArgs e)
        {
            byte iii;

            TxtMsg.Text = "停止中...";
            Application.DoEvents();

            if (fStart)
            {
                // 停止
                RSSG2000.DLL.RSSG2000Stop(hCom);

                for (iii = 0; iii < 16 * 8; iii += 8)
                {
                    if ((MacAdrs[iii + 0] == 0x00) && (MacAdrs[iii + 1] == 0x00) && (MacAdrs[iii + 2] == 0x00) && (MacAdrs[iii + 3] == 0x00) && (MacAdrs[iii + 4] == 0x00) && (MacAdrs[iii + 5] == 0x00) && (MacAdrs[iii + 6] == 0x00) && (MacAdrs[iii + 7] == 0x00))
                    {
                        ;
                    }
                    else
                    {
                        CmbMacAdrsBuf[0] = MacAdrs[iii + 0];
                        CmbMacAdrsBuf[1] = MacAdrs[iii + 1];
                        CmbMacAdrsBuf[2] = MacAdrs[iii + 2];
                        CmbMacAdrsBuf[3] = MacAdrs[iii + 3];
                        CmbMacAdrsBuf[4] = MacAdrs[iii + 4];
                        CmbMacAdrsBuf[5] = MacAdrs[iii + 5];
                        CmbMacAdrsBuf[6] = MacAdrs[iii + 6];
                        CmbMacAdrsBuf[7] = MacAdrs[iii + 7];

                        // 削除
                        RSSG2000.DLL.RSSG2000DeleteMacAdrs(hCom, CmbMacAdrsBuf);
                    }
                }

                // クローズ
                RSSG2000.DLL.RSSG2000Close(hCom);
                hCom = 0xFFFFFFFF;
            }

            // 開始フラグ
            for (iii = 0; iii < 17; iii++)
                fGP40Start[iii] = false;
            fStart = false;

            // 有効
            BtnStart.Enabled = true;
            // 無効
            BtnStop.Enabled = false;
            BtnGP40Start.Enabled = false;
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // コンボボックス削除
            CmbMacAdrs.Items.Clear();
            TxtMsg.Text = "";
            TxtVersion.Text = "";
            TxtRSSI.Text = "";
            TxtTemp.Text = "";
            TxtHumidity.Text = "";
            // 読み取り専用解除
            TxtCOM.ReadOnly = false;
            TxtChannel.ReadOnly = false;
            TxtSG20Count.ReadOnly = false;
            BtnStop.Focus();
        }

        unsafe private void BtnGP40Start_Click(object sender, EventArgs e)
        {
            UInt32 Status;

            TxtMsg.Text = "開始中...";
            Application.DoEvents();
            // オープン
            Status = RSSG2000.DLL.RPiGP40Open(hCom, CmbMacAdrsBuf, TimerDataFunc, AlarmFunc, ErrorFunc);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP40Open エラー [{0:X}]", Status);
                return;
            }

            // 無効
            BtnGP40Start.Enabled = false;
            // 有効
            BtnGP40Stop.Enabled = true;
            BtnDIOHighOut.Enabled = true;
            BtnDIOLowOut.Enabled = true;
            BtnDIOIn.Enabled = true;
            BtnGetSetting.Enabled = true;
            BtnSetSetting.Enabled = true;
            BtnGetStart.Enabled = true;
            BtnGetStop.Enabled = true;
            BtnOneShot.Enabled = true;
            BtnGet.Enabled = true;
            TxtMsg.Text = "";
            // 開始フラグ
            fGP40Start[CmbMacAdrs.SelectedIndex] = true;
            BtnGP40Start.Focus();
        }

        private void BtnGP40Stop_Click(object sender, EventArgs e)
        {
            TxtMsg.Text = "停止中...";
            Application.DoEvents();

            // 開始フラグ
            fGP40Start[CmbMacAdrs.SelectedIndex] = false;
            // GP40クローズ
            RSSG2000.DLL.RPiGP40Close(hCom, CmbMacAdrsBuf);
            TxtMsg.Text = "";

            // 有効
            BtnGP40Start.Enabled = true;
            // 無効
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGP40Stop.Focus();
        }

        unsafe private void BtnGet_Click(object sender, EventArgs e)
        {
            UInt32 Status;
            byte[] Version = new byte[8];
            SByte RSSI;
            double Temp, Humidity;

            // 無効
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // バージョン取得
            Status = RSSG2000.DLL.RSSG2000GetVersion(hCom, CmbMacAdrsBuf, Version);
            if (Status != 0)
                TxtMsg.Text = String.Format("RSSG2000GetVersion エラー : {0:X}", Status);
            else
                TxtVersion.Text = String.Format("{0:x}.{1:X2}", Version[0], Version[1]);

            // RSSI取得
            Status = RSSG2000.DLL.RSSG2000GetRSSI(hCom, CmbMacAdrsBuf, &RSSI);
            if (Status != 0)
                TxtMsg.Text = String.Format("RSSG2000GetRSSI エラー : {0:X}", Status);
            else
                TxtRSSI.Text = String.Format("{0:D}", RSSI);

            // 温湿度取得
            Status = RSSG2000.DLL.RSSG2000GetTemp(hCom, CmbMacAdrsBuf, &Temp, &Humidity);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RSSG2000GetTemp エラー : {0:X}", Status);
            }
            else
            {
                TxtTemp.Text = String.Format("{0:F1}", Temp);
                TxtHumidity.Text = String.Format("{0:F1}", Humidity);
            }

            // 開始フラグ
            if (fGP40Start[CmbMacAdrs.SelectedIndex])
            {
                // 無効
                BtnGP40Start.Enabled = false;
                // 有効
                BtnGP40Stop.Enabled = true;
                BtnDIOHighOut.Enabled = true;
                BtnDIOLowOut.Enabled = true;
                BtnDIOIn.Enabled = true;
                BtnGetSetting.Enabled = true;
                BtnSetSetting.Enabled = true;
                BtnGetStart.Enabled = true;
                BtnGetStop.Enabled = true;
                BtnOneShot.Enabled = true;
            }
            else
            {
                // 有効
                BtnGP40Start.Enabled = true;
                // 無効
                BtnGP40Stop.Enabled = false;
                BtnDIOHighOut.Enabled = false;
                BtnDIOLowOut.Enabled = false;
                BtnDIOIn.Enabled = false;
                BtnGetSetting.Enabled = false;
                BtnSetSetting.Enabled = false;
                BtnGetStart.Enabled = false;
                BtnGetStop.Enabled = false;
                BtnOneShot.Enabled = false;
            }
            BtnGet.Enabled = true;
        }

        unsafe private void BtnGetSetting_Click(object sender, EventArgs e)
        {
            UInt32 Status;
            RSSG2000.DLL.GP40Setting GettingData40;

            // 無効
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // 設定読込
            Status = RSSG2000.DLL.RPiGP40GetSetting(hCom, CmbMacAdrsBuf, &GettingData40);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP40GetSetting エラー [{0:X}]", Status);
            }
            else
            {
                // サンプリングの有無
                ChkCH0.Checked = false;
                if ((GettingData40.ChannelEnable & 0x01) == 0x01)
                    ChkCH0.Checked = true;
                ChkCH1.Checked = false;
                if ((GettingData40.ChannelEnable & 0x02) == 0x02)
                    ChkCH1.Checked = true;
                ChkCH2.Checked = false;
                if ((GettingData40.ChannelEnable & 0x04) == 0x04)
                    ChkCH2.Checked = true;
                ChkCH3.Checked = false;
                if ((GettingData40.ChannelEnable & 0x08) == 0x08)
                    ChkCH3.Checked = true;
                ChkCH4.Checked = false;
                if ((GettingData40.ChannelEnable & 0x10) == 0x10)
                    ChkCH4.Checked = true;
                ChkCH5.Checked = false;
                if ((GettingData40.ChannelEnable & 0x20) == 0x20)
                    ChkCH5.Checked = true;
                ChkCH6.Checked = false;
                if ((GettingData40.ChannelEnable & 0x40) == 0x40)
                    ChkCH6.Checked = true;
                ChkCH7.Checked = false;
                if ((GettingData40.ChannelEnable & 0x80) == 0x80)
                    ChkCH7.Checked = true;

                // アラーム通知
                ChkAlarm.Checked = false;
                if (GettingData40.AlarmEnable == 0x10)
                    ChkAlarm.Checked = true;

                // サンプリング間隔
                TxtSampling.Text = String.Format("{0:D}", GettingData40.SampTime);

                // トリガポイント
                TxtTrigger.Text = String.Format("{0:D}", GettingData40.Trigger);

                // レンジ(CH0)
                if ((GettingData40.ChannelRange & 0x0000000F) == 0x00)
                    CmbCH0.SelectedIndex = 0;
                if ((GettingData40.ChannelRange & 0x0000000F) == 0x01)
                    CmbCH0.SelectedIndex = 1;
                if ((GettingData40.ChannelRange & 0x0000000F) == 0x02)
                    CmbCH0.SelectedIndex = 2;
                if ((GettingData40.ChannelRange & 0x0000000F) == 0x03)
                    CmbCH0.SelectedIndex = 3;
                if ((GettingData40.ChannelRange & 0x0000000F) == 0x0B)
                    CmbCH0.SelectedIndex = 4;
                if ((GettingData40.ChannelRange & 0x0000000F) == 0x05)
                    CmbCH0.SelectedIndex = 5;
                if ((GettingData40.ChannelRange & 0x0000000F) == 0x06)
                    CmbCH0.SelectedIndex = 6;
                if ((GettingData40.ChannelRange & 0x0000000F) == 0x07)
                    CmbCH0.SelectedIndex = 7;
                if ((GettingData40.ChannelRange & 0x0000000F) == 0x0F)
                    CmbCH0.SelectedIndex = 8;
                // レンジ(CH1)
                if ((GettingData40.ChannelRange & 0x000000F0) >> 4 == 0x00)
                    CmbCH1.SelectedIndex = 0;
                if ((GettingData40.ChannelRange & 0x000000F0) >> 4 == 0x01)
                    CmbCH1.SelectedIndex = 1;
                if ((GettingData40.ChannelRange & 0x000000F0) >> 4 == 0x02)
                    CmbCH1.SelectedIndex = 2;
                if ((GettingData40.ChannelRange & 0x000000F0) >> 4 == 0x03)
                    CmbCH1.SelectedIndex = 3;
                if ((GettingData40.ChannelRange & 0x000000F0) >> 4 == 0x0B)
                    CmbCH1.SelectedIndex = 4;
                if ((GettingData40.ChannelRange & 0x000000F0) >> 4 == 0x05)
                    CmbCH1.SelectedIndex = 5;
                if ((GettingData40.ChannelRange & 0x000000F0) >> 4 == 0x06)
                    CmbCH1.SelectedIndex = 6;
                if ((GettingData40.ChannelRange & 0x000000F0) >> 4 == 0x07)
                    CmbCH1.SelectedIndex = 7;
                if ((GettingData40.ChannelRange & 0x000000F0) >> 4 == 0x0F)
                    CmbCH1.SelectedIndex = 8;
                // レンジ(CH2)
                if ((GettingData40.ChannelRange & 0x00000F00) >> 8 == 0x00)
                    CmbCH2.SelectedIndex = 0;
                if ((GettingData40.ChannelRange & 0x00000F00) >> 8 == 0x01)
                    CmbCH2.SelectedIndex = 1;
                if ((GettingData40.ChannelRange & 0x00000F00) >> 8 == 0x02)
                    CmbCH2.SelectedIndex = 2;
                if ((GettingData40.ChannelRange & 0x00000F00) >> 8 == 0x03)
                    CmbCH2.SelectedIndex = 3;
                if ((GettingData40.ChannelRange & 0x00000F00) >> 8 == 0x0B)
                    CmbCH2.SelectedIndex = 4;
                if ((GettingData40.ChannelRange & 0x00000F00) >> 8 == 0x05)
                    CmbCH2.SelectedIndex = 5;
                if ((GettingData40.ChannelRange & 0x00000F00) >> 8 == 0x06)
                    CmbCH2.SelectedIndex = 6;
                if ((GettingData40.ChannelRange & 0x00000F00) >> 8 == 0x07)
                    CmbCH2.SelectedIndex = 7;
                if ((GettingData40.ChannelRange & 0x00000F00) >> 8 == 0x0F)
                    CmbCH2.SelectedIndex = 8;
                // レンジ(CH3)
                if ((GettingData40.ChannelRange & 0x0000F000) >> 12 == 0x00)
                    CmbCH3.SelectedIndex = 0;
                if ((GettingData40.ChannelRange & 0x0000F000) >> 12 == 0x01)
                    CmbCH3.SelectedIndex = 1;
                if ((GettingData40.ChannelRange & 0x0000F000) >> 12 == 0x02)
                    CmbCH3.SelectedIndex = 2;
                if ((GettingData40.ChannelRange & 0x0000F000) >> 12 == 0x03)
                    CmbCH3.SelectedIndex = 3;
                if ((GettingData40.ChannelRange & 0x0000F000) >> 12 == 0x0B)
                    CmbCH3.SelectedIndex = 4;
                if ((GettingData40.ChannelRange & 0x0000F000) >> 12 == 0x05)
                    CmbCH3.SelectedIndex = 5;
                if ((GettingData40.ChannelRange & 0x0000F000) >> 12 == 0x06)
                    CmbCH3.SelectedIndex = 6;
                if ((GettingData40.ChannelRange & 0x0000F000) >> 12 == 0x07)
                    CmbCH3.SelectedIndex = 7;
                if ((GettingData40.ChannelRange & 0x0000F000) >> 12 == 0x0F)
                    CmbCH3.SelectedIndex = 8;
                // レンジ(CH4)
                if ((GettingData40.ChannelRange & 0x000F0000) >> 16 == 0x00)
                    CmbCH4.SelectedIndex = 0;
                if ((GettingData40.ChannelRange & 0x000F0000) >> 16 == 0x01)
                    CmbCH4.SelectedIndex = 1;
                if ((GettingData40.ChannelRange & 0x000F0000) >> 16 == 0x02)
                    CmbCH4.SelectedIndex = 2;
                if ((GettingData40.ChannelRange & 0x000F0000) >> 16 == 0x03)
                    CmbCH4.SelectedIndex = 3;
                if ((GettingData40.ChannelRange & 0x000F0000) >> 16 == 0x0B)
                    CmbCH4.SelectedIndex = 4;
                if ((GettingData40.ChannelRange & 0x000F0000) >> 16 == 0x05)
                    CmbCH4.SelectedIndex = 5;
                if ((GettingData40.ChannelRange & 0x000F0000) >> 16 == 0x06)
                    CmbCH4.SelectedIndex = 6;
                if ((GettingData40.ChannelRange & 0x000F0000) >> 16 == 0x07)
                    CmbCH4.SelectedIndex = 7;
                if ((GettingData40.ChannelRange & 0x000F0000) >> 16 == 0x0F)
                    CmbCH4.SelectedIndex = 8;
                // レンジ(CH5)
                if ((GettingData40.ChannelRange & 0x00F00000) >> 20 == 0x00)
                    CmbCH5.SelectedIndex = 0;
                if ((GettingData40.ChannelRange & 0x00F00000) >> 20 == 0x01)
                    CmbCH5.SelectedIndex = 1;
                if ((GettingData40.ChannelRange & 0x00F00000) >> 20 == 0x02)
                    CmbCH5.SelectedIndex = 2;
                if ((GettingData40.ChannelRange & 0x00F00000) >> 20 == 0x03)
                    CmbCH5.SelectedIndex = 3;
                if ((GettingData40.ChannelRange & 0x00F00000) >> 20 == 0x0B)
                    CmbCH5.SelectedIndex = 4;
                if ((GettingData40.ChannelRange & 0x00F00000) >> 20 == 0x05)
                    CmbCH5.SelectedIndex = 5;
                if ((GettingData40.ChannelRange & 0x00F00000) >> 20 == 0x06)
                    CmbCH5.SelectedIndex = 6;
                if ((GettingData40.ChannelRange & 0x00F00000) >> 20 == 0x07)
                    CmbCH5.SelectedIndex = 7;
                if ((GettingData40.ChannelRange & 0x00F00000) >> 20 == 0x0F)
                    CmbCH5.SelectedIndex = 8;
                // レンジ(CH6)
                if ((GettingData40.ChannelRange & 0x0F000000) >> 24 == 0x00)
                    CmbCH6.SelectedIndex = 0;
                if ((GettingData40.ChannelRange & 0x0F000000) >> 24 == 0x01)
                    CmbCH6.SelectedIndex = 1;
                if ((GettingData40.ChannelRange & 0x0F000000) >> 24 == 0x02)
                    CmbCH6.SelectedIndex = 2;
                if ((GettingData40.ChannelRange & 0x0F000000) >> 24 == 0x03)
                    CmbCH6.SelectedIndex = 3;
                if ((GettingData40.ChannelRange & 0x0F000000) >> 24 == 0x0B)
                    CmbCH6.SelectedIndex = 4;
                if ((GettingData40.ChannelRange & 0x0F000000) >> 24 == 0x05)
                    CmbCH6.SelectedIndex = 5;
                if ((GettingData40.ChannelRange & 0x0F000000) >> 24 == 0x06)
                    CmbCH6.SelectedIndex = 6;
                if ((GettingData40.ChannelRange & 0x0F000000) >> 24 == 0x07)
                    CmbCH6.SelectedIndex = 7;
                if ((GettingData40.ChannelRange & 0x0F000000) >> 24 == 0x0F)
                    CmbCH6.SelectedIndex = 8;
                // レンジ(CH7)
                if ((GettingData40.ChannelRange & 0xF0000000) >> 28 == 0x00)
                    CmbCH7.SelectedIndex = 0;
                if ((GettingData40.ChannelRange & 0xF0000000) >> 28 == 0x01)
                    CmbCH7.SelectedIndex = 1;
                if ((GettingData40.ChannelRange & 0xF0000000) >> 28 == 0x02)
                    CmbCH7.SelectedIndex = 2;
                if ((GettingData40.ChannelRange & 0xF0000000) >> 28 == 0x03)
                    CmbCH7.SelectedIndex = 3;
                if ((GettingData40.ChannelRange & 0xF0000000) >> 28 == 0x0B)
                    CmbCH7.SelectedIndex = 4;
                if ((GettingData40.ChannelRange & 0xF0000000) >> 28 == 0x05)
                    CmbCH7.SelectedIndex = 5;
                if ((GettingData40.ChannelRange & 0xF0000000) >> 28 == 0x06)
                    CmbCH7.SelectedIndex = 6;
                if ((GettingData40.ChannelRange & 0xF0000000) >> 28 == 0x07)
                    CmbCH7.SelectedIndex = 7;
                if ((GettingData40.ChannelRange & 0xF0000000) >> 28 == 0x0F)
                    CmbCH7.SelectedIndex = 8;

                // 上限閾値
                TxtUpperCH0.Text = String.Format("{0:F2}", GetdbValue(0, GettingData40.ChUpperThreshold.Ushortcode_0));
                TxtUpperCH1.Text = String.Format("{0:F2}", GetdbValue(1, GettingData40.ChUpperThreshold.Ushortcode_1));
                TxtUpperCH2.Text = String.Format("{0:F2}", GetdbValue(2, GettingData40.ChUpperThreshold.Ushortcode_2));
                TxtUpperCH3.Text = String.Format("{0:F2}", GetdbValue(3, GettingData40.ChUpperThreshold.Ushortcode_3));
                TxtUpperCH4.Text = String.Format("{0:F2}", GetdbValue(4, GettingData40.ChUpperThreshold.Ushortcode_4));
                TxtUpperCH5.Text = String.Format("{0:F2}", GetdbValue(5, GettingData40.ChUpperThreshold.Ushortcode_5));
                TxtUpperCH6.Text = String.Format("{0:F2}", GetdbValue(6, GettingData40.ChUpperThreshold.Ushortcode_6));
                TxtUpperCH7.Text = String.Format("{0:F2}", GetdbValue(7, GettingData40.ChUpperThreshold.Ushortcode_7));

                // 下限閾値
                TxtLowerCH0.Text = String.Format("{0:F2}", GetdbValue(0, GettingData40.ChLowerThreshold.Ushortcode_0));
                TxtLowerCH1.Text = String.Format("{0:F2}", GetdbValue(1, GettingData40.ChLowerThreshold.Ushortcode_1));
                TxtLowerCH2.Text = String.Format("{0:F2}", GetdbValue(2, GettingData40.ChLowerThreshold.Ushortcode_2));
                TxtLowerCH3.Text = String.Format("{0:F2}", GetdbValue(3, GettingData40.ChLowerThreshold.Ushortcode_3));
                TxtLowerCH4.Text = String.Format("{0:F2}", GetdbValue(4, GettingData40.ChLowerThreshold.Ushortcode_4));
                TxtLowerCH5.Text = String.Format("{0:F2}", GetdbValue(5, GettingData40.ChLowerThreshold.Ushortcode_5));
                TxtLowerCH6.Text = String.Format("{0:F2}", GetdbValue(6, GettingData40.ChLowerThreshold.Ushortcode_6));
                TxtLowerCH7.Text = String.Format("{0:F2}", GetdbValue(7, GettingData40.ChLowerThreshold.Ushortcode_7));
            }

            // 有効
            BtnGP40Stop.Enabled = true;
            BtnDIOHighOut.Enabled = true;
            BtnDIOLowOut.Enabled = true;
            BtnDIOIn.Enabled = true;
            BtnGetSetting.Enabled = true;
            BtnSetSetting.Enabled = true;
            BtnGetStart.Enabled = true;
            BtnGetStop.Enabled = true;
            BtnOneShot.Enabled = true;
            BtnGet.Enabled = true;
            BtnGetSetting.Focus();
        }

        private void BtnSetSetting_Click(object sender, EventArgs e)
        {
            UInt32 Status;
            RSSG2000.DLL.GP40Setting SettingData40;

            if ((TxtSampling.Text.Length == 0 ) || (Int32.Parse(TxtSampling.Text) < 1) || (Int32.Parse(TxtSampling.Text) > 65535))
            {
                MessageBox.Show("1-65535のサンプリング間隔を指定してください");
                return;
            }
            if ((TxtTrigger.Text.Length == 0) || (Int32.Parse(TxtTrigger.Text) < 1) || (Int32.Parse(TxtTrigger.Text) > 50))
            {
                MessageBox.Show("1-50のトリガポイントを指定してください");
                return;
            }


            SettingData40 = new RSSG2000.DLL.GP40Setting();

            // 無効
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // サンプリングの有無
            SettingData40.ChannelEnable = 0x00;
            if (ChkCH0.Checked)
                SettingData40.ChannelEnable |= 0x01;
            if (ChkCH1.Checked)
                SettingData40.ChannelEnable |= 0x02;
            if (ChkCH2.Checked)
                SettingData40.ChannelEnable |= 0x04;
            if (ChkCH3.Checked)
                SettingData40.ChannelEnable |= 0x08;
            if (ChkCH4.Checked)
                SettingData40.ChannelEnable |= 0x10;
            if (ChkCH5.Checked)
                SettingData40.ChannelEnable |= 0x20;
            if (ChkCH6.Checked)
                SettingData40.ChannelEnable |= 0x40;
            if (ChkCH7.Checked)
                SettingData40.ChannelEnable |= 0x80;

            // アラーム通知
            SettingData40.AlarmEnable = 0x00;
            if (ChkAlarm.Checked)
                SettingData40.AlarmEnable = 0x10;

            // サンプリング間隔
            SettingData40.SampTime = UInt16.Parse(TxtSampling.Text);

            // トリガポイント
            SettingData40.Trigger = Byte.Parse(TxtTrigger.Text);

            // レンジ(CH0)
            SettingData40.ChannelRange = 0x00000000;
            if (CmbCH0.SelectedIndex == 0)
                SettingData40.ChannelRange |= 0x00000000;
            if (CmbCH0.SelectedIndex == 1)
                SettingData40.ChannelRange |= 0x00000001;
            if (CmbCH0.SelectedIndex == 2)
                SettingData40.ChannelRange |= 0x00000002;
            if (CmbCH0.SelectedIndex == 3)
                SettingData40.ChannelRange |= 0x00000003;
            if (CmbCH0.SelectedIndex == 4)
                SettingData40.ChannelRange |= 0x0000000B;
            if (CmbCH0.SelectedIndex == 5)
                SettingData40.ChannelRange |= 0x00000005;
            if (CmbCH0.SelectedIndex == 6)
                SettingData40.ChannelRange |= 0x00000006;
            if (CmbCH0.SelectedIndex == 7)
                SettingData40.ChannelRange |= 0x00000007;
            if (CmbCH0.SelectedIndex == 8)
                SettingData40.ChannelRange |= 0x0000000F;
            // レンジ(CH1)
            if (CmbCH1.SelectedIndex == 0)
                SettingData40.ChannelRange |= 0x00000000;
            if (CmbCH1.SelectedIndex == 1)
                SettingData40.ChannelRange |= 0x00000010;
            if (CmbCH1.SelectedIndex == 2)
                SettingData40.ChannelRange |= 0x00000020;
            if (CmbCH1.SelectedIndex == 3)
                SettingData40.ChannelRange |= 0x00000030;
            if (CmbCH1.SelectedIndex == 4)
                SettingData40.ChannelRange |= 0x000000B0;
            if (CmbCH1.SelectedIndex == 5)
                SettingData40.ChannelRange |= 0x00000050;
            if (CmbCH1.SelectedIndex == 6)
                SettingData40.ChannelRange |= 0x00000060;
            if (CmbCH1.SelectedIndex == 7)
                SettingData40.ChannelRange |= 0x00000070;
            if (CmbCH1.SelectedIndex == 8)
                SettingData40.ChannelRange |= 0x000000F0;
            // レンジ(CH2)
            if (CmbCH2.SelectedIndex == 0)
                SettingData40.ChannelRange |= 0x00000000;
            if (CmbCH2.SelectedIndex == 1)
                SettingData40.ChannelRange |= 0x00000100;
            if (CmbCH2.SelectedIndex == 2)
                SettingData40.ChannelRange |= 0x00000200;
            if (CmbCH2.SelectedIndex == 3)
                SettingData40.ChannelRange |= 0x00000300;
            if (CmbCH2.SelectedIndex == 4)
                SettingData40.ChannelRange |= 0x00000B00;
            if (CmbCH2.SelectedIndex == 5)
                SettingData40.ChannelRange |= 0x00000500;
            if (CmbCH2.SelectedIndex == 6)
                SettingData40.ChannelRange |= 0x00000600;
            if (CmbCH2.SelectedIndex == 7)
                SettingData40.ChannelRange |= 0x00000700;
            if (CmbCH2.SelectedIndex == 8)
                SettingData40.ChannelRange |= 0x00000F00;
            // レンジ(CH3)
            if (CmbCH3.SelectedIndex == 0)
                SettingData40.ChannelRange |= 0x00000000;
            if (CmbCH3.SelectedIndex == 1)
                SettingData40.ChannelRange |= 0x00001000;
            if (CmbCH3.SelectedIndex == 2)
                SettingData40.ChannelRange |= 0x00002000;
            if (CmbCH3.SelectedIndex == 3)
                SettingData40.ChannelRange |= 0x00003000;
            if (CmbCH3.SelectedIndex == 4)
                SettingData40.ChannelRange |= 0x0000B000;
            if (CmbCH3.SelectedIndex == 5)
                SettingData40.ChannelRange |= 0x00005000;
            if (CmbCH3.SelectedIndex == 6)
                SettingData40.ChannelRange |= 0x00006000;
            if (CmbCH3.SelectedIndex == 7)
                SettingData40.ChannelRange |= 0x00007000;
            if (CmbCH3.SelectedIndex == 8)
                SettingData40.ChannelRange |= 0x0000F000;
            // レンジ(CH4)
            if (CmbCH4.SelectedIndex == 0)
                SettingData40.ChannelRange |= 0x00000000;
            if (CmbCH4.SelectedIndex == 1)
                SettingData40.ChannelRange |= 0x00010000;
            if (CmbCH4.SelectedIndex == 2)
                SettingData40.ChannelRange |= 0x00020000;
            if (CmbCH4.SelectedIndex == 3)
                SettingData40.ChannelRange |= 0x00030000;
            if (CmbCH4.SelectedIndex == 4)
                SettingData40.ChannelRange |= 0x000B0000;
            if (CmbCH4.SelectedIndex == 5)
                SettingData40.ChannelRange |= 0x00050000;
            if (CmbCH4.SelectedIndex == 6)
                SettingData40.ChannelRange |= 0x00060000;
            if (CmbCH4.SelectedIndex == 7)
                SettingData40.ChannelRange |= 0x00070000;
            if (CmbCH4.SelectedIndex == 8)
                SettingData40.ChannelRange |= 0x000F0000;
            // レンジ(CH5)
            if (CmbCH5.SelectedIndex == 0)
                SettingData40.ChannelRange |= 0x00000000;
            if (CmbCH5.SelectedIndex == 1)
                SettingData40.ChannelRange |= 0x00100000;
            if (CmbCH5.SelectedIndex == 2)
                SettingData40.ChannelRange |= 0x00200000;
            if (CmbCH5.SelectedIndex == 3)
                SettingData40.ChannelRange |= 0x00300000;
            if (CmbCH5.SelectedIndex == 4)
                SettingData40.ChannelRange |= 0x00B00000;
            if (CmbCH5.SelectedIndex == 5)
                SettingData40.ChannelRange |= 0x00500000;
            if (CmbCH5.SelectedIndex == 6)
                SettingData40.ChannelRange |= 0x00600000;
            if (CmbCH5.SelectedIndex == 7)
                SettingData40.ChannelRange |= 0x00700000;
            if (CmbCH5.SelectedIndex == 8)
                SettingData40.ChannelRange |= 0x00F00000;
            // レンジ(CH6)
            if (CmbCH6.SelectedIndex == 0)
                SettingData40.ChannelRange |= 0x00000000;
            if (CmbCH6.SelectedIndex == 1)
                SettingData40.ChannelRange |= 0x01000000;
            if (CmbCH6.SelectedIndex == 2)
                SettingData40.ChannelRange |= 0x02000000;
            if (CmbCH6.SelectedIndex == 3)
                SettingData40.ChannelRange |= 0x03000000;
            if (CmbCH6.SelectedIndex == 4)
                SettingData40.ChannelRange |= 0x0B000000;
            if (CmbCH6.SelectedIndex == 5)
                SettingData40.ChannelRange |= 0x05000000;
            if (CmbCH6.SelectedIndex == 6)
                SettingData40.ChannelRange |= 0x06000000;
            if (CmbCH6.SelectedIndex == 7)
                SettingData40.ChannelRange |= 0x07000000;
            if (CmbCH6.SelectedIndex == 8)
                SettingData40.ChannelRange |= 0x0F000000;
            // レンジ(CH7)
            if (CmbCH7.SelectedIndex == 0)
                SettingData40.ChannelRange |= 0x00000000;
            if (CmbCH7.SelectedIndex == 1)
                SettingData40.ChannelRange |= 0x10000000;
            if (CmbCH7.SelectedIndex == 2)
                SettingData40.ChannelRange |= 0x20000000;
            if (CmbCH7.SelectedIndex == 3)
                SettingData40.ChannelRange |= 0x30000000;
            if (CmbCH7.SelectedIndex == 4)
                SettingData40.ChannelRange |= 0xB0000000;
            if (CmbCH7.SelectedIndex == 5)
                SettingData40.ChannelRange |= 0x50000000;
            if (CmbCH7.SelectedIndex == 6)
                SettingData40.ChannelRange |= 0x60000000;
            if (CmbCH7.SelectedIndex == 7)
                SettingData40.ChannelRange |= 0x70000000;
            if (CmbCH7.SelectedIndex == 8)
                SettingData40.ChannelRange |= 0xF0000000;

            // 上限閾値
            SettingData40.ChUpperThreshold.Ushortcode_0 = GetwValue(0, double.Parse(TxtUpperCH0.Text));
            SettingData40.ChUpperThreshold.Ushortcode_1 = GetwValue(1, double.Parse(TxtUpperCH1.Text));
            SettingData40.ChUpperThreshold.Ushortcode_2 = GetwValue(2, double.Parse(TxtUpperCH2.Text));
            SettingData40.ChUpperThreshold.Ushortcode_3 = GetwValue(3, double.Parse(TxtUpperCH3.Text));
            SettingData40.ChUpperThreshold.Ushortcode_4 = GetwValue(4, double.Parse(TxtUpperCH4.Text));
            SettingData40.ChUpperThreshold.Ushortcode_5 = GetwValue(5, double.Parse(TxtUpperCH5.Text));
            SettingData40.ChUpperThreshold.Ushortcode_6 = GetwValue(6, double.Parse(TxtUpperCH6.Text));
            SettingData40.ChUpperThreshold.Ushortcode_7 = GetwValue(7, double.Parse(TxtUpperCH7.Text));

            // 下限閾値
            SettingData40.ChLowerThreshold.Ushortcode_0 = GetwValue(0, double.Parse(TxtLowerCH0.Text));
            SettingData40.ChLowerThreshold.Ushortcode_1 = GetwValue(1, double.Parse(TxtLowerCH1.Text));
            SettingData40.ChLowerThreshold.Ushortcode_2 = GetwValue(2, double.Parse(TxtLowerCH2.Text));
            SettingData40.ChLowerThreshold.Ushortcode_3 = GetwValue(3, double.Parse(TxtLowerCH3.Text));
            SettingData40.ChLowerThreshold.Ushortcode_4 = GetwValue(4, double.Parse(TxtLowerCH4.Text));
            SettingData40.ChLowerThreshold.Ushortcode_5 = GetwValue(5, double.Parse(TxtLowerCH5.Text));
            SettingData40.ChLowerThreshold.Ushortcode_6 = GetwValue(6, double.Parse(TxtLowerCH6.Text));
            SettingData40.ChLowerThreshold.Ushortcode_7 = GetwValue(7, double.Parse(TxtLowerCH7.Text));

            // 値を整えて表示( -10.24までなのに-30と設定しようとした場合-10.24と表示する )
            // 上限閾値
            TxtUpperCH0.Text = String.Format("{0:F2}", GetdbValue(0, SettingData40.ChUpperThreshold.Ushortcode_0));
            TxtUpperCH1.Text = String.Format("{0:F2}", GetdbValue(1, SettingData40.ChUpperThreshold.Ushortcode_1));
            TxtUpperCH2.Text = String.Format("{0:F2}", GetdbValue(2, SettingData40.ChUpperThreshold.Ushortcode_2));
            TxtUpperCH3.Text = String.Format("{0:F2}", GetdbValue(3, SettingData40.ChUpperThreshold.Ushortcode_3));
            TxtUpperCH4.Text = String.Format("{0:F2}", GetdbValue(4, SettingData40.ChUpperThreshold.Ushortcode_4));
            TxtUpperCH5.Text = String.Format("{0:F2}", GetdbValue(5, SettingData40.ChUpperThreshold.Ushortcode_5));
            TxtUpperCH6.Text = String.Format("{0:F2}", GetdbValue(6, SettingData40.ChUpperThreshold.Ushortcode_6));
            TxtUpperCH7.Text = String.Format("{0:F2}", GetdbValue(7, SettingData40.ChUpperThreshold.Ushortcode_7));
            // 下限閾値
            TxtLowerCH0.Text = String.Format("{0:F2}", GetdbValue(0, SettingData40.ChLowerThreshold.Ushortcode_0));
            TxtLowerCH1.Text = String.Format("{0:F2}", GetdbValue(1, SettingData40.ChLowerThreshold.Ushortcode_1));
            TxtLowerCH2.Text = String.Format("{0:F2}", GetdbValue(2, SettingData40.ChLowerThreshold.Ushortcode_2));
            TxtLowerCH3.Text = String.Format("{0:F2}", GetdbValue(3, SettingData40.ChLowerThreshold.Ushortcode_3));
            TxtLowerCH4.Text = String.Format("{0:F2}", GetdbValue(4, SettingData40.ChLowerThreshold.Ushortcode_4));
            TxtLowerCH5.Text = String.Format("{0:F2}", GetdbValue(5, SettingData40.ChLowerThreshold.Ushortcode_5));
            TxtLowerCH6.Text = String.Format("{0:F2}", GetdbValue(6, SettingData40.ChLowerThreshold.Ushortcode_6));
            TxtLowerCH7.Text = String.Format("{0:F2}", GetdbValue(7, SettingData40.ChLowerThreshold.Ushortcode_7));


            // 設定書込
            Status = RSSG2000.DLL.RPiGP40SetSetting(hCom, CmbMacAdrsBuf, SettingData40);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP40SetSetting エラー [{0:X}]", Status);
            }

            // 有効
            BtnGP40Stop.Enabled = true;
            BtnDIOHighOut.Enabled = true;
            BtnDIOLowOut.Enabled = true;
            BtnDIOIn.Enabled = true;
            BtnGetSetting.Enabled = true;
            BtnSetSetting.Enabled = true;
            BtnGetStart.Enabled = true;
            BtnGetStop.Enabled = true;
            BtnOneShot.Enabled = true;
            BtnGet.Enabled = true;
            BtnSetSetting.Focus();
        }

        unsafe private void BtnOneShot_Click(object sender, EventArgs e)
        {
            UInt32 Status;
            RSSG2000.DLL.RsUshortData GetChData;

            // 無効
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // 1回取得
            Status = RSSG2000.DLL.RPiGP40OneShot(hCom, CmbMacAdrsBuf, &GetChData);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP40OneShot エラー [{0:X}]", Status);
            }
            else
            {
                // データ
                TxtCH0.Text = String.Format("{0:F2}", GetdbValue(0, GetChData.Ushortcode_0));
                TxtCH1.Text = String.Format("{0:F2}", GetdbValue(1, GetChData.Ushortcode_1));
                TxtCH2.Text = String.Format("{0:F2}", GetdbValue(2, GetChData.Ushortcode_2));
                TxtCH3.Text = String.Format("{0:F2}", GetdbValue(3, GetChData.Ushortcode_3));
                TxtCH4.Text = String.Format("{0:F2}", GetdbValue(4, GetChData.Ushortcode_4));
                TxtCH5.Text = String.Format("{0:F2}", GetdbValue(5, GetChData.Ushortcode_5));
                TxtCH6.Text = String.Format("{0:F2}", GetdbValue(6, GetChData.Ushortcode_6));
                TxtCH7.Text = String.Format("{0:F2}", GetdbValue(7, GetChData.Ushortcode_7));
            }

            // 有効
            BtnGP40Stop.Enabled = true;
            BtnDIOHighOut.Enabled = true;
            BtnDIOLowOut.Enabled = true;
            BtnDIOIn.Enabled = true;
            BtnGetSetting.Enabled = true;
            BtnSetSetting.Enabled = true;
            BtnGetStart.Enabled = true;
            BtnGetStop.Enabled = true;
            BtnOneShot.Enabled = true;
            BtnGet.Enabled = true;
            BtnOneShot.Focus();
        }

        private void BtnGetStart_Click(object sender, EventArgs e)
        {
            UInt32 Status;

            // 無効
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // 連続取得開始(1分)
            Status = RSSG2000.DLL.RPiGP40TimerData(hCom, CmbMacAdrsBuf, 1, 1);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP40TimerData エラー [{0:X}]", Status);
            }

            // 有効
            BtnGP40Stop.Enabled = true;
            BtnDIOHighOut.Enabled = true;
            BtnDIOLowOut.Enabled = true;
            BtnDIOIn.Enabled = true;
            BtnGetSetting.Enabled = true;
            BtnSetSetting.Enabled = true;
            BtnGetStart.Enabled = true;
            BtnGetStop.Enabled = true;
            BtnOneShot.Enabled = true;
            BtnGet.Enabled = true;
            BtnGetStart.Focus();
        }

        private void BtnGetStop_Click(object sender, EventArgs e)
        {
            UInt32 Status;

            // 無効
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // 連続取得停止
            Status = RSSG2000.DLL.RPiGP40TimerData(hCom, CmbMacAdrsBuf, 0, 1);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP40TimerData エラー [{0:X}]", Status);
            }

            // 有効
            BtnGP40Stop.Enabled = true;
            BtnDIOHighOut.Enabled = true;
            BtnDIOLowOut.Enabled = true;
            BtnDIOIn.Enabled = true;
            BtnGetSetting.Enabled = true;
            BtnSetSetting.Enabled = true;
            BtnGetStart.Enabled = true;
            BtnGetStop.Enabled = true;
            BtnOneShot.Enabled = true;
            BtnGet.Enabled = true;
            BtnGetStop.Focus();
        }

        private void BtnDIOHighOut_Click(object sender, EventArgs e)
        {
            UInt32 Status;

            // 無効
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // 出力(DIO : High)オープンコレクタのため0x00
            Status = RSSG2000.DLL.RPiGP40OutPort(hCom, CmbMacAdrsBuf, 0x00);

            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP40OutPort エラー [{0:X}]", Status);
            }

            // 有効
            BtnGP40Stop.Enabled = true;
            BtnDIOHighOut.Enabled = true;
            BtnDIOLowOut.Enabled = true;
            BtnDIOIn.Enabled = true;
            BtnGetSetting.Enabled = true;
            BtnSetSetting.Enabled = true;
            BtnGetStart.Enabled = true;
            BtnGetStop.Enabled = true;
            BtnOneShot.Enabled = true;
            BtnGet.Enabled = true;
            BtnDIOHighOut.Focus();
        }

        private void BtnDIOLowOut_Click(object sender, EventArgs e)
        {
            UInt32 Status;

            // 無効
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // 出力(DIO : Low)オープンコレクタのため0x01
            Status = RSSG2000.DLL.RPiGP40OutPort(hCom, CmbMacAdrsBuf, 0x01);

            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP40OutPort エラー [{0:X}]", Status);
            }

            // 有効
            BtnGP40Stop.Enabled = true;
            BtnDIOHighOut.Enabled = true;
            BtnDIOLowOut.Enabled = true;
            BtnDIOIn.Enabled = true;
            BtnGetSetting.Enabled = true;
            BtnSetSetting.Enabled = true;
            BtnGetStart.Enabled = true;
            BtnGetStop.Enabled = true;
            BtnOneShot.Enabled = true;
            BtnGet.Enabled = true;
            BtnDIOLowOut.Focus();
        }

        unsafe private void BtnDIOIn_Click(object sender, EventArgs e)
        {
            UInt32 Status;
            byte bInData;

            // 無効
            BtnGP40Stop.Enabled = false;
            BtnDIOHighOut.Enabled = false;
            BtnDIOLowOut.Enabled = false;
            BtnDIOIn.Enabled = false;
            BtnGetSetting.Enabled = false;
            BtnSetSetting.Enabled = false;
            BtnGetStart.Enabled = false;
            BtnGetStop.Enabled = false;
            BtnOneShot.Enabled = false;
            BtnGet.Enabled = false;

            // 入力
            Status = RSSG2000.DLL.RPiGP40InPort(hCom, CmbMacAdrsBuf, &bInData);
            if (Status != 0)
            {
                TxtMsg.Text = String.Format("RPiGP40InPort エラー [{0:X}]", Status);
            }
            else
            {
                // Low
                if (bInData == 0x00)
                {
                    TxtDIOIn.Text = "Low";
                }
                // High
                else
                {
                    TxtDIOIn.Text = "High";
                }
            }

            // 有効
            BtnGP40Stop.Enabled = true;
            BtnDIOHighOut.Enabled = true;
            BtnDIOLowOut.Enabled = true;
            BtnDIOIn.Enabled = true;
            BtnGetSetting.Enabled = true;
            BtnSetSetting.Enabled = true;
            BtnGetStart.Enabled = true;
            BtnGetStop.Enabled = true;
            BtnOneShot.Enabled = true;
            BtnGet.Enabled = true;
            BtnDIOIn.Focus();
        }

        private void BtnExit_Click(object sender, EventArgs e)
        {
            byte iii;

            TxtMsg.Text = "停止中...";
            Application.DoEvents();

            if (fStart)
            {
                // 停止
                RSSG2000.DLL.RSSG2000Stop(hCom);

                for (iii = 0; iii < 16 * 8; iii += 8)
                {
                    if ((MacAdrs[iii + 0] == 0x00) && (MacAdrs[iii + 1] == 0x00) && (MacAdrs[iii + 2] == 0x00) && (MacAdrs[iii + 3] == 0x00) && (MacAdrs[iii + 4] == 0x00) && (MacAdrs[iii + 5] == 0x00) && (MacAdrs[iii + 6] == 0x00) && (MacAdrs[iii + 7] == 0x00))
                    {
                        ;
                    }
                    else
                    {
                        CmbMacAdrsBuf[0] = MacAdrs[iii + 0];
                        CmbMacAdrsBuf[1] = MacAdrs[iii + 1];
                        CmbMacAdrsBuf[2] = MacAdrs[iii + 2];
                        CmbMacAdrsBuf[3] = MacAdrs[iii + 3];
                        CmbMacAdrsBuf[4] = MacAdrs[iii + 4];
                        CmbMacAdrsBuf[5] = MacAdrs[iii + 5];
                        CmbMacAdrsBuf[6] = MacAdrs[iii + 6];
                        CmbMacAdrsBuf[7] = MacAdrs[iii + 7];

                        // 削除
                        RSSG2000.DLL.RSSG2000DeleteMacAdrs(hCom, CmbMacAdrsBuf);
                    }
                }

                // クローズ
                RSSG2000.DLL.RSSG2000Close(hCom);
                hCom = 0xFFFFFFFF;
            }
            
            this.Close();
        }

        unsafe private void CmbMacAdrs_SelectedIndexChanged(object sender, EventArgs e)
        {
            string strMacAdrs;
            byte[] Version = new byte[8];
            SByte RSSI;
            double Temp, Humidity;

            // コンボボックスから取得
            strMacAdrs = CmbMacAdrs.GetItemText(CmbMacAdrs.SelectedItem);

            CmbMacAdrsBuf[0] = byte.Parse(strMacAdrs.Substring(0, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[1] = byte.Parse(strMacAdrs.Substring(3, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[2] = byte.Parse(strMacAdrs.Substring(6, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[3] = byte.Parse(strMacAdrs.Substring(9, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[4] = byte.Parse(strMacAdrs.Substring(12, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[5] = byte.Parse(strMacAdrs.Substring(15, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[6] = byte.Parse(strMacAdrs.Substring(18, 2), System.Globalization.NumberStyles.HexNumber);
            CmbMacAdrsBuf[7] = byte.Parse(strMacAdrs.Substring(21, 2), System.Globalization.NumberStyles.HexNumber);

            if (fStart)
            {
                // バージョン取得
                RSSG2000.DLL.RSSG2000GetVersion(hCom, CmbMacAdrsBuf, Version);
                TxtVersion.Text = String.Format("{0:x}.{1:X2}", Version[0], Version[1]);
                // RSSI 取得
                RSSG2000.DLL.RSSG2000GetRSSI(hCom, CmbMacAdrsBuf, &RSSI);
                TxtRSSI.Text = String.Format("{0:D}", RSSI);
                // 温湿度取得
                RSSG2000.DLL.RSSG2000GetTemp(hCom, CmbMacAdrsBuf, &Temp, &Humidity);
                TxtTemp.Text = String.Format("{0:F1}", Temp);
                TxtHumidity.Text = String.Format("{0:F1}", Humidity);
            }

            // 開始フラグ
            if (fGP40Start[CmbMacAdrs.SelectedIndex])
            {
                // 無効
                BtnGP40Start.Enabled = false;
                // 有効
                BtnGP40Stop.Enabled = true;
                BtnDIOHighOut.Enabled = true;
                BtnDIOLowOut.Enabled = true;
                BtnDIOIn.Enabled = true;
                BtnGetSetting.Enabled = true;
                BtnSetSetting.Enabled = true;
                BtnGetStart.Enabled = true;
                BtnGetStop.Enabled = true;
                BtnOneShot.Enabled = true;
            }
            else
            {
                if (fStart)
                {
                    // 有効
                    BtnGP40Start.Enabled = true;
                    // 無効
                    BtnGP40Stop.Enabled = false;
                    BtnDIOHighOut.Enabled = false;
                    BtnDIOLowOut.Enabled = false;
                    BtnDIOIn.Enabled = false;
                    BtnGetSetting.Enabled = false;
                    BtnSetSetting.Enabled = false;
                    BtnGetStart.Enabled = false;
                    BtnGetStop.Enabled = false;
                    BtnOneShot.Enabled = false;
                }
            }
        }

        private double GetdbValue( Byte CHNo, UInt16 wData)
        {
            double dbData;
            Byte Range;
            double dbRes;

            // レンジ
            Range = 0;
            switch (CHNo)
            {
                case 0: Range = (Byte)CmbCH0.SelectedIndex; break;
                case 1: Range = (Byte)CmbCH1.SelectedIndex; break;
                case 2: Range = (Byte)CmbCH2.SelectedIndex; break;
                case 3: Range = (Byte)CmbCH3.SelectedIndex; break;
                case 4: Range = (Byte)CmbCH4.SelectedIndex; break;
                case 5: Range = (Byte)CmbCH5.SelectedIndex; break;
                case 6: Range = (Byte)CmbCH6.SelectedIndex; break;
                case 7: Range = (Byte)CmbCH7.SelectedIndex; break;
            }

            dbRes = 1.0;
            // 	{"±10.24V", "±5.12V", "±2.56V", "±1.28V", "±0.64V", "0～10.24V", "0～5.12V", "0～2.56V", "0～1.28V"};
            switch (Range)
            {
                case 0: dbRes = 20.48 / 4095.0; break;
                case 1: dbRes = 10.24 / 4095.0; break;
                case 2: dbRes = 5.12 / 4095.0; break;
                case 3: dbRes = 2.56 / 4095.0; break;
                case 4: dbRes = 1.28 / 4095.0; break;
                case 5: dbRes = 10.24 / 4095.0; break;
                case 6: dbRes = 5.12 / 4095.0; break;
                case 7: dbRes = 2.56 / 4095.0; break;
                case 8: dbRes = 1.28 / 4095.0; break;
            }

            dbData = 0.0;
            switch (Range)
            {
                case 0: dbData = -10.24 + dbRes * wData; break;
                case 1: dbData = -5.12 + dbRes * wData; break;
                case 2: dbData = -2.56 + dbRes * wData; break;
                case 3: dbData = -1.28 + dbRes * wData; break;
                case 4: dbData = -0.64 + dbRes * wData; break;
                case 5: dbData = dbRes * wData; break;
                case 6: dbData = dbRes * wData; break;
                case 7: dbData = dbRes * wData; break;
                case 8: dbData = dbRes * wData; break;
            }

            return dbData;
        }

        private UInt16 GetwValue(Byte CHNo, double dbData)
        {
            UInt16 wData;
            Byte Range;
            double dbRes;

            // レンジ
            Range = 0;
            switch (CHNo)
            {
                case 0: Range = (Byte)CmbCH0.SelectedIndex; break;
                case 1: Range = (Byte)CmbCH1.SelectedIndex; break;
                case 2: Range = (Byte)CmbCH2.SelectedIndex; break;
                case 3: Range = (Byte)CmbCH3.SelectedIndex; break;
                case 4: Range = (Byte)CmbCH4.SelectedIndex; break;
                case 5: Range = (Byte)CmbCH5.SelectedIndex; break;
                case 6: Range = (Byte)CmbCH6.SelectedIndex; break;
                case 7: Range = (Byte)CmbCH7.SelectedIndex; break;
            }

            dbRes = 1.0;
            // 	{"±10.24V", "±5.12V", "±2.56V", "±1.28V", "±0.64V", "0～10.24V", "0～5.12V", "0～2.56V", "0～1.28V"};
            switch (Range)
            {
                case 0: dbRes = 20.48 / 4095.0; break;
                case 1: dbRes = 10.24 / 4095.0; break;
                case 2: dbRes = 5.12 / 4095.0; break;
                case 3: dbRes = 2.56 / 4095.0; break;
                case 4: dbRes = 1.28 / 4095.0; break;
                case 5: dbRes = 10.24 / 4095.0; break;
                case 6: dbRes = 5.12 / 4095.0; break;
                case 7: dbRes = 2.56 / 4095.0; break;
                case 8: dbRes = 1.28 / 4095.0; break;
            }

            wData = 0;
            switch (Range)
            {
                case 0: 
                    if (dbData >= 10.24)
                        wData = 4095;
                    else if (dbData <= -10.24)
                        wData = 0;
                    else
                        wData = (UInt16)((dbData + 10.24) / dbRes);
                    break;
                case 1: 
                    if (dbData >= 5.12)
                        wData = 4095;
                    else if (dbData <= -5.12)
                        wData = 0;
                    else 
                        wData = (UInt16)((dbData + 5.12) / dbRes); 
                    break;
                case 2: 
                    if (dbData >= 2.56)
                        wData = 4095;
                    else if (dbData <= -2.56)
                        wData = 0;
                    else 
                        wData = (UInt16)((dbData + 2.56) / dbRes); 
                    break;
                case 3: 
                    if (dbData >= 1.28)
                        wData = 4095;
                    else if (dbData <= -1.28)
                        wData = 0;
                    else
                        wData = (UInt16)((dbData + 1.28) / dbRes); 
                    break;
                case 4: 
                    if (dbData >= 0.64)
                        wData = 4095;
                    else if (dbData <= -0.64)
                        wData = 0;
                    else 
                        wData = (UInt16)((dbData + 0.64) / dbRes); 
                    break;
                case 5: 
                    if (dbData >= 10.24)
                        wData = 4095;
                    else if (dbData <= 0)
                        wData = 0;
                    else 
                        wData = (UInt16)(dbData / dbRes); 
                    break;
                case 6: 
                    if (dbData >= 5.12)
                        wData = 4095;
                    else if (dbData <= 0)
                        wData = 0;
                    else
                        wData = (UInt16)(dbData / dbRes); 
                    break;
                case 7: 
                    if (dbData >= 2.56)
                        wData = 4095;
                    else if (dbData <= 0)
                        wData = 0;
                    else 
                        wData = (UInt16)(dbData / dbRes); 
                    break;
                case 8: 
                    if (dbData >= 1.28)
                        wData = 4095;
                    else if (dbData <= 0)
                        wData = 0;
                    else 
                        wData = (UInt16)(dbData / dbRes); 
                    break;
            }

            return wData;
        }
    }
}
