Public Class RSSG2040
    Public hCom As UInt32
    Public MacAdrs(17 * 8) As Byte
    Public CmbMacAdrsBuf(8) As Byte
    Public CallBackCount As UShort
    Public fStart As Boolean
    Public fGP40Start(17) As Boolean

    Private ChkDevice() As System.Windows.Forms.CheckBox

    Private ErrorFunc As New ErrorCallback(AddressOf CallBackErrorFunc)
    Private TimerDataFunc As New TimerDataCallback(AddressOf CallBackTimerDataFunc)
    Private AlarmFunc As New AlarmCallback(AddressOf CallBackAlarmFunc)
    Private RegistFunc As New RegistCallback(AddressOf CallBackRegistFunc)

    ' イベントコールバック
    Private Sub CallBackErrorFunc(ByRef pData As Byte)
        Dim strData As String
        Dim Length As UInt32
        Dim pBuf As Byte()

        ' エラーデータ取得
        ReDim pBuf(16)
        Length = RSSG2000GetErrorData(pBuf)

        strData = String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackErrorFunc[{8:X2}]", pBuf(0), pBuf(1), pBuf(2), pBuf(3), pBuf(4), pBuf(5), pBuf(6), pBuf(7), pBuf(8))
        TxtMsg.Text = strData
    End Sub
    Private Sub CallBackTimerDataFunc(ByRef pData As Byte)
        Dim strData As String
        Dim Length As UInt32
        Dim pBuf As Byte()

        ' エラーデータ取得
        ReDim pBuf(32)
        Length = RSSG2000GetTimerData(pBuf)

        strData = String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackTimerDataFunc", pBuf(0), pBuf(1), pBuf(2), pBuf(3), pBuf(4), pBuf(5), pBuf(6), pBuf(7)) + vbCrLf + String.Format("[{0:F2}][{1:F2}][{2:F2}][{3:F2}][{4:F2}][{5:F2}][{6:F2}][{7:F2}]", GetdbValue(0, (pBuf(8) * 256 + pBuf(9))), GetdbValue(1, (pBuf(10) * 256 + pBuf(11))), GetdbValue(2, (pBuf(12) * 256 + pBuf(13))), GetdbValue(3, (pBuf(14) * 256 + pBuf(15))), GetdbValue(4, (pBuf(16) * 256 + pBuf(17))), GetdbValue(5, (pBuf(18) * 256 + pBuf(19))), GetdbValue(6, (pBuf(20) * 256 + pBuf(21))), GetdbValue(7, (pBuf(22) * 256 + pBuf(23))))
        TxtMsg.Text = strData
    End Sub
    Private Sub CallBackAlarmFunc(ByRef pData As Byte)
        Dim strData As String
        Dim Length As UInt32
        Dim pBuf As Byte()
        Dim CurrentTime As DateTime
        Dim FileName As String
        Dim hWrite As System.IO.Stream
        Dim CsvBuf As Byte()
        Dim iii As UShort

        ReDim CsvBuf(64)
        ' アラームデータ取得
        ReDim pBuf(816)
        Length = RSSG2000GetAlarmData(pBuf)

        strData = String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackAlarmFunc", pBuf(0), pBuf(1), pBuf(2), pBuf(3), pBuf(4), pBuf(5), pBuf(6), pBuf(7))
        TxtMsg.Text = strData


        CurrentTime = DateTime.Now
        FileName = String.Format("{0:d}{1:d2}{2:d2}_{3:d2}{4:d2}{5:d2}.csv", CurrentTime.Year, CurrentTime.Month, CurrentTime.Day, CurrentTime.Hour, CurrentTime.Minute, CurrentTime.Second)


        '選択可能ﾌｧｲﾙ
        SaveFileDialog.Filter = "Dat files{*.dat}|*.csv"
        'ｶﾚﾝﾄﾃﾞｨﾚｸﾄﾘ名を取得する
        SaveFileDialog.InitialDirectory = Application.ExecutablePath
        ' ｶﾚﾝﾄﾌｧｲﾙ名
        SaveFileDialog.FileName = FileName

        ' ﾌｧｲﾙを開く
        hWrite = SaveFileDialog.OpenFile()
        ' ﾌｧｲﾙ保存
        'hWrite.Write(pBuf, 0, 816)
        ' MACアドレス/トリガーチャンネル(bit表示)/件数
        strData = String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}],0x{8:X2},{9:D}" + vbCrLf, pBuf(0), pBuf(1), pBuf(2), pBuf(3), pBuf(4), pBuf(5), pBuf(6), pBuf(7), pBuf(9), pBuf(10))
        CsvBuf = System.Text.Encoding.ASCII.GetBytes(strData)
        hWrite.Write(CsvBuf, 0, strData.Length)
        ' ヘッダ
        strData = String.Format("CH0,CH1,CH2,CH3,CH4,CH5,CH6,CH7" + vbCrLf)
        CsvBuf = System.Text.Encoding.ASCII.GetBytes(strData)
        hWrite.Write(CsvBuf, 0, strData.Length)
        ' データ
        For iii = 0 To 800 - 1 Step 16
            strData = String.Format("{0:F2},{1:F2},{2:F2},{3:F2},{4:F2},{5:F2},{6:F2},{7:F2}" + vbCrLf, GetdbValue(0, (pBuf(16 + iii + 0) * 256 + pBuf(16 + iii + 1))), GetdbValue(1, (pBuf(16 + iii + 2) * 256 + pBuf(16 + iii + 3))), GetdbValue(2, (pBuf(16 + iii + 4) * 256 + pBuf(16 + iii + 5))), GetdbValue(3, (pBuf(16 + iii + 6) * 256 + pBuf(16 + iii + 7))), GetdbValue(4, (pBuf(16 + iii + 8) * 256 + pBuf(16 + iii + 9))), GetdbValue(5, (pBuf(16 + iii + 10) * 256 + pBuf(16 + iii + 11))), GetdbValue(6, (pBuf(16 + iii + 12) * 256 + pBuf(16 + iii + 13))), GetdbValue(7, (pBuf(16 + iii + 14) * 256 + pBuf(16 + iii + 15))))
            CsvBuf = System.Text.Encoding.ASCII.GetBytes(strData)
            hWrite.Write(CsvBuf, 0, strData.Length)
        Next iii

        ' ﾌｧｲﾙを閉じる
        hWrite.Close()

    End Sub
    Private Sub CallBackRegistFunc(ByRef pData As Byte)
        Dim strData As String
        Dim Length As UInt32
        Dim pBuf As Byte()
        Dim MacAdrsBuf(8) As Byte

        ' エラーデータ取得
        ReDim pBuf(16)
        Length = RSSG2000GetRegistData(pBuf)

        strData = String.Format("[{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}] CallBackRegistFunc", pBuf(0), pBuf(1), pBuf(2), pBuf(3), pBuf(4), pBuf(5), pBuf(6), pBuf(7))
        TxtMsg.Text = strData

        ' MACアドレス
        MacAdrsBuf(0) = pBuf(0)
        MacAdrsBuf(1) = pBuf(1)
        MacAdrsBuf(2) = pBuf(2)
        MacAdrsBuf(3) = pBuf(3)
        MacAdrsBuf(4) = pBuf(4)
        MacAdrsBuf(5) = pBuf(5)
        MacAdrsBuf(6) = pBuf(6)
        MacAdrsBuf(7) = pBuf(7)
        ' 登録
        RSSG2000RegistMacAdrs(hCom, MacAdrsBuf(0))
        ' コンボボックス追加
        CmbMacAdrs.Items.Add(String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}", MacAdrsBuf(0), MacAdrsBuf(1), MacAdrsBuf(2), MacAdrsBuf(3), MacAdrsBuf(4), MacAdrsBuf(5), MacAdrsBuf(6), MacAdrsBuf(7)))
        CmbMacAdrs.SelectedIndex = 0
    End Sub

    Private Sub RSSG2040_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim iii As Byte
        'Dim RangeBuf() As String = {"±10.24V", "±5.12V", "±2.56V", "±1.28V", "±0.64V", "0～10.24V", "0～5.12V", "0～2.56V", "0～1.28V"}
        Dim RangeBuf() As String = {"±10V", "±5V", "±2.5V", "±1V", "±0.5V", "0～10V", "0～5V", "0～2.5V", "0～1V"}

        CallBackCount = 0
        ' COMポート番号
        TxtCOM.Text = 16
        ' チャンネル
        TxtChannel.Text = 4
        ' 検索台数
        TxtSG20Count.Text = 1
        ' 開始フラグ
        For iii = 0 To 16
            fGP40Start(iii) = False
        Next
        fStart = False


        ' 無効
        BtnStop.Enabled = False
        BtnGP40Start.Enabled = False
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' サンプリング設定
        ChkCH0.Checked = True
        ChkCH1.Checked = True
        ChkCH2.Checked = True
        ChkCH3.Checked = True
        ChkCH4.Checked = True
        ChkCH5.Checked = True
        ChkCH6.Checked = True
        ChkCH7.Checked = True

        ' Range設定
        For iii = 0 To 8
            CmbCH0.Items.Add(RangeBuf(iii))
            CmbCH1.Items.Add(RangeBuf(iii))
            CmbCH2.Items.Add(RangeBuf(iii))
            CmbCH3.Items.Add(RangeBuf(iii))
            CmbCH4.Items.Add(RangeBuf(iii))
            CmbCH5.Items.Add(RangeBuf(iii))
            CmbCH6.Items.Add(RangeBuf(iii))
            CmbCH7.Items.Add(RangeBuf(iii))
        Next
        CmbCH0.SelectedIndex = 0
        CmbCH1.SelectedIndex = 0
        CmbCH2.SelectedIndex = 0
        CmbCH3.SelectedIndex = 0
        CmbCH4.SelectedIndex = 0
        CmbCH5.SelectedIndex = 0
        CmbCH6.SelectedIndex = 0
        CmbCH7.SelectedIndex = 0

        ' 閾値設定
        TxtLowerCH0.Text = "-10.24"
        TxtLowerCH1.Text = "-10.24"
        TxtLowerCH2.Text = "-10.24"
        TxtLowerCH3.Text = "-10.24"
        TxtLowerCH4.Text = "-10.24"
        TxtLowerCH5.Text = "-10.24"
        TxtLowerCH6.Text = "-10.24"
        TxtLowerCH7.Text = "-10.24"
        TxtUpperCH0.Text = "10.24"
        TxtUpperCH1.Text = "10.24"
        TxtUpperCH2.Text = "10.24"
        TxtUpperCH3.Text = "10.24"
        TxtUpperCH4.Text = "10.24"
        TxtUpperCH5.Text = "10.24"
        TxtUpperCH6.Text = "10.24"
        TxtUpperCH7.Text = "10.24"
        ' サンプリング間隔
        TxtSampling.Text = "100"
        ' トリガポイント
        TxtTrigger.Text = "25"

    End Sub

    Private Sub BtnClear_Click(sender As System.Object, e As System.EventArgs) Handles BtnClear.Click
        ' メッセージ削除
        TxtMsg.Text = ""
        BtnClear.Focus()
    End Sub

    Private Sub BtnStart_Click(sender As System.Object, e As System.EventArgs) Handles BtnStart.Click
        Dim iii As Byte
        Dim Version(8) As Byte
        Dim RSSI As SByte
        Dim Temp As Double
        Dim Humidity As Double
        Dim Count As Byte

        If (TxtCOM.Text.Length = 0) Then
            MessageBox.Show("1-255のCOMポート番号を指定してください")
            Exit Sub
        End If
        If ((Int32.Parse(TxtCOM.Text) < 1) Or (Int32.Parse(TxtCOM.Text) > 255)) Then
            MessageBox.Show("1-255のCOMポート番号を指定してください")
            Exit Sub
        End If
        If (TxtChannel.Text.Length = 0) Then
            MessageBox.Show("4-17のチャンネルを指定してください")
            Exit Sub
        End If
        If ((Int32.Parse(TxtChannel.Text) < 4) Or (Int32.Parse(TxtChannel.Text) > 17)) Then
            MessageBox.Show("4-17のチャンネルを指定してください")
            Exit Sub
        End If
        If (TxtSG20Count.Text.Length = 0) Then
            MessageBox.Show("1-17の台数を指定してください")
            Exit Sub
        End If
        If ((Int32.Parse(TxtSG20Count.Text) < 1) Or (Int32.Parse(TxtSG20Count.Text) > 17)) Then
            MessageBox.Show("1-17の台数を指定してください")
            Exit Sub
        End If

        Count = 0
        TxtMsg.Text = "開始中..."
        Application.DoEvents()
        ' オープン
        hCom = RSSG2000Open(Byte.Parse(TxtCOM.Text), Byte.Parse(TxtChannel.Text), Byte.Parse(TxtSG20Count.Text), RegistFunc)
        If hCom <> &HFFFFFFFFL Then
            Array.Clear(MacAdrs, 0, MacAdrs.Length)
            ' アドレス取得
            RSSG2000GetMacAdrs(hCom, MacAdrs(0))
            ' 表示
            For iii = 0 To 16 * 8 - 1 Step 8
                If ((MacAdrs(iii + 0) = &H0) And (MacAdrs(iii + 1) = &H0) And (MacAdrs(iii + 2) = &H0) And (MacAdrs(iii + 3) = &H0) And (MacAdrs(iii + 4) = &H0) And (MacAdrs(iii + 5) = &H0) And (MacAdrs(iii + 6) = &H0) And (MacAdrs(iii + 7) = &H0)) Then

                Else
                    CmbMacAdrsBuf(0) = MacAdrs(iii + 0)
                    CmbMacAdrsBuf(1) = MacAdrs(iii + 1)
                    CmbMacAdrsBuf(2) = MacAdrs(iii + 2)
                    CmbMacAdrsBuf(3) = MacAdrs(iii + 3)
                    CmbMacAdrsBuf(4) = MacAdrs(iii + 4)
                    CmbMacAdrsBuf(5) = MacAdrs(iii + 5)
                    CmbMacAdrsBuf(6) = MacAdrs(iii + 6)
                    CmbMacAdrsBuf(7) = MacAdrs(iii + 7)

                    ' 登録
                    RSSG2000RegistMacAdrs(hCom, CmbMacAdrsBuf(0))
                    ' 無効
                    BtnStart.Enabled = False
                    ' 有効
                    BtnStop.Enabled = True

                    ' コンボボックス追加
                    CmbMacAdrs.Items.Add(String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}:{6:X2}:{7:X2}", MacAdrs(iii + 0), MacAdrs(iii + 1), MacAdrs(iii + 2), MacAdrs(iii + 3), MacAdrs(iii + 4), MacAdrs(iii + 5), MacAdrs(iii + 6), MacAdrs(iii + 7)))
                    Count = Count + 1
                End If

            Next
            If Count <> 0 Then

                CmbMacAdrs.SelectedIndex = 0

                ' 開始
                RSSG2000Start(hCom)

                System.Threading.Thread.Sleep(500)
                ' バージョン取得
                RSSG2000GetVersion(hCom, CmbMacAdrsBuf(0), Version(0))
                TxtVersion.Text = String.Format("{0:X}.{1:X2}", Version(0), Version(1))
                ' RSSI取得
                RSSG2000GetRSSI(hCom, CmbMacAdrsBuf(0), RSSI)
                TxtRSSI.Text = String.Format("{0:D}", RSSI)
                ' 温湿度取得
                RSSG2000GetTemp(hCom, CmbMacAdrsBuf(0), Temp, Humidity)
                TxtTemp.Text = String.Format("{0:F1}", Temp)
                TxtHumidity.Text = String.Format("{0:F1}", Humidity)

                ' 有効
                BtnGP40Start.Enabled = True
                BtnGet.Enabled = True

                ' 読み取り専用
                TxtCOM.ReadOnly = True
                TxtChannel.ReadOnly = True
                TxtSG20Count.ReadOnly = True

                fStart = True
                If Count < Byte.Parse(TxtSG20Count.Text) Then
                    MessageBox.Show("指定台数のSubGiga入出力ベースボードが見つかりません")
                End If
            Else
                ' クローズ
                RSSG2000Close(hCom)
                hCom = &HFFFFFFFFL
                MessageBox.Show("SubGiga入出力ベースボードが見つかりません")
            End If
        Else
            MessageBox.Show("COMオープンエラー")
        End If
        TxtMsg.Text = ""
        BtnStart.Focus()
    End Sub



    Private Sub BtnStop_Click(sender As System.Object, e As System.EventArgs) Handles BtnStop.Click
        Dim iii As Byte

        TxtMsg.Text = "停止中..."
        Application.DoEvents()

        If fStart = True Then
            ' 停止
            RSSG2000Stop(hCom)

            For iii = 0 To 16 * 8 - 1 Step 8
                If ((MacAdrs(iii + 0) = &H0) And (MacAdrs(iii + 1) = &H0) And (MacAdrs(iii + 2) = &H0) And (MacAdrs(iii + 3) = &H0) And (MacAdrs(iii + 4) = &H0) And (MacAdrs(iii + 5) = &H0) And (MacAdrs(iii + 6) = &H0) And (MacAdrs(iii + 7) = &H0)) Then

                Else
                    CmbMacAdrsBuf(0) = MacAdrs(iii + 0)
                    CmbMacAdrsBuf(1) = MacAdrs(iii + 1)
                    CmbMacAdrsBuf(2) = MacAdrs(iii + 2)
                    CmbMacAdrsBuf(3) = MacAdrs(iii + 3)
                    CmbMacAdrsBuf(4) = MacAdrs(iii + 4)
                    CmbMacAdrsBuf(5) = MacAdrs(iii + 5)
                    CmbMacAdrsBuf(6) = MacAdrs(iii + 6)
                    CmbMacAdrsBuf(7) = MacAdrs(iii + 7)

                    ' 削除
                    RSSG2000DeleteMacAdrs(hCom, CmbMacAdrsBuf(0))
                End If
            Next iii

            ' クローズ
            RSSG2000Close(hCom)
            hCom = &HFFFFFFFFL
        End If

        ' 開始フラグ
        For iii = 0 To 16
            fGP40Start(iii) = False
        Next
        fStart = False

        ' 有効
        BtnStart.Enabled = True
        ' 無効
        BtnStop.Enabled = False
        BtnGP40Start.Enabled = False
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' コンボボックス削除
        CmbMacAdrs.Items.Clear()
        TxtMsg.Text = ""
        TxtVersion.Text = ""
        TxtRSSI.Text = ""
        TxtTemp.Text = ""
        TxtHumidity.Text = ""

        ' 読み取り専用解除
        TxtCOM.ReadOnly = False
        TxtChannel.ReadOnly = False
        TxtSG20Count.ReadOnly = False
        BtnStop.Focus()
    End Sub

    Private Sub BtnGP40Start_Click(sender As System.Object, e As System.EventArgs) Handles BtnGP40Start.Click
        Dim Status As UInt32

        TxtMsg.Text = "開始中..."
        Application.DoEvents()
        ' オープン
        Status = RPiGP40Open(hCom, CmbMacAdrsBuf(0), TimerDataFunc, AlarmFunc, ErrorFunc)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP40Open エラー [{0:X}]", Status)
            Exit Sub
        End If

        ' 無効
        BtnGP40Start.Enabled = False
        ' 有効
        BtnGP40Stop.Enabled = True
        BtnDIOHighOut.Enabled = True
        BtnDIOLowOut.Enabled = True
        BtnDIOIn.Enabled = True
        BtnGetSetting.Enabled = True
        BtnSetSetting.Enabled = True
        BtnGetStart.Enabled = True
        BtnGetStop.Enabled = True
        BtnOneShot.Enabled = True
        BtnGet.Enabled = True
        TxtMsg.Text = ""

        ' 開始フラグ
        fGP40Start(CmbMacAdrs.SelectedIndex) = True
        BtnGP40Start.Focus()
    End Sub

    Private Sub BtnGP40Stop_Click(sender As System.Object, e As System.EventArgs) Handles BtnGP40Stop.Click

        TxtMsg.Text = "停止中..."
        Application.DoEvents()

        ' 開始フラグ
        fGP40Start(CmbMacAdrs.SelectedIndex) = False
        ' GP40クローズ
        RPiGP40Close(hCom, CmbMacAdrsBuf(0))
        TxtMsg.Text = ""

        ' 有効
        BtnGP40Start.Enabled = True
        ' 無効
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGP40Stop.Focus()
    End Sub

    Private Sub BtnGet_Click(sender As System.Object, e As System.EventArgs) Handles BtnGet.Click
        Dim Status As UInt32
        Dim Version(8) As Byte
        Dim RSSI As SByte
        Dim Temp As Double
        Dim Humidity As Double

        ' 無効
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' バージョン取得
        Status = RSSG2000GetVersion(hCom, CmbMacAdrsBuf(0), Version(0))
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RSSG2000GetVersion エラー : {0:X}", Status)
        Else
            TxtVersion.Text = String.Format("{0:X}.{1:X2}", Version(0), Version(1))
        End If

        ' RSSI取得
        Status = RSSG2000GetRSSI(hCom, CmbMacAdrsBuf(0), RSSI)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RSSG2000GetRSSI エラー : {0:X}", Status)
        Else
            TxtRSSI.Text = String.Format("{0:D}", RSSI)
        End If

        ' 温湿度取得
        Status = RSSG2000GetTemp(hCom, CmbMacAdrsBuf(0), Temp, Humidity)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RSSG2000GetTemp エラー : {0:X}", Status)
        Else
            TxtTemp.Text = String.Format("{0:F1}", Temp)
            TxtHumidity.Text = String.Format("{0:F1}", Humidity)
        End If

        ' 開始フラグ
        If fGP40Start(CmbMacAdrs.SelectedIndex) = True Then
            ' 無効
            BtnGP40Start.Enabled = False
            ' 有効
            BtnGP40Stop.Enabled = True
            BtnDIOHighOut.Enabled = True
            BtnDIOLowOut.Enabled = True
            BtnDIOIn.Enabled = True
            BtnGetSetting.Enabled = True
            BtnSetSetting.Enabled = True
            BtnGetStart.Enabled = True
            BtnGetStop.Enabled = True
            BtnOneShot.Enabled = True
        Else
            ' 有効
            BtnGP40Start.Enabled = True
            ' 無効
            BtnGP40Stop.Enabled = False
            BtnDIOHighOut.Enabled = False
            BtnDIOLowOut.Enabled = False
            BtnDIOIn.Enabled = False
            BtnGetSetting.Enabled = False
            BtnSetSetting.Enabled = False
            BtnGetStart.Enabled = False
            BtnGetStop.Enabled = False
            BtnOneShot.Enabled = False
        End If
        BtnGet.Enabled = True
        BtnGet.Focus()
    End Sub

    Private Sub BtnGetSetting_Click(sender As System.Object, e As System.EventArgs) Handles BtnGetSetting.Click
        Dim Status As UInt32
        Dim GettingData40 As GP40Setting

        ' 無効
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' 設定読込
        Status = RPiGP40GetSetting(hCom, CmbMacAdrsBuf(0), GettingData40)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP40GetSetting エラー [{0:X}]", Status)
        Else
            ' サンプリングの有無
            ChkCH0.Checked = False
            If (GettingData40.ChannelEnable And &H1) = &H1 Then
                ChkCH0.Checked = True
            End If
            ChkCH1.Checked = False
            If (GettingData40.ChannelEnable And &H2) = &H2 Then
                ChkCH1.Checked = True
            End If
            ChkCH2.Checked = False
            If (GettingData40.ChannelEnable And &H4) = &H4 Then
                ChkCH2.Checked = True
            End If
            ChkCH3.Checked = False
            If (GettingData40.ChannelEnable And &H8) = &H8 Then
                ChkCH3.Checked = True
            End If
            ChkCH4.Checked = False
            If (GettingData40.ChannelEnable And &H10) = &H10 Then
                ChkCH4.Checked = True
            End If
            ChkCH5.Checked = False
            If (GettingData40.ChannelEnable And &H20) = &H20 Then
                ChkCH5.Checked = True
            End If
            ChkCH6.Checked = False
            If (GettingData40.ChannelEnable And &H40) = &H40 Then
                ChkCH6.Checked = True
            End If
            ChkCH7.Checked = False
            If (GettingData40.ChannelEnable And &H80) = &H80 Then
                ChkCH7.Checked = True
            End If

            ' アラーム通知
            ChkAlarm.Checked = False
            If GettingData40.AlarmEnable = &H10 Then
                ChkAlarm.Checked = True
            End If

            ' サンプリング間隔
            TxtSampling.Text = String.Format("{0:D}", GettingData40.SampTime)

            ' トリガポイント
            TxtTrigger.Text = String.Format("{0:D}", GettingData40.Trigger)

            ' レンジ(CH0)
            If ((GettingData40.ChannelRange And &HF) = &H0) Then
                CmbCH0.SelectedIndex = 0
            End If
            If ((GettingData40.ChannelRange And &HF) = &H1) Then
                CmbCH0.SelectedIndex = 1
            End If
            If ((GettingData40.ChannelRange And &HF) = &H2) Then
                CmbCH0.SelectedIndex = 2
            End If
            If ((GettingData40.ChannelRange And &HF) = &H3) Then
                CmbCH0.SelectedIndex = 3
            End If
            If ((GettingData40.ChannelRange And &HF) = &HB) Then
                CmbCH0.SelectedIndex = 4
            End If
            If ((GettingData40.ChannelRange And &HF) = &H5) Then
                CmbCH0.SelectedIndex = 5
            End If
            If ((GettingData40.ChannelRange And &HF) = &H6) Then
                CmbCH0.SelectedIndex = 6
            End If
            If ((GettingData40.ChannelRange And &HF) = &H7) Then
                CmbCH0.SelectedIndex = 7
            End If
            If ((GettingData40.ChannelRange And &HF) = &HF) Then
                CmbCH0.SelectedIndex = 8
            End If
            ' レンジ(CH1)
            If ((GettingData40.ChannelRange And &HF0) = &H0) Then
                CmbCH1.SelectedIndex = 0
            End If
            If ((GettingData40.ChannelRange And &HF0) = &H10) Then
                CmbCH1.SelectedIndex = 1
            End If
            If ((GettingData40.ChannelRange And &HF0) = &H20) Then
                CmbCH1.SelectedIndex = 2
            End If
            If ((GettingData40.ChannelRange And &HF0) = &H30) Then
                CmbCH1.SelectedIndex = 3
            End If
            If ((GettingData40.ChannelRange And &HF0) = &HB0) Then
                CmbCH1.SelectedIndex = 4
            End If
            If ((GettingData40.ChannelRange And &HF0) = &H50) Then
                CmbCH1.SelectedIndex = 5
            End If
            If ((GettingData40.ChannelRange And &HF0) = &H60) Then
                CmbCH1.SelectedIndex = 6
            End If
            If ((GettingData40.ChannelRange And &HF0) = &H70) Then
                CmbCH1.SelectedIndex = 7
            End If
            If ((GettingData40.ChannelRange And &HF0) = &HF0) Then
                CmbCH1.SelectedIndex = 8
            End If
            ' レンジ(CH2)
            If ((GettingData40.ChannelRange And &HF00) = &H0) Then
                CmbCH2.SelectedIndex = 0
            End If
            If ((GettingData40.ChannelRange And &HF00) = &H100) Then
                CmbCH2.SelectedIndex = 1
            End If
            If ((GettingData40.ChannelRange And &HF00) = &H200) Then
                CmbCH2.SelectedIndex = 2
            End If
            If ((GettingData40.ChannelRange And &HF00) = &H300) Then
                CmbCH2.SelectedIndex = 3
            End If
            If ((GettingData40.ChannelRange And &HF00) = &HB00) Then
                CmbCH2.SelectedIndex = 4
            End If
            If ((GettingData40.ChannelRange And &HF00) = &H500) Then
                CmbCH2.SelectedIndex = 5
            End If
            If ((GettingData40.ChannelRange And &HF00) = &H600) Then
                CmbCH2.SelectedIndex = 6
            End If
            If ((GettingData40.ChannelRange And &HF00) = &H700) Then
                CmbCH2.SelectedIndex = 7
            End If
            If ((GettingData40.ChannelRange And &HF00) = &HF00) Then
                CmbCH2.SelectedIndex = 8
            End If
            ' レンジ(CH3)
            If ((GettingData40.ChannelRange And &HF000) = &H0) Then
                CmbCH3.SelectedIndex = 0
            End If
            If ((GettingData40.ChannelRange And &HF000) = &H1000) Then
                CmbCH3.SelectedIndex = 1
            End If
            If ((GettingData40.ChannelRange And &HF000) = &H2000) Then
                CmbCH3.SelectedIndex = 2
            End If
            If ((GettingData40.ChannelRange And &HF000) = &H3000) Then
                CmbCH3.SelectedIndex = 3
            End If
            If ((GettingData40.ChannelRange And &HF000) = &HB000) Then
                CmbCH3.SelectedIndex = 4
            End If
            If ((GettingData40.ChannelRange And &HF000) = &H5000) Then
                CmbCH3.SelectedIndex = 5
            End If
            If ((GettingData40.ChannelRange And &HF000) = &H6000) Then
                CmbCH3.SelectedIndex = 6
            End If
            If ((GettingData40.ChannelRange And &HF000) = &H7000) Then
                CmbCH3.SelectedIndex = 7
            End If
            If ((GettingData40.ChannelRange And &HF000) = &HF000) Then
                CmbCH3.SelectedIndex = 8
            End If
            ' レンジ(CH4)
            If ((GettingData40.ChannelRange And &HF0000) = &H0) Then
                CmbCH4.SelectedIndex = 0
            End If
            If ((GettingData40.ChannelRange And &HF0000) = &H10000) Then
                CmbCH4.SelectedIndex = 1
            End If
            If ((GettingData40.ChannelRange And &HF0000) = &H20000) Then
                CmbCH4.SelectedIndex = 2
            End If
            If ((GettingData40.ChannelRange And &HF0000) = &H30000) Then
                CmbCH4.SelectedIndex = 3
            End If
            If ((GettingData40.ChannelRange And &HF0000) = &HB0000) Then
                CmbCH4.SelectedIndex = 4
            End If
            If ((GettingData40.ChannelRange And &HF0000) = &H50000) Then
                CmbCH4.SelectedIndex = 5
            End If
            If ((GettingData40.ChannelRange And &HF0000) = &H60000) Then
                CmbCH4.SelectedIndex = 6
            End If
            If ((GettingData40.ChannelRange And &HF0000) = &H70000) Then
                CmbCH4.SelectedIndex = 7
            End If
            If ((GettingData40.ChannelRange And &HF0000) = &HF0000) Then
                CmbCH4.SelectedIndex = 8
            End If
            ' レンジ(CH5)
            If ((GettingData40.ChannelRange And &HF00000) = &H0) Then
                CmbCH5.SelectedIndex = 0
            End If
            If ((GettingData40.ChannelRange And &HF00000) = &H100000) Then
                CmbCH5.SelectedIndex = 1
            End If
            If ((GettingData40.ChannelRange And &HF00000) = &H200000) Then
                CmbCH5.SelectedIndex = 2
            End If
            If ((GettingData40.ChannelRange And &HF00000) = &H300000) Then
                CmbCH5.SelectedIndex = 3
            End If
            If ((GettingData40.ChannelRange And &HF00000) = &HB00000) Then
                CmbCH5.SelectedIndex = 4
            End If
            If ((GettingData40.ChannelRange And &HF00000) = &H500000) Then
                CmbCH5.SelectedIndex = 5
            End If
            If ((GettingData40.ChannelRange And &HF00000) = &H600000) Then
                CmbCH5.SelectedIndex = 6
            End If
            If ((GettingData40.ChannelRange And &HF00000) = &H700000) Then
                CmbCH5.SelectedIndex = 7
            End If
            If ((GettingData40.ChannelRange And &HF00000) = &HF00000) Then
                CmbCH5.SelectedIndex = 8
            End If
            ' レンジ(CH6)
            If ((GettingData40.ChannelRange And &HF000000) = &H0) Then
                CmbCH6.SelectedIndex = 0
            End If
            If ((GettingData40.ChannelRange And &HF000000) = &H1000000) Then
                CmbCH6.SelectedIndex = 1
            End If
            If ((GettingData40.ChannelRange And &HF000000) = &H2000000) Then
                CmbCH6.SelectedIndex = 2
            End If
            If ((GettingData40.ChannelRange And &HF000000) = &H3000000) Then
                CmbCH6.SelectedIndex = 3
            End If
            If ((GettingData40.ChannelRange And &HF000000) = &HB000000) Then
                CmbCH6.SelectedIndex = 4
            End If
            If ((GettingData40.ChannelRange And &HF000000) = &H5000000) Then
                CmbCH6.SelectedIndex = 5
            End If
            If ((GettingData40.ChannelRange And &HF000000) = &H6000000) Then
                CmbCH6.SelectedIndex = 6
            End If
            If ((GettingData40.ChannelRange And &HF000000) = &H7000000) Then
                CmbCH6.SelectedIndex = 7
            End If
            If ((GettingData40.ChannelRange And &HF000000) = &HF000000) Then
                CmbCH6.SelectedIndex = 8
            End If
            ' レンジ(CH7)
            If ((GettingData40.ChannelRange And &HF0000000) = &H0) Then
                CmbCH7.SelectedIndex = 0
            End If
            If ((GettingData40.ChannelRange And &HF0000000) = &H10000000) Then
                CmbCH7.SelectedIndex = 1
            End If
            If ((GettingData40.ChannelRange And &HF0000000) = &H20000000) Then
                CmbCH7.SelectedIndex = 2
            End If
            If ((GettingData40.ChannelRange And &HF0000000) = &H30000000) Then
                CmbCH7.SelectedIndex = 3
            End If
            If ((GettingData40.ChannelRange And &HF0000000) = &HB0000000) Then
                CmbCH7.SelectedIndex = 4
            End If
            If ((GettingData40.ChannelRange And &HF0000000) = &H50000000) Then
                CmbCH7.SelectedIndex = 5
            End If
            If ((GettingData40.ChannelRange And &HF0000000) = &H60000000) Then
                CmbCH7.SelectedIndex = 6
            End If
            If ((GettingData40.ChannelRange And &HF0000000) = &H70000000) Then
                CmbCH7.SelectedIndex = 7
            End If
            If ((GettingData40.ChannelRange And &HF0000000) = &HF0000000) Then
                CmbCH7.SelectedIndex = 8
            End If

            ' 上限閾値
            TxtUpperCH0.Text = String.Format("{0:F2}", GetdbValue(0, GettingData40.ChUpperThreshold.Ushortcode_0))
            TxtUpperCH1.Text = String.Format("{0:F2}", GetdbValue(1, GettingData40.ChUpperThreshold.Ushortcode_1))
            TxtUpperCH2.Text = String.Format("{0:F2}", GetdbValue(2, GettingData40.ChUpperThreshold.Ushortcode_2))
            TxtUpperCH3.Text = String.Format("{0:F2}", GetdbValue(3, GettingData40.ChUpperThreshold.Ushortcode_3))
            TxtUpperCH4.Text = String.Format("{0:F2}", GetdbValue(4, GettingData40.ChUpperThreshold.Ushortcode_4))
            TxtUpperCH5.Text = String.Format("{0:F2}", GetdbValue(5, GettingData40.ChUpperThreshold.Ushortcode_5))
            TxtUpperCH6.Text = String.Format("{0:F2}", GetdbValue(6, GettingData40.ChUpperThreshold.Ushortcode_6))
            TxtUpperCH7.Text = String.Format("{0:F2}", GetdbValue(7, GettingData40.ChUpperThreshold.Ushortcode_7))
            ' 下限閾値
            TxtLowerCH0.Text = String.Format("{0:F2}", GetdbValue(0, GettingData40.ChLowerThreshold.Ushortcode_0))
            TxtLowerCH1.Text = String.Format("{0:F2}", GetdbValue(1, GettingData40.ChLowerThreshold.Ushortcode_1))
            TxtLowerCH2.Text = String.Format("{0:F2}", GetdbValue(2, GettingData40.ChLowerThreshold.Ushortcode_2))
            TxtLowerCH3.Text = String.Format("{0:F2}", GetdbValue(3, GettingData40.ChLowerThreshold.Ushortcode_3))
            TxtLowerCH4.Text = String.Format("{0:F2}", GetdbValue(4, GettingData40.ChLowerThreshold.Ushortcode_4))
            TxtLowerCH5.Text = String.Format("{0:F2}", GetdbValue(5, GettingData40.ChLowerThreshold.Ushortcode_5))
            TxtLowerCH6.Text = String.Format("{0:F2}", GetdbValue(6, GettingData40.ChLowerThreshold.Ushortcode_6))
            TxtLowerCH7.Text = String.Format("{0:F2}", GetdbValue(7, GettingData40.ChLowerThreshold.Ushortcode_7))
        End If

        ' 有効
        BtnGP40Stop.Enabled = True
        BtnDIOHighOut.Enabled = True
        BtnDIOLowOut.Enabled = True
        BtnDIOIn.Enabled = True
        BtnGetSetting.Enabled = True
        BtnSetSetting.Enabled = True
        BtnGetStart.Enabled = True
        BtnGetStop.Enabled = True
        BtnOneShot.Enabled = True
        BtnGet.Enabled = True
        BtnGetSetting.Focus()
    End Sub

    Private Sub BtnSetSetting_Click(sender As System.Object, e As System.EventArgs) Handles BtnSetSetting.Click
        Dim Status As UInt32
        Dim SettingData40 As GP40Setting

        If (TxtSampling.Text.Length = 0) Then
            MessageBox.Show("1-65535のサンプリング間隔を指定してください")
            Exit Sub
        End If
        If ((Int32.Parse(TxtSampling.Text) < 1) Or (Int32.Parse(TxtSampling.Text) > 65535)) Then
            MessageBox.Show("1-65535のサンプリング間隔を指定してください")
            Exit Sub
        End If
        If (TxtTrigger.Text.Length = 0) Then
            MessageBox.Show("1-50のトリガポイントを指定してください")
            Exit Sub
        End If
        If (Int32.Parse(TxtTrigger.Text) < 1) Or (Int32.Parse(TxtTrigger.Text) > 50) Then
            MessageBox.Show("1-50のトリガポイントを指定してください")
            Exit Sub
        End If


        ' 無効
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' サンプリングの有無
        SettingData40.ChannelEnable = &H0
        If ChkCH0.Checked Then
            SettingData40.ChannelEnable = SettingData40.ChannelEnable Or &H1
        End If
        If ChkCH1.Checked Then
            SettingData40.ChannelEnable = SettingData40.ChannelEnable Or &H2
        End If
        If ChkCH2.Checked Then
            SettingData40.ChannelEnable = SettingData40.ChannelEnable Or &H4
        End If
        If ChkCH3.Checked Then
            SettingData40.ChannelEnable = SettingData40.ChannelEnable Or &H8
        End If
        If ChkCH4.Checked Then
            SettingData40.ChannelEnable = SettingData40.ChannelEnable Or &H10
        End If
        If ChkCH5.Checked Then
            SettingData40.ChannelEnable = SettingData40.ChannelEnable Or &H20
        End If
        If ChkCH6.Checked Then
            SettingData40.ChannelEnable = SettingData40.ChannelEnable Or &H40
        End If
        If ChkCH7.Checked Then
            SettingData40.ChannelEnable = SettingData40.ChannelEnable Or &H80
        End If

        ' アラーム通知
        SettingData40.AlarmEnable = &H0
        If ChkAlarm.Checked Then
            SettingData40.AlarmEnable = &H10
        End If

        ' サンプリング間隔
        SettingData40.SampTime = UInt16.Parse(TxtSampling.Text)

        ' トリガポイント
        SettingData40.Trigger = UInt16.Parse(TxtTrigger.Text)

        ' レンジ(CH0)
        SettingData40.ChannelRange = &H0
        If CmbCH0.SelectedIndex = 0 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H0
        End If
        If CmbCH0.SelectedIndex = 1 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H1
        End If
        If CmbCH0.SelectedIndex = 2 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H2
        End If
        If CmbCH0.SelectedIndex = 3 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H3
        End If
        If CmbCH0.SelectedIndex = 4 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HB
        End If
        If CmbCH0.SelectedIndex = 5 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H5
        End If
        If CmbCH0.SelectedIndex = 6 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H6
        End If
        If CmbCH0.SelectedIndex = 7 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H7
        End If
        If CmbCH0.SelectedIndex = 8 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HF
        End If
        ' レンジ(CH1)
        If CmbCH1.SelectedIndex = 0 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H0
        End If
        If CmbCH1.SelectedIndex = 1 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H10
        End If
        If CmbCH1.SelectedIndex = 2 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H20
        End If
        If CmbCH1.SelectedIndex = 3 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H30
        End If
        If CmbCH1.SelectedIndex = 4 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HB0
        End If
        If CmbCH1.SelectedIndex = 5 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H50
        End If
        If CmbCH1.SelectedIndex = 6 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H60
        End If
        If CmbCH1.SelectedIndex = 7 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H70
        End If
        If CmbCH1.SelectedIndex = 8 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HF0
        End If
        ' レンジ(CH2)
        If CmbCH2.SelectedIndex = 0 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H0
        End If
        If CmbCH2.SelectedIndex = 1 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H100
        End If
        If CmbCH2.SelectedIndex = 2 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H200
        End If
        If CmbCH2.SelectedIndex = 3 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H300
        End If
        If CmbCH2.SelectedIndex = 4 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HB00
        End If
        If CmbCH2.SelectedIndex = 5 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H500
        End If
        If CmbCH2.SelectedIndex = 6 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H600
        End If
        If CmbCH2.SelectedIndex = 7 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H700
        End If
        If CmbCH2.SelectedIndex = 8 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HF00
        End If
        ' レンジ(CH3)
        If CmbCH3.SelectedIndex = 0 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H0
        End If
        If CmbCH3.SelectedIndex = 1 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H1000
        End If
        If CmbCH3.SelectedIndex = 2 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H2000
        End If
        If CmbCH3.SelectedIndex = 3 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H3000
        End If
        If CmbCH3.SelectedIndex = 4 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HB000
        End If
        If CmbCH3.SelectedIndex = 5 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H5000
        End If
        If CmbCH3.SelectedIndex = 6 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H6000
        End If
        If CmbCH3.SelectedIndex = 7 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H7000
        End If
        If CmbCH3.SelectedIndex = 8 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HF000
        End If
        ' レンジ(CH4)
        If CmbCH4.SelectedIndex = 0 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H0
        End If
        If CmbCH4.SelectedIndex = 1 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H10000
        End If
        If CmbCH4.SelectedIndex = 2 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H20000
        End If
        If CmbCH4.SelectedIndex = 3 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H30000
        End If
        If CmbCH4.SelectedIndex = 4 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HB0000
        End If
        If CmbCH4.SelectedIndex = 5 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H50000
        End If
        If CmbCH4.SelectedIndex = 6 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H60000
        End If
        If CmbCH4.SelectedIndex = 7 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H70000
        End If
        If CmbCH4.SelectedIndex = 8 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HF0000
        End If
        ' レンジ(CH5)
        If CmbCH5.SelectedIndex = 0 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H0
        End If
        If CmbCH5.SelectedIndex = 1 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H100000
        End If
        If CmbCH5.SelectedIndex = 2 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H200000
        End If
        If CmbCH5.SelectedIndex = 3 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H300000
        End If
        If CmbCH5.SelectedIndex = 4 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HB00000
        End If
        If CmbCH5.SelectedIndex = 5 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H500000
        End If
        If CmbCH5.SelectedIndex = 6 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H600000
        End If
        If CmbCH5.SelectedIndex = 7 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H700000
        End If
        If CmbCH5.SelectedIndex = 8 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HF00000
        End If
        ' レンジ(CH6)
        If CmbCH6.SelectedIndex = 0 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H0
        End If
        If CmbCH6.SelectedIndex = 1 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H1000000
        End If
        If CmbCH6.SelectedIndex = 2 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H2000000
        End If
        If CmbCH6.SelectedIndex = 3 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H3000000
        End If
        If CmbCH6.SelectedIndex = 4 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HB000000
        End If
        If CmbCH6.SelectedIndex = 5 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H5000000
        End If
        If CmbCH6.SelectedIndex = 6 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H6000000
        End If
        If CmbCH6.SelectedIndex = 7 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H7000000
        End If
        If CmbCH6.SelectedIndex = 8 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HF000000
        End If
        ' レンジ(CH7)
        If CmbCH7.SelectedIndex = 0 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H0
        End If
        If CmbCH7.SelectedIndex = 1 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H10000000
        End If
        If CmbCH7.SelectedIndex = 2 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H20000000
        End If
        If CmbCH7.SelectedIndex = 3 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H30000000
        End If
        If CmbCH7.SelectedIndex = 4 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HB0000000UI
        End If
        If CmbCH7.SelectedIndex = 5 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H50000000
        End If
        If CmbCH7.SelectedIndex = 6 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H60000000
        End If
        If CmbCH7.SelectedIndex = 7 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &H70000000
        End If
        If CmbCH7.SelectedIndex = 8 Then
            SettingData40.ChannelRange = SettingData40.ChannelRange Or &HF0000000UI
        End If

        ' 上限閾値
        SettingData40.ChUpperThreshold.Ushortcode_0 = GetwValue(0, Double.Parse(TxtUpperCH0.Text))
        SettingData40.ChUpperThreshold.Ushortcode_1 = GetwValue(1, Double.Parse(TxtUpperCH1.Text))
        SettingData40.ChUpperThreshold.Ushortcode_2 = GetwValue(2, Double.Parse(TxtUpperCH2.Text))
        SettingData40.ChUpperThreshold.Ushortcode_3 = GetwValue(3, Double.Parse(TxtUpperCH3.Text))
        SettingData40.ChUpperThreshold.Ushortcode_4 = GetwValue(4, Double.Parse(TxtUpperCH4.Text))
        SettingData40.ChUpperThreshold.Ushortcode_5 = GetwValue(5, Double.Parse(TxtUpperCH5.Text))
        SettingData40.ChUpperThreshold.Ushortcode_6 = GetwValue(6, Double.Parse(TxtUpperCH6.Text))
        SettingData40.ChUpperThreshold.Ushortcode_7 = GetwValue(7, Double.Parse(TxtUpperCH7.Text))
        ' 下限閾値
        SettingData40.ChLowerThreshold.Ushortcode_0 = GetwValue(0, Double.Parse(TxtLowerCH0.Text))
        SettingData40.ChLowerThreshold.Ushortcode_1 = GetwValue(1, Double.Parse(TxtLowerCH1.Text))
        SettingData40.ChLowerThreshold.Ushortcode_2 = GetwValue(2, Double.Parse(TxtLowerCH2.Text))
        SettingData40.ChLowerThreshold.Ushortcode_3 = GetwValue(3, Double.Parse(TxtLowerCH3.Text))
        SettingData40.ChLowerThreshold.Ushortcode_4 = GetwValue(4, Double.Parse(TxtLowerCH4.Text))
        SettingData40.ChLowerThreshold.Ushortcode_5 = GetwValue(5, Double.Parse(TxtLowerCH5.Text))
        SettingData40.ChLowerThreshold.Ushortcode_6 = GetwValue(6, Double.Parse(TxtLowerCH6.Text))
        SettingData40.ChLowerThreshold.Ushortcode_7 = GetwValue(7, Double.Parse(TxtLowerCH7.Text))

        ' 値を整えて表示( -10.24までなのに-30と設定しようとした場合-10.24と表示する )
        ' 上限閾値
        TxtUpperCH0.Text = String.Format("{0:F2}", GetdbValue(0, SettingData40.ChUpperThreshold.Ushortcode_0))
        TxtUpperCH1.Text = String.Format("{0:F2}", GetdbValue(1, SettingData40.ChUpperThreshold.Ushortcode_1))
        TxtUpperCH2.Text = String.Format("{0:F2}", GetdbValue(2, SettingData40.ChUpperThreshold.Ushortcode_2))
        TxtUpperCH3.Text = String.Format("{0:F2}", GetdbValue(3, SettingData40.ChUpperThreshold.Ushortcode_3))
        TxtUpperCH4.Text = String.Format("{0:F2}", GetdbValue(4, SettingData40.ChUpperThreshold.Ushortcode_4))
        TxtUpperCH5.Text = String.Format("{0:F2}", GetdbValue(5, SettingData40.ChUpperThreshold.Ushortcode_5))
        TxtUpperCH6.Text = String.Format("{0:F2}", GetdbValue(6, SettingData40.ChUpperThreshold.Ushortcode_6))
        TxtUpperCH7.Text = String.Format("{0:F2}", GetdbValue(7, SettingData40.ChUpperThreshold.Ushortcode_7))
        ' 下限閾値
        TxtLowerCH0.Text = String.Format("{0:F2}", GetdbValue(0, SettingData40.ChLowerThreshold.Ushortcode_0))
        TxtLowerCH1.Text = String.Format("{0:F2}", GetdbValue(1, SettingData40.ChLowerThreshold.Ushortcode_1))
        TxtLowerCH2.Text = String.Format("{0:F2}", GetdbValue(2, SettingData40.ChLowerThreshold.Ushortcode_2))
        TxtLowerCH3.Text = String.Format("{0:F2}", GetdbValue(3, SettingData40.ChLowerThreshold.Ushortcode_3))
        TxtLowerCH4.Text = String.Format("{0:F2}", GetdbValue(4, SettingData40.ChLowerThreshold.Ushortcode_4))
        TxtLowerCH5.Text = String.Format("{0:F2}", GetdbValue(5, SettingData40.ChLowerThreshold.Ushortcode_5))
        TxtLowerCH6.Text = String.Format("{0:F2}", GetdbValue(6, SettingData40.ChLowerThreshold.Ushortcode_6))
        TxtLowerCH7.Text = String.Format("{0:F2}", GetdbValue(7, SettingData40.ChLowerThreshold.Ushortcode_7))


        ' 設定書込
        Status = RPiGP40SetSetting(hCom, CmbMacAdrsBuf(0), SettingData40)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP40SetSetting エラー [{0:X}]", Status)
        End If

        ' 有効
        BtnGP40Stop.Enabled = True
        BtnDIOHighOut.Enabled = True
        BtnDIOLowOut.Enabled = True
        BtnDIOIn.Enabled = True
        BtnGetSetting.Enabled = True
        BtnSetSetting.Enabled = True
        BtnGetStart.Enabled = True
        BtnGetStop.Enabled = True
        BtnOneShot.Enabled = True
        BtnGet.Enabled = True
        BtnSetSetting.Focus()
    End Sub

    Private Sub BtnOneShot_Click(sender As System.Object, e As System.EventArgs) Handles BtnOneShot.Click
        Dim Status As UInt32
        Dim GetChData As RsUshortData

        ' 無効
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' 1回取得
        Status = RPiGP40OneShot(hCom, CmbMacAdrsBuf(0), GetChData)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP40OneShot エラー [{0:X}]", Status)
        Else
            ' データ
            TxtCH0.Text = String.Format("{0:F2}", GetdbValue(0, GetChData.Ushortcode_0))
            TxtCH1.Text = String.Format("{0:F2}", GetdbValue(1, GetChData.Ushortcode_1))
            TxtCH2.Text = String.Format("{0:F2}", GetdbValue(2, GetChData.Ushortcode_2))
            TxtCH3.Text = String.Format("{0:F2}", GetdbValue(3, GetChData.Ushortcode_3))
            TxtCH4.Text = String.Format("{0:F2}", GetdbValue(4, GetChData.Ushortcode_4))
            TxtCH5.Text = String.Format("{0:F2}", GetdbValue(5, GetChData.Ushortcode_5))
            TxtCH6.Text = String.Format("{0:F2}", GetdbValue(6, GetChData.Ushortcode_6))
            TxtCH7.Text = String.Format("{0:F2}", GetdbValue(7, GetChData.Ushortcode_7))
        End If

        ' 有効
        BtnGP40Stop.Enabled = True
        BtnDIOHighOut.Enabled = True
        BtnDIOLowOut.Enabled = True
        BtnDIOIn.Enabled = True
        BtnGetSetting.Enabled = True
        BtnSetSetting.Enabled = True
        BtnGetStart.Enabled = True
        BtnGetStop.Enabled = True
        BtnOneShot.Enabled = True
        BtnGet.Enabled = True
        BtnOneShot.Focus()
    End Sub

    Private Sub BtnGetStart_Click(sender As System.Object, e As System.EventArgs) Handles BtnGetStart.Click
        Dim Status As UInt32

        ' 無効
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' 連続取得開始(1分)
        Status = RPiGP40TimerData(hCom, CmbMacAdrsBuf(0), 1, 1)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP40TimerData エラー [{0:X}]", Status)
        End If

        ' 有効
        BtnGP40Stop.Enabled = True
        BtnDIOHighOut.Enabled = True
        BtnDIOLowOut.Enabled = True
        BtnDIOIn.Enabled = True
        BtnGetSetting.Enabled = True
        BtnSetSetting.Enabled = True
        BtnGetStart.Enabled = True
        BtnGetStop.Enabled = True
        BtnOneShot.Enabled = True
        BtnGet.Enabled = True
        BtnGetStart.Focus()
    End Sub

    Private Sub BtnGetStop_Click(sender As System.Object, e As System.EventArgs) Handles BtnGetStop.Click
        Dim Status As UInt32

        ' 無効
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' 連続取得停止
        Status = RPiGP40TimerData(hCom, CmbMacAdrsBuf(0), 0, 1)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP40TimerData エラー [{0:X}]", Status)
        End If

        ' 有効
        BtnGP40Stop.Enabled = True
        BtnDIOHighOut.Enabled = True
        BtnDIOLowOut.Enabled = True
        BtnDIOIn.Enabled = True
        BtnGetSetting.Enabled = True
        BtnSetSetting.Enabled = True
        BtnGetStart.Enabled = True
        BtnGetStop.Enabled = True
        BtnOneShot.Enabled = True
        BtnGet.Enabled = True
        BtnGetStop.Focus()
    End Sub

    Private Sub BtnDIOHighOut_Click(sender As System.Object, e As System.EventArgs) Handles BtnDIOHighOut.Click
        Dim Status As UInt32

        ' 無効
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' 出力(DIO : High)オープンコレクタのため0
        Status = RPiGP40OutPort(hCom, CmbMacAdrsBuf(0), 0)

        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP40OutPort エラー [{0:X}]", Status)
        End If

        ' 有効
        BtnGP40Stop.Enabled = True
        BtnDIOHighOut.Enabled = True
        BtnDIOLowOut.Enabled = True
        BtnDIOIn.Enabled = True
        BtnGetSetting.Enabled = True
        BtnSetSetting.Enabled = True
        BtnGetStart.Enabled = True
        BtnGetStop.Enabled = True
        BtnOneShot.Enabled = True
        BtnGet.Enabled = True
        BtnDIOHighOut.Focus()
    End Sub

    Private Sub BtnDIOLowOut_Click(sender As System.Object, e As System.EventArgs) Handles BtnDIOLowOut.Click
        Dim Status As UInt32

        ' 無効
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' 出力(DIO : Low)オープンコレクタのため1
        Status = RPiGP40OutPort(hCom, CmbMacAdrsBuf(0), 1)

        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP40OutPort エラー [{0:X}]", Status)
        End If

        ' 有効
        BtnGP40Stop.Enabled = True
        BtnDIOHighOut.Enabled = True
        BtnDIOLowOut.Enabled = True
        BtnDIOIn.Enabled = True
        BtnGetSetting.Enabled = True
        BtnSetSetting.Enabled = True
        BtnGetStart.Enabled = True
        BtnGetStop.Enabled = True
        BtnOneShot.Enabled = True
        BtnGet.Enabled = True
        BtnDIOLowOut.Focus()
    End Sub

    Private Sub BtnDIOIn_Click(sender As System.Object, e As System.EventArgs) Handles BtnDIOIn.Click
        Dim Status As UInt32
        Dim bInData As Byte

        ' 無効
        BtnGP40Stop.Enabled = False
        BtnDIOHighOut.Enabled = False
        BtnDIOLowOut.Enabled = False
        BtnDIOIn.Enabled = False
        BtnGetSetting.Enabled = False
        BtnSetSetting.Enabled = False
        BtnGetStart.Enabled = False
        BtnGetStop.Enabled = False
        BtnOneShot.Enabled = False
        BtnGet.Enabled = False

        ' 入力
        Status = RPiGP40InPort(hCom, CmbMacAdrsBuf(0), bInData)
        If Status <> 0 Then
            TxtMsg.Text = String.Format("RPiGP40InPort エラー [{0:X}]", Status)
        Else
            ' Low
            If bInData = &H0 Then
                TxtDIOIn.Text = "Low"
                ' High
            Else
                TxtDIOIn.Text = "High"
            End If
        End If

        ' 有効
        BtnGP40Stop.Enabled = True
        BtnDIOHighOut.Enabled = True
        BtnDIOLowOut.Enabled = True
        BtnDIOIn.Enabled = True
        BtnGetSetting.Enabled = True
        BtnSetSetting.Enabled = True
        BtnGetStart.Enabled = True
        BtnGetStop.Enabled = True
        BtnOneShot.Enabled = True
        BtnGet.Enabled = True
        BtnDIOIn.Focus()
    End Sub


    Private Sub BtnExit_Click(sender As System.Object, e As System.EventArgs) Handles BtnExit.Click
        Dim iii As Byte

        TxtMsg.Text = "停止中..."
        Application.DoEvents()

        If fStart = True Then
            ' 停止
            RSSG2000Stop(hCom)

            For iii = 0 To 16 * 8 - 1 Step 8
                If ((MacAdrs(iii + 0) = &H0) And (MacAdrs(iii + 1) = &H0) And (MacAdrs(iii + 2) = &H0) And (MacAdrs(iii + 3) = &H0) And (MacAdrs(iii + 4) = &H0) And (MacAdrs(iii + 5) = &H0) And (MacAdrs(iii + 6) = &H0) And (MacAdrs(iii + 7) = &H0)) Then

                Else
                    CmbMacAdrsBuf(0) = MacAdrs(iii + 0)
                    CmbMacAdrsBuf(1) = MacAdrs(iii + 1)
                    CmbMacAdrsBuf(2) = MacAdrs(iii + 2)
                    CmbMacAdrsBuf(3) = MacAdrs(iii + 3)
                    CmbMacAdrsBuf(4) = MacAdrs(iii + 4)
                    CmbMacAdrsBuf(5) = MacAdrs(iii + 5)
                    CmbMacAdrsBuf(6) = MacAdrs(iii + 6)
                    CmbMacAdrsBuf(7) = MacAdrs(iii + 7)

                    ' 削除
                    RSSG2000DeleteMacAdrs(hCom, CmbMacAdrsBuf(0))
                End If
            Next iii

            ' クローズ
            RSSG2000Close(hCom)
            hCom = &HFFFFFFFFL
        End If

        Me.Close()
    End Sub

    Private Sub CmbMacAdrs_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles CmbMacAdrs.SelectedIndexChanged
        Dim strMacAdrs As String
        Dim Version(8) As Byte
        Dim RSSI As SByte
        Dim Temp As Double
        Dim Humidity As Double

        ' コンボボックスから取得
        strMacAdrs = CmbMacAdrs.GetItemText(CmbMacAdrs.SelectedItem)

        CmbMacAdrsBuf(0) = Byte.Parse(strMacAdrs.Substring(0, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(1) = Byte.Parse(strMacAdrs.Substring(3, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(2) = Byte.Parse(strMacAdrs.Substring(6, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(3) = Byte.Parse(strMacAdrs.Substring(9, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(4) = Byte.Parse(strMacAdrs.Substring(12, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(5) = Byte.Parse(strMacAdrs.Substring(15, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(6) = Byte.Parse(strMacAdrs.Substring(18, 2), Globalization.NumberStyles.HexNumber)
        CmbMacAdrsBuf(7) = Byte.Parse(strMacAdrs.Substring(21, 2), Globalization.NumberStyles.HexNumber)

        If fStart = True Then
            ' バージョン取得
            RSSG2000GetVersion(hCom, CmbMacAdrsBuf(0), Version(0))
            TxtVersion.Text = String.Format("{0:X}.{1:X2}", Version(0), Version(1))
            ' RSSI取得
            RSSG2000GetRSSI(hCom, CmbMacAdrsBuf(0), RSSI)
            TxtRSSI.Text = String.Format("{0:D}", RSSI)
            ' 温湿度取得
            RSSG2000GetTemp(hCom, CmbMacAdrsBuf(0), Temp, Humidity)
            TxtTemp.Text = String.Format("{0:F1}", Temp)
            TxtHumidity.Text = String.Format("{0:F1}", Humidity)
        End If

        ' 開始フラグ
        If fGP40Start(CmbMacAdrs.SelectedIndex) = True Then
            ' 無効
            BtnGP40Start.Enabled = False
            ' 有効
            BtnGP40Stop.Enabled = True
            BtnDIOHighOut.Enabled = True
            BtnDIOLowOut.Enabled = True
            BtnDIOIn.Enabled = True
            BtnGetSetting.Enabled = True
            BtnSetSetting.Enabled = True
            BtnGetStart.Enabled = True
            BtnGetStop.Enabled = True
            BtnOneShot.Enabled = True
        Else
            If fStart = True Then
                ' 有効
                BtnGP40Start.Enabled = True
                ' 無効
                BtnGP40Stop.Enabled = False
                BtnDIOHighOut.Enabled = False
                BtnDIOLowOut.Enabled = False
                BtnDIOIn.Enabled = False
                BtnGetSetting.Enabled = False
                BtnSetSetting.Enabled = False
                BtnGetStart.Enabled = False
                BtnGetStop.Enabled = False
                BtnOneShot.Enabled = False
            End If
        End If
    End Sub

    Private Function GetdbValue(ByVal CHNo As Byte, ByVal wData As UInt16)
        Dim dbData As Double
        Dim Range As Byte
        Dim dbRes As Double

        ' レンジ
        Range = 0
        Select Case (CHNo)
            Case 0 : Range = CmbCH0.SelectedIndex
            Case 1 : Range = CmbCH1.SelectedIndex
            Case 2 : Range = CmbCH2.SelectedIndex
            Case 3 : Range = CmbCH3.SelectedIndex
            Case 4 : Range = CmbCH4.SelectedIndex
            Case 5 : Range = CmbCH5.SelectedIndex
            Case 6 : Range = CmbCH6.SelectedIndex
            Case 7 : Range = CmbCH7.SelectedIndex
        End Select

        dbRes = 1.0
        ' {"±10.24V", "±5.12V", "±2.56V", "±1.28V", "±0.64V", "0～10.24V", "0～5.12V", "0～2.56V", "0～1.28V"};
        Select Case (Range)
            Case 0 : dbRes = 20.48 / 4095.0
            Case 1 : dbRes = 10.24 / 4095.0
            Case 2 : dbRes = 5.12 / 4095.0
            Case 3 : dbRes = 2.56 / 4095.0
            Case 4 : dbRes = 1.28 / 4095.0
            Case 5 : dbRes = 10.24 / 4095.0
            Case 6 : dbRes = 5.12 / 4095.0
            Case 7 : dbRes = 2.56 / 4095.0
            Case 8 : dbRes = 1.28 / 4095.0
        End Select

        dbData = 0.0
        Select Case (Range)
            Case 0 : dbData = -10.24 + dbRes * wData
            Case 1 : dbData = -5.12 + dbRes * wData
            Case 2 : dbData = -2.56 + dbRes * wData
            Case 3 : dbData = -1.28 + dbRes * wData
            Case 4 : dbData = -0.64 + dbRes * wData
            Case 5 : dbData = dbRes * wData
            Case 6 : dbData = dbRes * wData
            Case 7 : dbData = dbRes * wData
            Case 8 : dbData = dbRes * wData
        End Select


        GetdbValue = dbData
    End Function

    Private Function GetwValue(ByVal CHNo As Byte, ByVal dbData As Double)
        Dim wData As UInt16
        Dim Range As Byte
        Dim dbRes As Double

        ' レンジ
        Range = 0
        Select Case (CHNo)
            Case 0 : Range = CmbCH0.SelectedIndex
            Case 1 : Range = CmbCH1.SelectedIndex
            Case 2 : Range = CmbCH2.SelectedIndex
            Case 3 : Range = CmbCH3.SelectedIndex
            Case 4 : Range = CmbCH4.SelectedIndex
            Case 5 : Range = CmbCH5.SelectedIndex
            Case 6 : Range = CmbCH6.SelectedIndex
            Case 7 : Range = CmbCH7.SelectedIndex
        End Select

        dbRes = 1.0
        ' {"±10.24V", "±5.12V", "±2.56V", "±1.28V", "±0.64V", "0～10.24V", "0～5.12V", "0～2.56V", "0～1.28V"};
        Select Case (Range)
            Case 0 : dbRes = 20.48 / 4095.0
            Case 1 : dbRes = 10.24 / 4095.0
            Case 2 : dbRes = 5.12 / 4095.0
            Case 3 : dbRes = 2.56 / 4095.0
            Case 4 : dbRes = 1.28 / 4095.0
            Case 5 : dbRes = 10.24 / 4095.0
            Case 6 : dbRes = 5.12 / 4095.0
            Case 7 : dbRes = 2.56 / 4095.0
            Case 8 : dbRes = 1.28 / 4095.0
        End Select

        wData = 0
        Select Case (Range)
            Case 0
                If dbData >= 10.24 Then
                    wData = 4095
                ElseIf dbData <= -10.24 Then
                    wData = 0
                Else
                    wData = ((dbData + 10.24) / dbRes)
                End If
            Case 1
                If dbData >= 5.12 Then
                    wData = 4095
                ElseIf dbData <= -5.12 Then
                    wData = 0
                Else
                    wData = ((dbData + 5.12) / dbRes)
                End If
            Case 2
                If dbData >= 2.56 Then
                    wData = 4095
                ElseIf dbData <= -2.56 Then
                    wData = 0
                Else
                    wData = ((dbData + 2.56) / dbRes)
                End If
            Case 3
                If dbData >= 1.28 Then
                    wData = 4095
                ElseIf dbData <= -1.28 Then
                    wData = 0
                Else
                    wData = ((dbData + 1.28) / dbRes)
                End If
            Case 4
                If dbData >= 0.64 Then
                    wData = 4095
                ElseIf dbData <= -0.64 Then
                    wData = 0
                Else
                    wData = ((dbData + 0.64) / dbRes)
                End If
            Case 5
                If dbData >= 10.24 Then
                    wData = 4095
                ElseIf dbData <= 0 Then
                    wData = 0
                Else
                    wData = (dbData / dbRes)
                End If
            Case 6
                If dbData >= 5.12 Then
                    wData = 4095
                ElseIf dbData <= 0 Then
                    wData = 0
                Else
                    wData = (dbData / dbRes)
                End If
            Case 7
                If dbData >= 2.56 Then
                    wData = 4095
                ElseIf dbData <= 0 Then
                    wData = 0
                Else
                    wData = (dbData / dbRes)
                End If
            Case 8
                If dbData >= 1.28 Then
                    wData = 4095
                ElseIf dbData <= 0 Then
                    wData = 0
                Else
                    wData = (dbData / dbRes)
                End If
        End Select

        GetwValue = wData
    End Function

End Class
