
// RSSG2040Dlg.cpp : t@C
//

#include "stdafx.h"
#include "RSSG2040.h"
#include "RSSG2040Dlg.h"
#include "afxdialogex.h"
#include "RSSG2000.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

HWND hwnd;
HANDLE hComPort;

// CRSSG2040Dlg _CAO

double GetdbValue(UCHAR CHNo, WORD wData)
{
	double	dbData;
	UCHAR	Range;
	double	dbRes;
	HWND hCombo;
	

	// W
	Range = 0;
	switch( CHNo )
	{
	case 0:	
		hCombo = GetDlgItem(hwnd, IDCB_CH0);
		Range= SendMessage(hCombo, CB_GETCURSEL, 0, 0);
		break;
	case 1:	
		hCombo = GetDlgItem(hwnd, IDCB_CH1);
		Range= SendMessage(hCombo, CB_GETCURSEL, 0, 0);
		break;
	case 2:	
		hCombo = GetDlgItem(hwnd, IDCB_CH2);
		Range= SendMessage(hCombo, CB_GETCURSEL, 0, 0);
		break;
	case 3:	
		hCombo = GetDlgItem(hwnd, IDCB_CH3);
		Range= SendMessage(hCombo, CB_GETCURSEL, 0, 0);
		break;
	case 4:	
		hCombo = GetDlgItem(hwnd, IDCB_CH4);
		Range= SendMessage(hCombo, CB_GETCURSEL, 0, 0);
		break;
	case 5:	
		hCombo = GetDlgItem(hwnd, IDCB_CH5);
		Range= SendMessage(hCombo, CB_GETCURSEL, 0, 0);
		break;
	case 6:	
		hCombo = GetDlgItem(hwnd, IDCB_CH6);
		Range= SendMessage(hCombo, CB_GETCURSEL, 0, 0);
		break;
	case 7:	
		hCombo = GetDlgItem(hwnd, IDCB_CH7);
		Range= SendMessage(hCombo, CB_GETCURSEL, 0, 0);
		break;
	}

	dbRes = 1.0;
	// 	{"}10.24V", "}5.12V", "}2.56V", "}1.28V", "}0.64V", "0`10.24V", "0`5.12V", "0`2.56V", "0`1.28V"};
	switch( Range )
	{
	case 0: dbRes = 20.48/4095.0;		break;
	case 1: dbRes = 10.24/4095.0;		break;
	case 2: dbRes =  5.12/4095.0;		break;
	case 3: dbRes =  2.56/4095.0;		break;
	case 4: dbRes =  1.28/4095.0;		break;
	case 5: dbRes = 10.24/4095.0;		break;
	case 6: dbRes =  5.12/4095.0;		break;
	case 7: dbRes =  2.56/4095.0;		break;
	case 8: dbRes =  1.28/4095.0;		break;
	}

	dbData = 0.0;
	switch( Range )
	{
	case 0: dbData = -10.24 + dbRes*wData;		break;
	case 1: dbData =  -5.12 + dbRes*wData;		break;
	case 2: dbData =  -2.56 + dbRes*wData;		break;
	case 3: dbData =  -1.28 + dbRes*wData;		break;
	case 4: dbData =  -0.64 + dbRes*wData;		break;
	case 5: dbData = dbRes*wData;		break;
	case 6: dbData = dbRes*wData;		break;
	case 7: dbData = dbRes*wData;		break;
	case 8: dbData = dbRes*wData;		break;
	}

	return dbData;
}

VOID CALLBACK TimerDataCallBackFunc( BYTE* pData )
{
	char MsgBuf[256];

	sprintf_s( MsgBuf, sizeof(MsgBuf), "[%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X] TimerDataCallBackFunc\r\n[%.2f][%.2f][%.2f][%.2f][%.2f][%.2f][%.2f][%.2f]", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7], GetdbValue( 0, pData[8]*256+pData[9] ), GetdbValue( 1, pData[10]*256+pData[11] ), GetdbValue( 2, pData[12]*256+pData[13] ), GetdbValue( 3, pData[14]*256+pData[15] ), GetdbValue( 4, pData[16]*256+pData[17] ), GetdbValue( 5, pData[18]*256+pData[19] ), GetdbValue( 6, pData[20]*256+pData[21] ), GetdbValue( 7, pData[22]*256+pData[23] ) );
	SetDlgItemText( hwnd, IDE_MSG, MsgBuf );
	Sleep(500);
}
VOID CALLBACK AlarmCallBackFunc( PUCHAR pData )
{
	char MsgBuf[256];
	OPENFILENAME	ofn; // R_CAO{bNXp̍\
	char			szDirName[MAX_PATH]; // fBNg
	char			szFile[MAX_PATH]; // t@C
	char			szFileTitle[MAX_PATH]; // t@C^Cg
	HANDLE	hFile;
	DWORD	nBytesWrite;
	SYSTEMTIME		SystemTime; // VXe
	WORD	iii;

	sprintf_s( MsgBuf, sizeof(MsgBuf), "[%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X] AlarmCallBackFunc", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7] );
	SetDlgItemText( hwnd, IDE_MSG, MsgBuf );



	GetCurrentDirectory( sizeof(szDirName), (LPTSTR)szDirName );
	// ̧ٖ
	memset( szFile,0x00,sizeof( szFile ) );
    // ݂̓t擾
    GetLocalTime(&SystemTime);
    // ͂߂ɕ\t@Cݒ
    sprintf_s(szFile, sizeof(szFile), "%d%02d%02d_%02d%02d%02d.csv", SystemTime.wYear, SystemTime.wMonth, SystemTime.wDay, SystemTime.wHour, SystemTime.wMinute, SystemTime.wSecond  );

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwnd;
    ofn.hInstance = NULL;
	ofn.lpstrFilter = "All files{*.*}\0*.*\0""CSV files{*.csv}\0*.csv\0\0";
	ofn.lpstrCustomFilter = (LPSTR)NULL;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
    ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = sizeof(szFileTitle);
	ofn.lpstrInitialDir = szDirName;
	ofn.lpstrTitle = (LPSTR)NULL;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_OVERWRITEPROMPT;
	ofn.nFileOffset = (UINT)NULL;
    ofn.nFileExtension = (UINT)NULL;
	ofn.lpstrDefExt = "csv";
	ofn.lCustData = 0L;
	ofn.lpfnHook = (LPOFNHOOKPROC)NULL;
	ofn.lpTemplateName = (LPSTR)NULL;

	hFile = CreateFileA( ofn.lpstrFile,
							GENERIC_WRITE,
							0,
							(LPSECURITY_ATTRIBUTES)NULL,
							OPEN_ALWAYS,
							FILE_ATTRIBUTE_NORMAL,
							(HANDLE)NULL );

	// MACAhX/gK[`l(bit\)/
	memset(MsgBuf, 0x00, sizeof(MsgBuf));
	sprintf_s( MsgBuf, sizeof(MsgBuf), "[%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X],0x%02X,%d\r\n", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7], pData[9], pData[10] );
	WriteFile( hFile, MsgBuf, strlen(MsgBuf), &nBytesWrite, NULL );
	//wb_
	memset(MsgBuf, 0x00, sizeof(MsgBuf));
	sprintf_s( MsgBuf, sizeof(MsgBuf), "CH0,CH1,CH2,CH3,CH4,CH5,CH6,CH7\r\n" );
	WriteFile( hFile, MsgBuf, strlen(MsgBuf), &nBytesWrite, NULL );
	// f[^
	for( iii = 0; iii < 800; iii+=16 )
	{
		memset(MsgBuf, 0x00, sizeof(MsgBuf));
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f\r\n", GetdbValue( 0, pData[16+iii+0]*256+pData[16+iii+1] ), GetdbValue( 1, pData[16+iii+2]*256+pData[16+iii+3] ), GetdbValue( 2, pData[16+iii+4]*256+pData[16+iii+5] ), GetdbValue( 3, pData[16+iii+6]*256+pData[16+iii+7] ), GetdbValue( 4, pData[16+iii+8]*256+pData[16+iii+9] ), GetdbValue( 5, pData[16+iii+10]*256+pData[16+iii+11] ), GetdbValue( 6, pData[16+iii+12]*256+pData[16+iii+13] ), GetdbValue( 7, pData[16+iii+14]*256+pData[16+iii+15] ) );
		WriteFile( hFile, MsgBuf, strlen(MsgBuf), &nBytesWrite, NULL );
	}

	// t@CN[Y
	CloseHandle( hFile );
}
VOID CALLBACK ErrorCallBackFunc( PUCHAR pData )
{
	char MsgBuf[256];

	sprintf_s( MsgBuf, sizeof(MsgBuf), "[%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X] ErrorCallBackFunc[%02X]", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7], pData[8] );
	SetDlgItemText( hwnd, IDE_MSG, MsgBuf );
}
VOID CALLBACK RegistCallBackFunc( PUCHAR pData )
{
	char MsgBuf[256];
	UCHAR MacAdrsBuf[8];
	HWND hCombo;

	sprintf_s( MsgBuf, sizeof(MsgBuf), "[%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X] RegistCallBackFunc", pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7] );
	SetDlgItemText( hwnd, IDE_MSG, MsgBuf );

	// MACAhX
	MacAdrsBuf[0] = pData[0];	MacAdrsBuf[1] = pData[1];	MacAdrsBuf[2] = pData[2];	MacAdrsBuf[3] = pData[3];
	MacAdrsBuf[4] = pData[4];	MacAdrsBuf[5] = pData[5];	MacAdrsBuf[6] = pData[6];	MacAdrsBuf[7] = pData[7];
	// o^
	RSSG2000RegistMacAdrs( hComPort, MacAdrsBuf );

	memset( MsgBuf, 0x00, sizeof(MsgBuf) );
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X", MacAdrsBuf[0], MacAdrsBuf[1], MacAdrsBuf[2], MacAdrsBuf[3], MacAdrsBuf[4], MacAdrsBuf[5], MacAdrsBuf[6], MacAdrsBuf[7] );
	// R{{bNXǉ
	hCombo = GetDlgItem(hwnd, IDC_MACADRS);
	SendMessage(hCombo, CB_ADDSTRING, 0, (LPARAM)MsgBuf);
	SendMessage(hCombo, CB_SETCURSEL, 0, 0);
}



CRSSG2040Dlg::CRSSG2040Dlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CRSSG2040Dlg::IDD, pParent)
	, m_StrDioIn(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_Channel = 0;
	m_Com = 0;
	m_SG20Count = 0;
	m_StrCh1 = _T("");
	m_StrSampling = _T("");
	m_StrTrigger = _T("");
	m_StrMsg = _T("");
	m_StrVersion = _T("");
	m_StrRSSI = _T("");
	m_StrHumidity = _T("");
	m_StrTemp = _T("");
}

void CRSSG2040Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDB_START, m_BtnStart);
	DDX_Control(pDX, IDB_STOP, m_BtnStop);
	DDX_Text(pDX, IDE_CHANNEL, m_Channel);
	DDX_Text(pDX, IDE_COM, m_Com);
	DDX_Control(pDX, IDC_MACADRS, m_CmbMacAdrs);
	DDX_Control(pDX, IDB_GP40START, m_BtnGP40Start);
	DDX_Text(pDX, IDE_SG20COUNT, m_SG20Count);
	DDX_Control(pDX, IDB_GP40STOP, m_BtnGP40Stop);
	DDX_Control(pDX, IDB_CLEAR, m_BtnClear);
	DDX_Control(pDX, IDB_DIOIN, m_BtnDIOIn);
	DDX_Control(pDX, IDB_DIOHIGHOUT, m_BtnDIOHighOut);
	DDX_Control(pDX, IDB_DIOLOWOUT, m_BtnDIOLowOut);
	DDX_Control(pDX, IDB_GET_SETTING, m_BtnGetSetting);
	DDX_Control(pDX, IDB_SET_SETTING, m_BtnSetSetting);
	DDX_Control(pDX, IDB_GET_START, m_BtnGetStart);
	DDX_Control(pDX, IDB_GET_STOP, m_BtnGetStop);
	DDX_Control(pDX, IDB_ONESHOT, m_BtnOneShot);
	DDX_Control(pDX, IDC_ALARM, m_ChkAlarm);
	DDX_Control(pDX, IDC_CH0, m_ChkCH0);
	DDX_Control(pDX, IDC_CH1, m_ChkCH1);
	DDX_Control(pDX, IDC_CH2, m_ChkCH2);
	DDX_Control(pDX, IDC_CH3, m_ChkCH3);
	DDX_Control(pDX, IDC_CH4, m_ChkCH4);
	DDX_Control(pDX, IDC_CH5, m_ChkCH5);
	DDX_Control(pDX, IDC_CH6, m_ChkCH6);
	DDX_Control(pDX, IDC_CH7, m_ChkCH7);
	DDX_Control(pDX, IDCB_CH0, m_CmbCH0);
	DDX_Control(pDX, IDCB_CH1, m_CmbCH1);
	DDX_Control(pDX, IDCB_CH2, m_CmbCH2);
	DDX_Control(pDX, IDCB_CH3, m_CmbCH3);
	DDX_Control(pDX, IDCB_CH4, m_CmbCH4);
	DDX_Control(pDX, IDCB_CH5, m_CmbCH5);
	DDX_Control(pDX, IDCB_CH6, m_CmbCH6);
	DDX_Control(pDX, IDCB_CH7, m_CmbCH7);
	DDX_Text(pDX, IDE_CH0, m_StrCh0);
	DDX_Text(pDX, IDE_CH1, m_StrCh1);
	DDX_Text(pDX, IDE_CH2, m_StrCh2);
	DDX_Text(pDX, IDE_CH3, m_StrCh3);
	DDX_Text(pDX, IDE_CH4, m_StrCh4);
	DDX_Text(pDX, IDE_CH5, m_StrCh5);
	DDX_Text(pDX, IDE_CH6, m_StrCh6);
	DDX_Text(pDX, IDE_CH7, m_StrCh7);
	DDX_Text(pDX, IDE_LOWER_CH0, m_StrLowerCh0);
	DDX_Text(pDX, IDE_LOWER_CH1, m_StrLowerCh1);
	DDX_Text(pDX, IDE_LOWER_CH2, m_StrLowerCh2);
	DDX_Text(pDX, IDE_LOWER_CH3, m_StrLowerCh3);
	DDX_Text(pDX, IDE_LOWER_CH4, m_StrLowerCh4);
	DDX_Text(pDX, IDE_LOWER_CH5, m_StrLowerCh5);
	DDX_Text(pDX, IDE_LOWER_CH6, m_StrLowerCh6);
	DDX_Text(pDX, IDE_LOWER_CH7, m_StrLowerCh7);
	DDX_Text(pDX, IDE_UPPER_CH0, m_StrUpperCh0);
	DDX_Text(pDX, IDE_UPPER_CH1, m_StrUpperCh1);
	DDX_Text(pDX, IDE_UPPER_CH2, m_StrUpperCh2);
	DDX_Text(pDX, IDE_UPPER_CH3, m_StrUpperCh3);
	DDX_Text(pDX, IDE_UPPER_CH4, m_StrUpperCh4);
	DDX_Text(pDX, IDE_UPPER_CH5, m_StrUpperCh5);
	DDX_Text(pDX, IDE_UPPER_CH6, m_StrUpperCh6);
	DDX_Text(pDX, IDE_UPPER_CH7, m_StrUpperCh7);
	DDX_Text(pDX, IDE_SAMPLING, m_StrSampling);
	DDX_Text(pDX, IDE_TRIGGER, m_StrTrigger);
	DDX_Text(pDX, IDE_MSG, m_StrMsg);
	DDX_Text(pDX, IDE_VERSION, m_StrVersion);
	DDX_Control(pDX, IDB_GET, m_BtnGet);
	DDX_Text(pDX, IDE_RSSI, m_StrRSSI);
	DDX_Text(pDX, IDE_HUMIDITY, m_StrHumidity);
	DDX_Text(pDX, IDE_TEMP, m_StrTemp);
	DDX_Text(pDX, IDE_DIOIN, m_StrDioIn);
}

BEGIN_MESSAGE_MAP(CRSSG2040Dlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDB_START, &CRSSG2040Dlg::OnBnClickedStart)
	ON_BN_CLICKED(IDB_STOP, &CRSSG2040Dlg::OnBnClickedStop)
	ON_BN_CLICKED(IDB_GP40START, &CRSSG2040Dlg::OnBnClickedGP40Start)
	ON_BN_CLICKED(IDB_GP40STOP, &CRSSG2040Dlg::OnBnClickedGP40Stop)
	ON_BN_CLICKED(IDB_CLEAR, &CRSSG2040Dlg::OnBnClickedClear)
	ON_BN_CLICKED(IDB_GET_SETTING, &CRSSG2040Dlg::OnBnClickedGetSetting)
	ON_BN_CLICKED(IDB_SET_SETTING, &CRSSG2040Dlg::OnBnClickedSetSetting)
	ON_BN_CLICKED(IDB_ONESHOT, &CRSSG2040Dlg::OnBnClickedOneshot)
	ON_BN_CLICKED(IDB_GET_START, &CRSSG2040Dlg::OnBnClickedGetStart)
	ON_BN_CLICKED(IDB_GET_STOP, &CRSSG2040Dlg::OnBnClickedGetStop)
	ON_BN_CLICKED(IDB_DIOIN, &CRSSG2040Dlg::OnBnClickedDioin)
	ON_BN_CLICKED(IDCANCEL, &CRSSG2040Dlg::OnBnClickedCancel)
	ON_CBN_SELCHANGE(IDC_MACADRS, &CRSSG2040Dlg::OnCbnSelchangeMacadrs)
	ON_BN_CLICKED(IDB_GET, &CRSSG2040Dlg::OnBnClickedGet)
	ON_BN_CLICKED(IDB_DIOLOWOUT, &CRSSG2040Dlg::OnBnClickedDiolowout)
	ON_BN_CLICKED(IDB_DIOHIGHOUT, &CRSSG2040Dlg::OnBnClickedDiohighout)
END_MESSAGE_MAP()


// CRSSG2040Dlg bZ[W nh[

BOOL CRSSG2040Dlg::OnInitDialog()
{
	UCHAR	iii;
	//CString	RangeBuf[10] = {"}10.24V", "}5.12V", "}2.56V", "}1.28V", "}0.64V", "0`10.24V", "0`5.12V", "0`2.56V", "0`1.28V"};
	CString	RangeBuf[10] = {"}10V", "}5V", "}2.5V", "}1V", "}0.5V", "0`10V", "0`5V", "0`2.5V", "0`1V"};
	CDialogEx::OnInitDialog();

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B
	hwnd = m_hWnd;
	// COM|[gԍ
	m_Com = 16;
	// `l
	m_Channel = 4;
	// 䐔
	m_SG20Count = 1;

	// JntO
	for( iii = 0; iii < MaxCount; iii++ )
		fGP40Start[iii] = FALSE;
	fStart = FALSE;

	// TvOݒ
	m_ChkCH0.SetCheck(TRUE);
	m_ChkCH1.SetCheck(TRUE);
	m_ChkCH2.SetCheck(TRUE);
	m_ChkCH3.SetCheck(TRUE);
	m_ChkCH4.SetCheck(TRUE);
	m_ChkCH5.SetCheck(TRUE);
	m_ChkCH6.SetCheck(TRUE);
	m_ChkCH7.SetCheck(TRUE);

	// Rangeݒ
	for( iii = 0; iii < 9; iii++ )
	{
		// R{{bNXǉ
		m_CmbCH0.AddString( RangeBuf[iii] );
		m_CmbCH1.AddString( RangeBuf[iii] );
		m_CmbCH2.AddString( RangeBuf[iii] );
		m_CmbCH3.AddString( RangeBuf[iii] );
		m_CmbCH4.AddString( RangeBuf[iii] );
		m_CmbCH5.AddString( RangeBuf[iii] );
		m_CmbCH6.AddString( RangeBuf[iii] );
		m_CmbCH7.AddString( RangeBuf[iii] );
	}
	m_CmbCH0.SetCurSel( 0 );
	m_CmbCH1.SetCurSel( 0 );
	m_CmbCH2.SetCurSel( 0 );
	m_CmbCH3.SetCurSel( 0 );
	m_CmbCH4.SetCurSel( 0 );
	m_CmbCH5.SetCurSel( 0 );
	m_CmbCH6.SetCurSel( 0 );
	m_CmbCH7.SetCurSel( 0 );

    // 臒lݒ
    m_StrLowerCh0 = "-10.24";
    m_StrLowerCh1 = "-10.24";
    m_StrLowerCh2 = "-10.24";
    m_StrLowerCh3 = "-10.24";
    m_StrLowerCh4 = "-10.24";
    m_StrLowerCh5 = "-10.24";
    m_StrLowerCh6 = "-10.24";
    m_StrLowerCh7 = "-10.24";
    m_StrUpperCh0 = "10.24";
    m_StrUpperCh1 = "10.24";
    m_StrUpperCh2 = "10.24";
    m_StrUpperCh3 = "10.24";
    m_StrUpperCh4 = "10.24";
    m_StrUpperCh5 = "10.24";
    m_StrUpperCh6 = "10.24";
    m_StrUpperCh7 = "10.24";
    // TvOԊu
    m_StrSampling = "100";
    // gK|Cg
    m_StrTrigger = "25";
	m_StrMsg = "";

	// 
	m_BtnStop.EnableWindow( FALSE );
	m_BtnGP40Start.EnableWindow( FALSE );
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );
	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CRSSG2040Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CRSSG2040Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CRSSG2040Dlg::OnBnClickedClear()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	// bZ[W폜
	m_StrMsg = "";
	m_BtnClear.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2040Dlg::OnBnClickedStart()
{
	BYTE	iii;
	char	MacBuf[32];
	BYTE	Count = 0;
	UCHAR	Version[8];
	CHAR	RSSI;
	double	Temp, Humidity;

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	if( !UpdateData( TRUE ) )
		return;
	if( ( m_Com < 1 ) || ( m_Com > 255 ) )
	{
		MessageBox( "1-255COM|[gԍw肵Ă", "", MB_OK );
		return;
	}
	if( ( m_Channel < 4 ) || ( m_Channel > 17 ) )
	{
		MessageBox( "4-17̃`lw肵Ă", "", MB_OK );
		return;
	}
	if( ( m_SG20Count < 1 ) || ( m_SG20Count > 17 ) )
	{
		MessageBox( "1-17̑䐔w肵Ă", "", MB_OK );
		return;
	}

	m_StrMsg = "Jn...";
	UpdateData( FALSE );
	UpdateWindow(); 

	ZeroMemory( MacAdrs, MaxCount*8 );
	// I[v
	hCom = RSSG2000Open( m_Com, m_Channel, m_SG20Count, RegistCallBackFunc );
	if( hCom != INVALID_HANDLE_VALUE )
	{
		hComPort = hCom;
		ZeroMemory( MacAdrs, sizeof(MacAdrs) );
		// AhX擾
		RSSG2000GetMacAdrs( hCom, MacAdrs );
		// \
		for( iii = 0; iii < MaxCount*8; iii+=8  )
		{
			if( ( MacAdrs[iii+0] == 0x00 ) && ( MacAdrs[iii+1] == 0x00 ) && ( MacAdrs[iii+2] == 0x00 ) && ( MacAdrs[iii+3] == 0x00 ) && ( MacAdrs[iii+4] == 0x00 ) && ( MacAdrs[iii+5] == 0x00 ) && ( MacAdrs[iii+6] == 0x00 ) && ( MacAdrs[iii+7] == 0x00 ) )
				;
			else
			{
				// o^
				RSSG2000RegistMacAdrs( hCom, (PUCHAR)(MacAdrs + iii) );
				// 
				m_BtnStart.EnableWindow( FALSE );
				// L
				m_BtnStop.EnableWindow( TRUE );

				sprintf_s( MacBuf, sizeof(MacBuf), "%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X", MacAdrs[iii+0], MacAdrs[iii+1], MacAdrs[iii+2], MacAdrs[iii+3], MacAdrs[iii+4], MacAdrs[iii+5], MacAdrs[iii+6], MacAdrs[iii+7] );
				// R{{bNXǉ
				m_CmbMacAdrs.AddString( MacBuf );

				CmbMacAdrsBuf[0] = MacAdrs[iii+0];
				CmbMacAdrsBuf[1] = MacAdrs[iii+1];
				CmbMacAdrsBuf[2] = MacAdrs[iii+2];
				CmbMacAdrsBuf[3] = MacAdrs[iii+3];
				CmbMacAdrsBuf[4] = MacAdrs[iii+4];
				CmbMacAdrsBuf[5] = MacAdrs[iii+5];
				CmbMacAdrsBuf[6] = MacAdrs[iii+6];
				CmbMacAdrsBuf[7] = MacAdrs[iii+7];

				m_CmbMacAdrs.SetCurSel( Count );
				Count++;
			}
		}
		if( Count != 0 )
		{
			CmbMacAdrsBuf[0] = MacAdrs[0];
			CmbMacAdrsBuf[1] = MacAdrs[1];
			CmbMacAdrsBuf[2] = MacAdrs[2];
			CmbMacAdrsBuf[3] = MacAdrs[3];
			CmbMacAdrsBuf[4] = MacAdrs[4];
			CmbMacAdrsBuf[5] = MacAdrs[5];
			CmbMacAdrsBuf[6] = MacAdrs[6];
			CmbMacAdrsBuf[7] = MacAdrs[7];
			m_CmbMacAdrs.SetCurSel( 0 );

			// Jn
			RSSG2000Start( hCom );

			Sleep(500);
			// o[W擾
			RSSG2000GetVersion( hCom, CmbMacAdrsBuf, Version );
			m_StrVersion.Format( "%x.%02x", Version[0], Version[1] );
			// RSSI擾
			RSSG2000GetRSSI( hCom, CmbMacAdrsBuf, &RSSI );
			m_StrRSSI.Format( "%d", RSSI );
			// x擾
			RSSG2000GetTemp( hCom, CmbMacAdrsBuf, &Temp, &Humidity );
			m_StrTemp.Format( "%.2f", Temp );
			m_StrHumidity.Format( "%.2f", Humidity );

			// L
			m_BtnGP40Start.EnableWindow( TRUE );
			m_BtnGet.EnableWindow( TRUE );

			// ǂݎp
			( (CEdit*)GetDlgItem( IDE_COM ) )->SetReadOnly(TRUE);
			( (CEdit*)GetDlgItem( IDE_CHANNEL ) )->SetReadOnly(TRUE);
			( (CEdit*)GetDlgItem( IDE_SG20COUNT ) )->SetReadOnly(TRUE);
			fStart = TRUE;
			UpdateData( FALSE );

			if( Count != m_SG20Count )
			{
				MessageBox( "w䐔SubGigao̓x[X{[h܂", "", MB_OK );
			}
		}
		else
		{
			// N[Y
			RSSG2000Close( hCom );
			hCom = INVALID_HANDLE_VALUE;
			MessageBox( "SubGigao̓x[X{[h܂", "", MB_OK );
		}
	}
	else
	{
		MessageBox( "COMI[vG[", "", MB_OK );
	}
	m_StrMsg = "";
	m_BtnStart.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2040Dlg::OnBnClickedStop()
{
	BYTE	iii;

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	m_StrMsg = "~...";
	UpdateData( FALSE );
	UpdateWindow(); 

	if( fStart )
	{
		// ~
		RSSG2000Stop( hCom );

		for( iii = 0; iii < MaxCount*8; iii+=8  )
		{
			if( ( MacAdrs[iii+0] == 0x00 ) && ( MacAdrs[iii+1] == 0x00 ) && ( MacAdrs[iii+2] == 0x00 ) && ( MacAdrs[iii+3] == 0x00 ) && ( MacAdrs[iii+4] == 0x00 ) && ( MacAdrs[iii+5] == 0x00 ) && ( MacAdrs[iii+6] == 0x00 ) && ( MacAdrs[iii+7] == 0x00 ) )
				;
			else
			{
				// 폜
				RSSG2000DeleteMacAdrs( hCom, (PUCHAR)(MacAdrs+iii) );
			}
		}

		// N[Y
		RSSG2000Close( hCom );
		hCom = INVALID_HANDLE_VALUE;
	}

	// JntO
	for( iii = 0; iii < MaxCount; iii++ )
		fGP40Start[iii] = FALSE;
	fStart = FALSE;

	// L
	m_BtnStart.EnableWindow( TRUE );
	// 
	m_BtnStop.EnableWindow( FALSE );
	m_BtnGP40Start.EnableWindow( FALSE );
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	
	// R{{bNX폜
	m_CmbMacAdrs.ResetContent();
	m_StrMsg = "";
	m_StrVersion = "";
	m_StrRSSI = "";
	m_StrTemp = "";
	m_StrHumidity = "";

	// ǂݎp
	( (CEdit*)GetDlgItem( IDE_COM ) )->SetReadOnly(FALSE);
	( (CEdit*)GetDlgItem( IDE_CHANNEL ) )->SetReadOnly(FALSE);
	( (CEdit*)GetDlgItem( IDE_SG20COUNT ) )->SetReadOnly(FALSE);

	m_BtnStop.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2040Dlg::OnBnClickedGP40Start()
{
	DWORD	Status;
	char	MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	m_StrMsg = "Jn...";
	UpdateData( FALSE );
	UpdateWindow(); 

	// I[v
	Status = RPiGP40Open( hCom, CmbMacAdrsBuf, TimerDataCallBackFunc, AlarmCallBackFunc, ErrorCallBackFunc );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP40Open G[ [%X]", Status );
		m_StrMsg = MsgBuf;
		return;
	}

	// 
	m_BtnGP40Start.EnableWindow( FALSE );
	// L
	m_BtnGP40Stop.EnableWindow( TRUE );
	m_BtnDIOIn.EnableWindow( TRUE );
	m_BtnDIOHighOut.EnableWindow( TRUE );
	m_BtnDIOLowOut.EnableWindow( TRUE );
	m_BtnGetSetting.EnableWindow( TRUE );
	m_BtnSetSetting.EnableWindow( TRUE );
	m_BtnGetStart.EnableWindow( TRUE );
	m_BtnGetStop.EnableWindow( TRUE );
	m_BtnOneShot.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_StrMsg = "";

	// JntO
	fGP40Start[m_CmbMacAdrs.GetCurSel()] = TRUE;
	m_BtnGP40Start.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2040Dlg::OnBnClickedGP40Stop()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	m_StrMsg = "~...";
	UpdateData( FALSE );
	UpdateWindow(); 

	// JntO
	fGP40Start[m_CmbMacAdrs.GetCurSel()] = FALSE;

	// GP40N[Y
	RPiGP40Close( hCom, CmbMacAdrsBuf );
	m_StrMsg = "";

	// L
	m_BtnGP40Start.EnableWindow( TRUE );
	// L
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGP40Stop.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2040Dlg::OnBnClickedGet()
{
	DWORD	Status;
	UCHAR Version[8];
	CHAR	RSSI;
	double	Temp, Humidity;
	char	MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	// 
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	m_BtnGet.SetFocus();
	UpdateData( FALSE );

	// o[W擾
	Status = RSSG2000GetVersion( hCom, CmbMacAdrsBuf, Version );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RSSG2000GetVersion G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		m_StrVersion.Format( "%x.%02x", Version[0], Version[1] );
	}

	// RSSI擾
	Status = RSSG2000GetRSSI( hCom, CmbMacAdrsBuf, &RSSI );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RSSG2000GetRSSI G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%d", RSSI );
		m_StrRSSI = MsgBuf;
	}

	// x擾
	Status = RSSG2000GetTemp( hCom, CmbMacAdrsBuf, &Temp, &Humidity );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RSSG2000GetTemp G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", Temp );
		m_StrTemp = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", Humidity );
		m_StrHumidity = MsgBuf;
	}

	// JntO
	if( fGP40Start[m_CmbMacAdrs.GetCurSel()] )
	{
		// 
		m_BtnGP40Start.EnableWindow( FALSE );
		// L
		m_BtnGP40Stop.EnableWindow( TRUE );
		m_BtnDIOIn.EnableWindow( TRUE );
		m_BtnDIOHighOut.EnableWindow( TRUE );
		m_BtnDIOLowOut.EnableWindow( TRUE );
		m_BtnGetSetting.EnableWindow( TRUE );
		m_BtnSetSetting.EnableWindow( TRUE );
		m_BtnGetStart.EnableWindow( TRUE );
		m_BtnGetStop.EnableWindow( TRUE );
		m_BtnOneShot.EnableWindow( TRUE );
	}
	else
	{
		// L
		m_BtnGP40Start.EnableWindow( TRUE );
		// L
		m_BtnGP40Stop.EnableWindow( FALSE );
		m_BtnDIOIn.EnableWindow( FALSE );
		m_BtnDIOHighOut.EnableWindow( FALSE );
		m_BtnDIOLowOut.EnableWindow( FALSE );
		m_BtnGetSetting.EnableWindow( FALSE );
		m_BtnSetSetting.EnableWindow( FALSE );
		m_BtnGetStart.EnableWindow( FALSE );
		m_BtnGetStop.EnableWindow( FALSE );
		m_BtnOneShot.EnableWindow( FALSE );
	}
	m_BtnGet.EnableWindow( TRUE );
	UpdateData( FALSE );
}

void CRSSG2040Dlg::OnBnClickedGetSetting()
{
	DWORD	Status;
	GP40Setting GettingData40;
	char	MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	// 
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// ݒǍ
	Status = RPiGP40GetSetting( hCom, CmbMacAdrsBuf, &GettingData40 );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP40GetSetting G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		// TvO̗L
		m_ChkCH0.SetCheck(FALSE);
		if( GettingData40.ChannelEnable & 0x01 )
			m_ChkCH0.SetCheck(TRUE);
		m_ChkCH1.SetCheck(FALSE);
		if( GettingData40.ChannelEnable & 0x02 )
			m_ChkCH1.SetCheck(TRUE);
		m_ChkCH2.SetCheck(FALSE);
		if( GettingData40.ChannelEnable & 0x04 )
			m_ChkCH2.SetCheck(TRUE);
		m_ChkCH3.SetCheck(FALSE);
		if( GettingData40.ChannelEnable & 0x08 )
			m_ChkCH3.SetCheck(TRUE);
		m_ChkCH4.SetCheck(FALSE);
		if( GettingData40.ChannelEnable & 0x10 )
			m_ChkCH4.SetCheck(TRUE);
		m_ChkCH5.SetCheck(FALSE);
		if( GettingData40.ChannelEnable & 0x20 )
			m_ChkCH5.SetCheck(TRUE);
		m_ChkCH6.SetCheck(FALSE);
		if( GettingData40.ChannelEnable & 0x40 )
			m_ChkCH6.SetCheck(TRUE);
		m_ChkCH7.SetCheck(FALSE);
		if( GettingData40.ChannelEnable & 0x80 )
			m_ChkCH7.SetCheck(TRUE);

		// A[ʒm
		m_ChkAlarm.SetCheck( FALSE );
		if( GettingData40.AlarmEnable == 0x10 )
			m_ChkAlarm.SetCheck(TRUE);

		// TvOԊu
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%d", GettingData40.SampTime );
		m_StrSampling = MsgBuf;

		// gK|Cg
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%d", GettingData40.Trigger );
		m_StrTrigger = MsgBuf;

		// W(CH0)
		if( ( GettingData40.ChannelRange & 0x0000000F ) == 0x00 )
			m_CmbCH0.SetCurSel(0);
		if( ( GettingData40.ChannelRange & 0x0000000F ) == 0x01 )
			m_CmbCH0.SetCurSel(1);
		if( ( GettingData40.ChannelRange & 0x0000000F ) == 0x02 )
			m_CmbCH0.SetCurSel(2);
		if( ( GettingData40.ChannelRange & 0x0000000F ) == 0x03 )
			m_CmbCH0.SetCurSel(3);
		if( ( GettingData40.ChannelRange & 0x0000000F ) == 0x0B )
			m_CmbCH0.SetCurSel(4);
		if( ( GettingData40.ChannelRange & 0x0000000F ) == 0x05 )
			m_CmbCH0.SetCurSel(5);
		if( ( GettingData40.ChannelRange & 0x0000000F ) == 0x06 )
			m_CmbCH0.SetCurSel(6);
		if( ( GettingData40.ChannelRange & 0x0000000F ) == 0x07 )
			m_CmbCH0.SetCurSel(7);
		if( ( GettingData40.ChannelRange & 0x0000000F ) == 0x0F )
			m_CmbCH0.SetCurSel(8);
		// W(CH1)
		if( ( GettingData40.ChannelRange & 0x000000F0 ) >> 4 == 0x00 )
			m_CmbCH1.SetCurSel(0);
		if( ( GettingData40.ChannelRange & 0x000000F0 ) >> 4 == 0x01 )
			m_CmbCH1.SetCurSel(1);
		if( ( GettingData40.ChannelRange & 0x000000F0 ) >> 4 == 0x02 )
			m_CmbCH1.SetCurSel(2);
		if( ( GettingData40.ChannelRange & 0x000000F0 ) >> 4 == 0x03 )
			m_CmbCH1.SetCurSel(3);
		if( ( GettingData40.ChannelRange & 0x000000F0 ) >> 4 == 0x0B )
			m_CmbCH1.SetCurSel(4);
		if( ( GettingData40.ChannelRange & 0x000000F0 ) >> 4 == 0x05 )
			m_CmbCH1.SetCurSel(5);
		if( ( GettingData40.ChannelRange & 0x000000F0 ) >> 4 == 0x06 )
			m_CmbCH1.SetCurSel(6);
		if( ( GettingData40.ChannelRange & 0x000000F0 ) >> 4 == 0x07 )
			m_CmbCH1.SetCurSel(7);
		if( ( GettingData40.ChannelRange & 0x000000F0 ) >> 4 == 0x0F )
			m_CmbCH1.SetCurSel(8);
		// W(CH2)
		if( ( GettingData40.ChannelRange & 0x00000F00 ) >> 8 == 0x00 )
			m_CmbCH2.SetCurSel(0);
		if( ( GettingData40.ChannelRange & 0x00000F00 ) >> 8 == 0x01 )
			m_CmbCH2.SetCurSel(1);
		if( ( GettingData40.ChannelRange & 0x00000F00 ) >> 8 == 0x02 )
			m_CmbCH2.SetCurSel(2);
		if( ( GettingData40.ChannelRange & 0x00000F00 ) >> 8 == 0x03 )
			m_CmbCH2.SetCurSel(3);
		if( ( GettingData40.ChannelRange & 0x00000F00 ) >> 8 == 0x0B )
			m_CmbCH2.SetCurSel(4);
		if( ( GettingData40.ChannelRange & 0x00000F00 ) >> 8 == 0x05 )
			m_CmbCH2.SetCurSel(5);
		if( ( GettingData40.ChannelRange & 0x00000F00 ) >> 8 == 0x06 )
			m_CmbCH2.SetCurSel(6);
		if( ( GettingData40.ChannelRange & 0x00000F00 ) >> 8 == 0x07 )
			m_CmbCH2.SetCurSel(7);
		if( ( GettingData40.ChannelRange & 0x00000F00 ) >> 8 == 0x0F )
			m_CmbCH2.SetCurSel(8);
		// W(CH3)
		if( ( GettingData40.ChannelRange & 0x0000F000 ) >> 12 == 0x00 )
			m_CmbCH3.SetCurSel(0);
		if( ( GettingData40.ChannelRange & 0x0000F000 ) >> 12 == 0x01 )
			m_CmbCH3.SetCurSel(1);
		if( ( GettingData40.ChannelRange & 0x0000F000 ) >> 12 == 0x02 )
			m_CmbCH3.SetCurSel(2);
		if( ( GettingData40.ChannelRange & 0x0000F000 ) >> 12 == 0x03 )
			m_CmbCH3.SetCurSel(3);
		if( ( GettingData40.ChannelRange & 0x0000F000 ) >> 12 == 0x0B )
			m_CmbCH3.SetCurSel(4);
		if( ( GettingData40.ChannelRange & 0x0000F000 ) >> 12 == 0x05 )
			m_CmbCH3.SetCurSel(5);
		if( ( GettingData40.ChannelRange & 0x0000F000 ) >> 12 == 0x06 )
			m_CmbCH3.SetCurSel(6);
		if( ( GettingData40.ChannelRange & 0x0000F000 ) >> 12 == 0x07 )
			m_CmbCH3.SetCurSel(7);
		if( ( GettingData40.ChannelRange & 0x0000F000 ) >> 12 == 0x0F )
			m_CmbCH3.SetCurSel(8);
		// W(CH4)
		if( ( GettingData40.ChannelRange & 0x000F0000 ) >> 16 == 0x00 )
			m_CmbCH4.SetCurSel(0);
		if( ( GettingData40.ChannelRange & 0x000F0000 ) >> 16 == 0x01 )
			m_CmbCH4.SetCurSel(1);
		if( ( GettingData40.ChannelRange & 0x000F0000 ) >> 16 == 0x02 )
			m_CmbCH4.SetCurSel(2);
		if( ( GettingData40.ChannelRange & 0x000F0000 ) >> 16 == 0x03 )
			m_CmbCH4.SetCurSel(3);
		if( ( GettingData40.ChannelRange & 0x000F0000 ) >> 16 == 0x0B )
			m_CmbCH4.SetCurSel(4);
		if( ( GettingData40.ChannelRange & 0x000F0000 ) >> 16 == 0x05 )
			m_CmbCH4.SetCurSel(5);
		if( ( GettingData40.ChannelRange & 0x000F0000 ) >> 16 == 0x06 )
			m_CmbCH4.SetCurSel(6);
		if( ( GettingData40.ChannelRange & 0x000F0000 ) >> 16 == 0x07 )
			m_CmbCH4.SetCurSel(7);
		if( ( GettingData40.ChannelRange & 0x000F0000 ) >> 16 == 0x0F )
			m_CmbCH4.SetCurSel(8);
		// W(CH5)
		if( ( GettingData40.ChannelRange & 0x00F00000 ) >> 20 == 0x00 )
			m_CmbCH5.SetCurSel(0);
		if( ( GettingData40.ChannelRange & 0x00F00000 ) >> 20 == 0x01 )
			m_CmbCH5.SetCurSel(1);
		if( ( GettingData40.ChannelRange & 0x00F00000 ) >> 20 == 0x02 )
			m_CmbCH5.SetCurSel(2);
		if( ( GettingData40.ChannelRange & 0x00F00000 ) >> 20 == 0x03 )
			m_CmbCH5.SetCurSel(3);
		if( ( GettingData40.ChannelRange & 0x00F00000 ) >> 20 == 0x0B )
			m_CmbCH5.SetCurSel(4);
		if( ( GettingData40.ChannelRange & 0x00F00000 ) >> 20 == 0x05 )
			m_CmbCH5.SetCurSel(5);
		if( ( GettingData40.ChannelRange & 0x00F00000 ) >> 20 == 0x06 )
			m_CmbCH5.SetCurSel(6);
		if( ( GettingData40.ChannelRange & 0x00F00000 ) >> 20 == 0x07 )
			m_CmbCH5.SetCurSel(7);
		if( ( GettingData40.ChannelRange & 0x00F00000 ) >> 20 == 0x0F )
			m_CmbCH5.SetCurSel(8);
		// W(CH6)
		if( ( GettingData40.ChannelRange & 0x0F000000 ) >> 24 == 0x00 )
			m_CmbCH6.SetCurSel(0);
		if( ( GettingData40.ChannelRange & 0x0F000000 ) >> 24 == 0x01 )
			m_CmbCH6.SetCurSel(1);
		if( ( GettingData40.ChannelRange & 0x0F000000 ) >> 24 == 0x02 )
			m_CmbCH6.SetCurSel(2);
		if( ( GettingData40.ChannelRange & 0x0F000000 ) >> 24 == 0x03 )
			m_CmbCH6.SetCurSel(3);
		if( ( GettingData40.ChannelRange & 0x0F000000 ) >> 24 == 0x0B )
			m_CmbCH6.SetCurSel(4);
		if( ( GettingData40.ChannelRange & 0x0F000000 ) >> 24 == 0x05 )
			m_CmbCH6.SetCurSel(5);
		if( ( GettingData40.ChannelRange & 0x0F000000 ) >> 24 == 0x06 )
			m_CmbCH6.SetCurSel(6);
		if( ( GettingData40.ChannelRange & 0x0F000000 ) >> 24 == 0x07 )
			m_CmbCH6.SetCurSel(7);
		if( ( GettingData40.ChannelRange & 0x0F000000 ) >> 24 == 0x0F )
			m_CmbCH6.SetCurSel(8);
		// W(CH7)
		if( ( GettingData40.ChannelRange & 0xF0000000 ) >> 28 == 0x00 )
			m_CmbCH7.SetCurSel(0);
		if( ( GettingData40.ChannelRange & 0xF0000000 ) >> 28 == 0x01 )
			m_CmbCH7.SetCurSel(1);
		if( ( GettingData40.ChannelRange & 0xF0000000 ) >> 28 == 0x02 )
			m_CmbCH7.SetCurSel(2);
		if( ( GettingData40.ChannelRange & 0xF0000000 ) >> 28 == 0x03 )
			m_CmbCH7.SetCurSel(3);
		if( ( GettingData40.ChannelRange & 0xF0000000 ) >> 28 == 0x0B )
			m_CmbCH7.SetCurSel(4);
		if( ( GettingData40.ChannelRange & 0xF0000000 ) >> 28 == 0x05 )
			m_CmbCH7.SetCurSel(5);
		if( ( GettingData40.ChannelRange & 0xF0000000 ) >> 28 == 0x06 )
			m_CmbCH7.SetCurSel(6);
		if( ( GettingData40.ChannelRange & 0xF0000000 ) >> 28 == 0x07 )
			m_CmbCH7.SetCurSel(7);
		if( ( GettingData40.ChannelRange & 0xF0000000 ) >> 28 == 0x0F )
			m_CmbCH7.SetCurSel(8);

		// 臒l
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 0, GettingData40.ChUpperThreshold[0] ) );
		m_StrUpperCh0 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 1, GettingData40.ChUpperThreshold[1] ) );
		m_StrUpperCh1 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 2, GettingData40.ChUpperThreshold[2] ) );
		m_StrUpperCh2 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 3, GettingData40.ChUpperThreshold[3] ) );
		m_StrUpperCh3 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 4, GettingData40.ChUpperThreshold[4] ) );
		m_StrUpperCh4 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 5, GettingData40.ChUpperThreshold[5] ) );
		m_StrUpperCh5 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 6, GettingData40.ChUpperThreshold[6] ) );
		m_StrUpperCh6 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 7, GettingData40.ChUpperThreshold[7] ) );
		m_StrUpperCh7 = MsgBuf;

		// l
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 0, GettingData40.ChLowerThreshold[0] ) );
		m_StrLowerCh0 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 1, GettingData40.ChLowerThreshold[1] ) );
		m_StrLowerCh1 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 2, GettingData40.ChLowerThreshold[2] ) );
		m_StrLowerCh2 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 3, GettingData40.ChLowerThreshold[3] ) );
		m_StrLowerCh3 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 4, GettingData40.ChLowerThreshold[4] ) );
		m_StrLowerCh4 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 5, GettingData40.ChLowerThreshold[5] ) );
		m_StrLowerCh5 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 6, GettingData40.ChLowerThreshold[6] ) );
		m_StrLowerCh6 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 7, GettingData40.ChLowerThreshold[7] ) );
		m_StrLowerCh7 = MsgBuf;
	}

	// L
	m_BtnGP40Stop.EnableWindow( TRUE );
	m_BtnDIOIn.EnableWindow( TRUE );
	m_BtnDIOHighOut.EnableWindow( TRUE );
	m_BtnDIOLowOut.EnableWindow( TRUE );
	m_BtnGetSetting.EnableWindow( TRUE );
	m_BtnSetSetting.EnableWindow( TRUE );
	m_BtnGetStart.EnableWindow( TRUE );
	m_BtnGetStop.EnableWindow( TRUE );
	m_BtnOneShot.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnGetSetting.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2040Dlg::OnBnClickedSetSetting()
{
	DWORD	Status;
	GP40Setting SettingData40;
	char	MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );

	if( ( strtol( m_StrSampling.GetBuffer( m_StrSampling.GetLength() ), NULL, 10 ) < 1 ) || ( strtol( m_StrSampling.GetBuffer( m_StrSampling.GetLength() ), NULL, 10 ) > 65535 ) )
	{
		MessageBox( "1-65535̃TvOԊuw肵Ă", "", MB_OK );
		return;
	}
	if( ( strtol( m_StrTrigger.GetBuffer( m_StrTrigger.GetLength() ), NULL, 10 ) < 1 ) || ( strtol( m_StrTrigger.GetBuffer( m_StrTrigger.GetLength() ), NULL, 10 ) > 50 ) )
	{
		MessageBox( "1-50̃gK|Cgw肵Ă", "", MB_OK );
		return;
	}

	// 
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// TvO̗L
	SettingData40.ChannelEnable = 0x00;
	if( m_ChkCH0.GetCheck() )
		SettingData40.ChannelEnable |= 0x01;
	if( m_ChkCH1.GetCheck() )
		SettingData40.ChannelEnable |= 0x02;
	if( m_ChkCH2.GetCheck() )
		SettingData40.ChannelEnable |= 0x04;
	if( m_ChkCH3.GetCheck() )
		SettingData40.ChannelEnable |= 0x08;
	if( m_ChkCH4.GetCheck() )
		SettingData40.ChannelEnable |= 0x10;
	if( m_ChkCH5.GetCheck() )
		SettingData40.ChannelEnable |= 0x20;
	if( m_ChkCH6.GetCheck() )
		SettingData40.ChannelEnable |= 0x40;
	if( m_ChkCH7.GetCheck() )
		SettingData40.ChannelEnable |= 0x80;

	// A[ʒm
	SettingData40.AlarmEnable = 0x00;
	if( m_ChkAlarm.GetCheck() )
		SettingData40.AlarmEnable = 0x10;

	// TvOԊu
	SettingData40.SampTime = (WORD)strtoul( m_StrSampling.GetBuffer( m_StrSampling.GetLength() ), NULL, 10 );

	// gK|Cg
	SettingData40.Trigger = (BYTE)strtoul( m_StrTrigger.GetBuffer( m_StrTrigger.GetLength() ), NULL, 10 );

	// W(CH0)
	SettingData40.ChannelRange = 0x00000000;
	if( m_CmbCH0.GetCurSel() == 0 )
		SettingData40.ChannelRange |= 0x00000000;
	if( m_CmbCH0.GetCurSel() == 1 )
		SettingData40.ChannelRange |= 0x00000001;
	if( m_CmbCH0.GetCurSel() == 2 )
		SettingData40.ChannelRange |= 0x00000002;
	if( m_CmbCH0.GetCurSel() == 3 )
		SettingData40.ChannelRange |= 0x00000003;
	if( m_CmbCH0.GetCurSel() == 4 )
		SettingData40.ChannelRange |= 0x0000000B;
	if( m_CmbCH0.GetCurSel() == 5 )
		SettingData40.ChannelRange |= 0x00000005;
	if( m_CmbCH0.GetCurSel() == 6 )
		SettingData40.ChannelRange |= 0x00000006;
	if( m_CmbCH0.GetCurSel() == 7 )
		SettingData40.ChannelRange |= 0x00000007;
	if( m_CmbCH0.GetCurSel() == 8 )
		SettingData40.ChannelRange |= 0x0000000F;
	// W(CH1)
	if( m_CmbCH1.GetCurSel() == 0 )
		SettingData40.ChannelRange |= 0x00000000;
	if( m_CmbCH1.GetCurSel() == 1 )
		SettingData40.ChannelRange |= 0x00000010;
	if( m_CmbCH1.GetCurSel() == 2 )
		SettingData40.ChannelRange |= 0x00000020;
	if( m_CmbCH1.GetCurSel() == 3 )
		SettingData40.ChannelRange |= 0x00000030;
	if( m_CmbCH1.GetCurSel() == 4 )
		SettingData40.ChannelRange |= 0x000000B0;
	if( m_CmbCH1.GetCurSel() == 5 )
		SettingData40.ChannelRange |= 0x00000050;
	if( m_CmbCH1.GetCurSel() == 6 )
		SettingData40.ChannelRange |= 0x00000060;
	if( m_CmbCH1.GetCurSel() == 7 )
		SettingData40.ChannelRange |= 0x00000070;
	if( m_CmbCH1.GetCurSel() == 8 )
		SettingData40.ChannelRange |= 0x000000F0;
	// W(CH2)
	if( m_CmbCH2.GetCurSel() == 0 )
		SettingData40.ChannelRange |= 0x00000000;
	if( m_CmbCH2.GetCurSel() == 1 )
		SettingData40.ChannelRange |= 0x00000100;
	if( m_CmbCH2.GetCurSel() == 2 )
		SettingData40.ChannelRange |= 0x00000200;
	if( m_CmbCH2.GetCurSel() == 3 )
		SettingData40.ChannelRange |= 0x00000300;
	if( m_CmbCH2.GetCurSel() == 4 )
		SettingData40.ChannelRange |= 0x00000B00;
	if( m_CmbCH2.GetCurSel() == 5 )
		SettingData40.ChannelRange |= 0x00000500;
	if( m_CmbCH2.GetCurSel() == 6 )
		SettingData40.ChannelRange |= 0x00000600;
	if( m_CmbCH2.GetCurSel() == 7 )
		SettingData40.ChannelRange |= 0x00000700;
	if( m_CmbCH2.GetCurSel() == 8 )
		SettingData40.ChannelRange |= 0x00000F00;
	// W(CH3)
	if( m_CmbCH3.GetCurSel() == 0 )
		SettingData40.ChannelRange |= 0x00000000;
	if( m_CmbCH3.GetCurSel() == 1 )
		SettingData40.ChannelRange |= 0x00001000;
	if( m_CmbCH3.GetCurSel() == 2 )
		SettingData40.ChannelRange |= 0x00002000;
	if( m_CmbCH3.GetCurSel() == 3 )
		SettingData40.ChannelRange |= 0x00003000;
	if( m_CmbCH3.GetCurSel() == 4 )
		SettingData40.ChannelRange |= 0x0000B000;
	if( m_CmbCH3.GetCurSel() == 5 )
		SettingData40.ChannelRange |= 0x00005000;
	if( m_CmbCH3.GetCurSel() == 6 )
		SettingData40.ChannelRange |= 0x00006000;
	if( m_CmbCH3.GetCurSel() == 7 )
		SettingData40.ChannelRange |= 0x00007000;
	if( m_CmbCH3.GetCurSel() == 8 )
		SettingData40.ChannelRange |= 0x0000F000;
	// W(CH4)
	if( m_CmbCH4.GetCurSel() == 0 )
		SettingData40.ChannelRange |= 0x00000000;
	if( m_CmbCH4.GetCurSel() == 1 )
		SettingData40.ChannelRange |= 0x00010000;
	if( m_CmbCH4.GetCurSel() == 2 )
		SettingData40.ChannelRange |= 0x00020000;
	if( m_CmbCH4.GetCurSel() == 3 )
		SettingData40.ChannelRange |= 0x00030000;
	if( m_CmbCH4.GetCurSel() == 4 )
		SettingData40.ChannelRange |= 0x000B0000;
	if( m_CmbCH4.GetCurSel() == 5 )
		SettingData40.ChannelRange |= 0x00050000;
	if( m_CmbCH4.GetCurSel() == 6 )
		SettingData40.ChannelRange |= 0x00060000;
	if( m_CmbCH4.GetCurSel() == 7 )
		SettingData40.ChannelRange |= 0x00070000;
	if( m_CmbCH4.GetCurSel() == 8 )
		SettingData40.ChannelRange |= 0x000F0000;
	// W(CH5)
	if( m_CmbCH5.GetCurSel() == 0 )
		SettingData40.ChannelRange |= 0x00000000;
	if( m_CmbCH5.GetCurSel() == 1 )
		SettingData40.ChannelRange |= 0x00100000;
	if( m_CmbCH5.GetCurSel() == 2 )
		SettingData40.ChannelRange |= 0x00200000;
	if( m_CmbCH5.GetCurSel() == 3 )
		SettingData40.ChannelRange |= 0x00300000;
	if( m_CmbCH5.GetCurSel() == 4 )
		SettingData40.ChannelRange |= 0x00B00000;
	if( m_CmbCH5.GetCurSel() == 5 )
		SettingData40.ChannelRange |= 0x00500000;
	if( m_CmbCH5.GetCurSel() == 6 )
		SettingData40.ChannelRange |= 0x00600000;
	if( m_CmbCH5.GetCurSel() == 7 )
		SettingData40.ChannelRange |= 0x00700000;
	if( m_CmbCH5.GetCurSel() == 8 )
		SettingData40.ChannelRange |= 0x00F00000;
	// W(CH6)
	if( m_CmbCH6.GetCurSel() == 0 )
		SettingData40.ChannelRange |= 0x00000000;
	if( m_CmbCH6.GetCurSel() == 1 )
		SettingData40.ChannelRange |= 0x01000000;
	if( m_CmbCH6.GetCurSel() == 2 )
		SettingData40.ChannelRange |= 0x02000000;
	if( m_CmbCH6.GetCurSel() == 3 )
		SettingData40.ChannelRange |= 0x03000000;
	if( m_CmbCH6.GetCurSel() == 4 )
		SettingData40.ChannelRange |= 0x0B000000;
	if( m_CmbCH6.GetCurSel() == 5 )
		SettingData40.ChannelRange |= 0x05000000;
	if( m_CmbCH6.GetCurSel() == 6 )
		SettingData40.ChannelRange |= 0x06000000;
	if( m_CmbCH6.GetCurSel() == 7 )
		SettingData40.ChannelRange |= 0x07000000;
	if( m_CmbCH6.GetCurSel() == 8 )
		SettingData40.ChannelRange |= 0x0F000000;
	// W(CH7)
	if( m_CmbCH7.GetCurSel() == 0 )
		SettingData40.ChannelRange |= 0x00000000;
	if( m_CmbCH7.GetCurSel() == 1 )
		SettingData40.ChannelRange |= 0x10000000;
	if( m_CmbCH7.GetCurSel() == 2 )
		SettingData40.ChannelRange |= 0x20000000;
	if( m_CmbCH7.GetCurSel() == 3 )
		SettingData40.ChannelRange |= 0x30000000;
	if( m_CmbCH7.GetCurSel() == 4 )
		SettingData40.ChannelRange |= 0xB0000000;
	if( m_CmbCH7.GetCurSel() == 5 )
		SettingData40.ChannelRange |= 0x50000000;
	if( m_CmbCH7.GetCurSel() == 6 )
		SettingData40.ChannelRange |= 0x60000000;
	if( m_CmbCH7.GetCurSel() == 7 )
		SettingData40.ChannelRange |= 0x70000000;
	if( m_CmbCH7.GetCurSel() == 8 )
		SettingData40.ChannelRange |= 0xF0000000;

	// 臒l
	SettingData40.ChUpperThreshold[0] = GetwValue( 0, strtod(m_StrUpperCh0.GetBuffer( m_StrUpperCh0.GetLength() ), 0) );
	SettingData40.ChUpperThreshold[1] = GetwValue( 1, strtod(m_StrUpperCh1.GetBuffer( m_StrUpperCh1.GetLength() ), 0) );
	SettingData40.ChUpperThreshold[2] = GetwValue( 2, strtod(m_StrUpperCh2.GetBuffer( m_StrUpperCh2.GetLength() ), 0) );
	SettingData40.ChUpperThreshold[3] = GetwValue( 3, strtod(m_StrUpperCh3.GetBuffer( m_StrUpperCh3.GetLength() ), 0) );
	SettingData40.ChUpperThreshold[4] = GetwValue( 4, strtod(m_StrUpperCh4.GetBuffer( m_StrUpperCh4.GetLength() ), 0) );
	SettingData40.ChUpperThreshold[5] = GetwValue( 5, strtod(m_StrUpperCh5.GetBuffer( m_StrUpperCh5.GetLength() ), 0) );
	SettingData40.ChUpperThreshold[6] = GetwValue( 6, strtod(m_StrUpperCh6.GetBuffer( m_StrUpperCh6.GetLength() ), 0) );
	SettingData40.ChUpperThreshold[7] = GetwValue( 7, strtod(m_StrUpperCh7.GetBuffer( m_StrUpperCh7.GetLength() ), 0) );

	// 臒l
	SettingData40.ChLowerThreshold[0] = GetwValue( 0, strtod(m_StrLowerCh0.GetBuffer( m_StrLowerCh0.GetLength() ), 0) );
	SettingData40.ChLowerThreshold[1] = GetwValue( 1, strtod(m_StrLowerCh1.GetBuffer( m_StrLowerCh1.GetLength() ), 0) );
	SettingData40.ChLowerThreshold[2] = GetwValue( 2, strtod(m_StrLowerCh2.GetBuffer( m_StrLowerCh2.GetLength() ), 0) );
	SettingData40.ChLowerThreshold[3] = GetwValue( 3, strtod(m_StrLowerCh3.GetBuffer( m_StrLowerCh3.GetLength() ), 0) );
	SettingData40.ChLowerThreshold[4] = GetwValue( 4, strtod(m_StrLowerCh4.GetBuffer( m_StrLowerCh4.GetLength() ), 0) );
	SettingData40.ChLowerThreshold[5] = GetwValue( 5, strtod(m_StrLowerCh5.GetBuffer( m_StrLowerCh5.GetLength() ), 0) );
	SettingData40.ChLowerThreshold[6] = GetwValue( 6, strtod(m_StrLowerCh6.GetBuffer( m_StrLowerCh6.GetLength() ), 0) );
	SettingData40.ChLowerThreshold[7] = GetwValue( 7, strtod(m_StrLowerCh7.GetBuffer( m_StrLowerCh7.GetLength() ), 0) );

	// l𐮂ĕ\( -10.24܂łȂ̂-30Ɛݒ肵悤Ƃꍇ-10.24ƕ\ )
	// 臒l
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 0, SettingData40.ChUpperThreshold[0] ) );
	m_StrUpperCh0 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 1, SettingData40.ChUpperThreshold[1] ) );
	m_StrUpperCh1 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 2, SettingData40.ChUpperThreshold[2] ) );
	m_StrUpperCh2 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 3, SettingData40.ChUpperThreshold[3] ) );
	m_StrUpperCh3 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 4, SettingData40.ChUpperThreshold[4] ) );
	m_StrUpperCh4 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 5, SettingData40.ChUpperThreshold[5] ) );
	m_StrUpperCh5 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 6, SettingData40.ChUpperThreshold[6] ) );
	m_StrUpperCh6 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 7, SettingData40.ChUpperThreshold[7] ) );
	m_StrUpperCh7 = MsgBuf;
	// 臒l
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 0, SettingData40.ChLowerThreshold[0] ) );
	m_StrLowerCh0 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 1, SettingData40.ChLowerThreshold[1] ) );
	m_StrLowerCh1 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 2, SettingData40.ChLowerThreshold[2] ) );
	m_StrLowerCh2 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 3, SettingData40.ChLowerThreshold[3] ) );
	m_StrLowerCh3 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 4, SettingData40.ChLowerThreshold[4] ) );
	m_StrLowerCh4 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 5, SettingData40.ChLowerThreshold[5] ) );
	m_StrLowerCh5 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 6, SettingData40.ChLowerThreshold[6] ) );
	m_StrLowerCh6 = MsgBuf;
	sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 7, SettingData40.ChLowerThreshold[7] ) );
	m_StrLowerCh7 = MsgBuf;



	// ݒ菑
	Status = RPiGP40SetSetting( hCom, CmbMacAdrsBuf, SettingData40 );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP40SetSetting G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}

	// L
	m_BtnGP40Stop.EnableWindow( TRUE );
	m_BtnDIOIn.EnableWindow( TRUE );
	m_BtnDIOHighOut.EnableWindow( TRUE );
	m_BtnDIOLowOut.EnableWindow( TRUE );
	m_BtnGetSetting.EnableWindow( TRUE );
	m_BtnSetSetting.EnableWindow( TRUE );
	m_BtnGetStart.EnableWindow( TRUE );
	m_BtnGetStop.EnableWindow( TRUE );
	m_BtnOneShot.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnSetSetting.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2040Dlg::OnBnClickedOneshot()
{
	DWORD	Status;
	GP40ChannelData GetChData;
	char	MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	// 
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// 1擾
	Status = RPiGP40OneShot( hCom, CmbMacAdrsBuf, &GetChData );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP40OneShot G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		// f[^
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 0, GetChData.ChData[0] ) );
		m_StrCh0 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 1, GetChData.ChData[1] ) );
		m_StrCh1 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 2, GetChData.ChData[2] ) );
		m_StrCh2 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 3, GetChData.ChData[3] ) );
		m_StrCh3 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 4, GetChData.ChData[4] ) );
		m_StrCh4 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 5, GetChData.ChData[5] ) );
		m_StrCh5 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 6, GetChData.ChData[6] ) );
		m_StrCh6 = MsgBuf;
		sprintf_s( MsgBuf, sizeof(MsgBuf), "%.2f", GetdbValue( 7, GetChData.ChData[7] ) );
		m_StrCh7 = MsgBuf;
	}

	// L
	m_BtnGP40Stop.EnableWindow( TRUE );
	m_BtnDIOIn.EnableWindow( TRUE );
	m_BtnDIOHighOut.EnableWindow( TRUE );
	m_BtnDIOLowOut.EnableWindow( TRUE );
	m_BtnGetSetting.EnableWindow( TRUE );
	m_BtnSetSetting.EnableWindow( TRUE );
	m_BtnGetStart.EnableWindow( TRUE );
	m_BtnGetStop.EnableWindow( TRUE );
	m_BtnOneShot.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnOneShot.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2040Dlg::OnBnClickedGetStart()
{
	DWORD	Status;
	char	MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	// 
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// A擾Jn(1)
	Status = RPiGP40TimerData( hCom, CmbMacAdrsBuf, 1, 1 );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP40TimerData G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}

	// L
	m_BtnGP40Stop.EnableWindow( TRUE );
	m_BtnDIOIn.EnableWindow( TRUE );
	m_BtnDIOHighOut.EnableWindow( TRUE );
	m_BtnDIOLowOut.EnableWindow( TRUE );
	m_BtnGetSetting.EnableWindow( TRUE );
	m_BtnSetSetting.EnableWindow( TRUE );
	m_BtnGetStart.EnableWindow( TRUE );
	m_BtnGetStop.EnableWindow( TRUE );
	m_BtnOneShot.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnGetStart.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2040Dlg::OnBnClickedGetStop()
{
	DWORD	Status;
	char	MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	// 
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// A擾~
	Status = RPiGP40TimerData( hCom, CmbMacAdrsBuf, 0, 1 );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP40TimerData G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}

	// L
	m_BtnGP40Stop.EnableWindow( TRUE );
	m_BtnDIOIn.EnableWindow( TRUE );
	m_BtnDIOHighOut.EnableWindow( TRUE );
	m_BtnDIOLowOut.EnableWindow( TRUE );
	m_BtnGetSetting.EnableWindow( TRUE );
	m_BtnSetSetting.EnableWindow( TRUE );
	m_BtnGetStart.EnableWindow( TRUE );
	m_BtnGetStop.EnableWindow( TRUE );
	m_BtnOneShot.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnGetStop.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2040Dlg::OnBnClickedDiohighout()
{
	DWORD	Status;
	char	MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	// 
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// o(DIO : High)I[vRN^̂0x00
	Status = RPiGP40OutPort( hCom, CmbMacAdrsBuf, 0x00 );

	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP40OutPort G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}

	// L
	m_BtnGP40Stop.EnableWindow( TRUE );
	m_BtnDIOIn.EnableWindow( TRUE );
	m_BtnDIOHighOut.EnableWindow( TRUE );
	m_BtnDIOLowOut.EnableWindow( TRUE );
	m_BtnGetSetting.EnableWindow( TRUE );
	m_BtnSetSetting.EnableWindow( TRUE );
	m_BtnGetStart.EnableWindow( TRUE );
	m_BtnGetStop.EnableWindow( TRUE );
	m_BtnOneShot.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnDIOHighOut.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2040Dlg::OnBnClickedDiolowout()
{
	DWORD	Status;
	char	MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	// 
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// o(DIO : Low)I[vRN^̂0x01
	Status = RPiGP40OutPort( hCom, CmbMacAdrsBuf, 0x01 );

	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP40OutPort G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}

	// L
	m_BtnGP40Stop.EnableWindow( TRUE );
	m_BtnDIOIn.EnableWindow( TRUE );
	m_BtnDIOHighOut.EnableWindow( TRUE );
	m_BtnDIOLowOut.EnableWindow( TRUE );
	m_BtnGetSetting.EnableWindow( TRUE );
	m_BtnSetSetting.EnableWindow( TRUE );
	m_BtnGetStart.EnableWindow( TRUE );
	m_BtnGetStop.EnableWindow( TRUE );
	m_BtnOneShot.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnDIOLowOut.SetFocus();
	UpdateData( FALSE );
}


void CRSSG2040Dlg::OnBnClickedDioin()
{
	DWORD	Status;
	BYTE	bInData;
	char	MsgBuf[256];

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );
	// 
	m_BtnGP40Stop.EnableWindow( FALSE );
	m_BtnDIOIn.EnableWindow( FALSE );
	m_BtnDIOHighOut.EnableWindow( FALSE );
	m_BtnDIOLowOut.EnableWindow( FALSE );
	m_BtnGetSetting.EnableWindow( FALSE );
	m_BtnSetSetting.EnableWindow( FALSE );
	m_BtnGetStart.EnableWindow( FALSE );
	m_BtnGetStop.EnableWindow( FALSE );
	m_BtnOneShot.EnableWindow( FALSE );
	m_BtnGet.EnableWindow( FALSE );
	UpdateData( FALSE );

	// 
	Status = RPiGP40InPort( hCom, CmbMacAdrsBuf, &bInData );
	if( Status != 0 )
	{
		sprintf_s( MsgBuf, sizeof(MsgBuf), "RPiGP40InPort G[ [%X]", Status );
		m_StrMsg = MsgBuf;
	}
	else
	{
		// Low
		if( bInData == 0x00 )
		{
			m_StrDioIn = "Low";
		}
		// High
		else
		{
			m_StrDioIn = "High";
		}
	}

	// L
	m_BtnGP40Stop.EnableWindow( TRUE );
	m_BtnDIOIn.EnableWindow( TRUE );
	m_BtnDIOHighOut.EnableWindow( TRUE );
	m_BtnDIOLowOut.EnableWindow( TRUE );
	m_BtnGetSetting.EnableWindow( TRUE );
	m_BtnSetSetting.EnableWindow( TRUE );
	m_BtnGetStart.EnableWindow( TRUE );
	m_BtnGetStop.EnableWindow( TRUE );
	m_BtnOneShot.EnableWindow( TRUE );
	m_BtnGet.EnableWindow( TRUE );
	m_BtnDIOIn.SetFocus();
	UpdateData( FALSE );
}

void CRSSG2040Dlg::OnCbnSelchangeMacadrs()
{
	CString strMacAdrs;
	UCHAR	Version[8];
	CHAR	RSSI;
	double	Temp, Humidity;

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	UpdateData( TRUE );

	// R{{bNX擾
	m_CmbMacAdrs.GetLBText( m_CmbMacAdrs.GetCurSel(), strMacAdrs );

	CmbMacAdrsBuf[0] = (UCHAR)strtoul( strMacAdrs.Mid( 0, 2), NULL, 16 );
	CmbMacAdrsBuf[1] = (UCHAR)strtoul( strMacAdrs.Mid( 3, 2), NULL, 16 );
	CmbMacAdrsBuf[2] = (UCHAR)strtoul( strMacAdrs.Mid( 6, 2), NULL, 16 );
	CmbMacAdrsBuf[3] = (UCHAR)strtoul( strMacAdrs.Mid( 9, 2), NULL, 16 );
	CmbMacAdrsBuf[4] = (UCHAR)strtoul( strMacAdrs.Mid(12, 2), NULL, 16 );
	CmbMacAdrsBuf[5] = (UCHAR)strtoul( strMacAdrs.Mid(15, 2), NULL, 16 );
	CmbMacAdrsBuf[6] = (UCHAR)strtoul( strMacAdrs.Mid(18, 2), NULL, 16 );
	CmbMacAdrsBuf[7] = (UCHAR)strtoul( strMacAdrs.Mid(21, 2), NULL, 16 );

	if( fStart )
	{
		// o[W擾
		RSSG2000GetVersion( hCom, CmbMacAdrsBuf, Version );
		m_StrVersion.Format( "%x.%02x", Version[0], Version[1] );
		// RSSI擾
		RSSG2000GetRSSI( hCom, CmbMacAdrsBuf, &RSSI );
		m_StrRSSI.Format( "%d", RSSI );
		// x擾
		RSSG2000GetTemp( hCom, CmbMacAdrsBuf, &Temp, &Humidity );
		m_StrTemp.Format( "%.2f", Temp );
		m_StrHumidity.Format( "%.2f", Humidity );
	}

	// JntO
	if( fGP40Start[m_CmbMacAdrs.GetCurSel()] )
	{
		// 
		m_BtnGP40Start.EnableWindow( FALSE );
		// L
		m_BtnGP40Stop.EnableWindow( TRUE );
		m_BtnDIOIn.EnableWindow( TRUE );
		m_BtnDIOHighOut.EnableWindow( TRUE );
		m_BtnDIOLowOut.EnableWindow( TRUE );
		m_BtnGetSetting.EnableWindow( TRUE );
		m_BtnSetSetting.EnableWindow( TRUE );
		m_BtnGetStart.EnableWindow( TRUE );
		m_BtnGetStop.EnableWindow( TRUE );
		m_BtnOneShot.EnableWindow( TRUE );
	}
	else
	{
		if( fStart )
		{
			// L
			m_BtnGP40Start.EnableWindow( TRUE );
			// L
			m_BtnGP40Stop.EnableWindow( FALSE );
			m_BtnDIOIn.EnableWindow( FALSE );
			m_BtnDIOHighOut.EnableWindow( FALSE );
			m_BtnDIOLowOut.EnableWindow( FALSE );
			m_BtnGetSetting.EnableWindow( FALSE );
			m_BtnSetSetting.EnableWindow( FALSE );
			m_BtnGetStart.EnableWindow( FALSE );
			m_BtnGetStop.EnableWindow( FALSE );
			m_BtnOneShot.EnableWindow( FALSE );
		}
	}

	UpdateData( FALSE );
}


double CRSSG2040Dlg::GetdbValue( UCHAR CHNo, WORD wData )
{
	double	dbData;
	UCHAR	Range;
	double	dbRes;

	// W
	Range = 0;
	switch( CHNo )
	{
	case 0:	Range = m_CmbCH0.GetCurSel();	break;
	case 1:	Range = m_CmbCH1.GetCurSel();	break;
	case 2:	Range = m_CmbCH2.GetCurSel();	break;
	case 3:	Range = m_CmbCH3.GetCurSel();	break;
	case 4:	Range = m_CmbCH4.GetCurSel();	break;
	case 5:	Range = m_CmbCH5.GetCurSel();	break;
	case 6:	Range = m_CmbCH6.GetCurSel();	break;
	case 7:	Range = m_CmbCH7.GetCurSel();	break;
	}

	dbRes = 1.0;
	// 	{"}10.24V", "}5.12V", "}2.56V", "}1.28V", "}0.64V", "0`10.24V", "0`5.12V", "0`2.56V", "0`1.28V"};
	switch( Range )
	{
	case 0: dbRes = 20.48/4095.0;		break;
	case 1: dbRes = 10.24/4095.0;		break;
	case 2: dbRes =  5.12/4095.0;		break;
	case 3: dbRes =  2.56/4095.0;		break;
	case 4: dbRes =  1.28/4095.0;		break;
	case 5: dbRes = 10.24/4095.0;		break;
	case 6: dbRes =  5.12/4095.0;		break;
	case 7: dbRes =  2.56/4095.0;		break;
	case 8: dbRes =  1.28/4095.0;		break;
	}

	dbData = 0.0;
	switch( Range )
	{
	case 0: dbData = -10.24 + dbRes*wData;		break;
	case 1: dbData =  -5.12 + dbRes*wData;		break;
	case 2: dbData =  -2.56 + dbRes*wData;		break;
	case 3: dbData =  -1.28 + dbRes*wData;		break;
	case 4: dbData =  -0.64 + dbRes*wData;		break;
	case 5: dbData = dbRes*wData;		break;
	case 6: dbData = dbRes*wData;		break;
	case 7: dbData = dbRes*wData;		break;
	case 8: dbData = dbRes*wData;		break;
	}

	return dbData;
}

WORD CRSSG2040Dlg::GetwValue( UCHAR CHNo, double dbData )
{
	WORD	wData;
	UCHAR	Range;
	double	dbRes;

	// W
	Range = 0;
	switch( CHNo )
	{
	case 0:	Range = m_CmbCH0.GetCurSel();	break;
	case 1:	Range = m_CmbCH1.GetCurSel();	break;
	case 2:	Range = m_CmbCH2.GetCurSel();	break;
	case 3:	Range = m_CmbCH3.GetCurSel();	break;
	case 4:	Range = m_CmbCH4.GetCurSel();	break;
	case 5:	Range = m_CmbCH5.GetCurSel();	break;
	case 6:	Range = m_CmbCH6.GetCurSel();	break;
	case 7:	Range = m_CmbCH7.GetCurSel();	break;
	}

	dbRes = 1.0;
	// 	{"}10.24V", "}5.12V", "}2.56V", "}1.28V", "}0.64V", "0`10.24V", "0`5.12V", "0`2.56V", "0`1.28V"};
	switch( Range )
	{
	case 0: dbRes = 20.48/4095.0;		break;
	case 1: dbRes = 10.24/4095.0;		break;
	case 2: dbRes =  5.12/4095.0;		break;
	case 3: dbRes =  2.56/4095.0;		break;
	case 4: dbRes =  1.28/4095.0;		break;
	case 5: dbRes = 10.24/4095.0;		break;
	case 6: dbRes =  5.12/4095.0;		break;
	case 7: dbRes =  2.56/4095.0;		break;
	case 8: dbRes =  1.28/4095.0;		break;
	}

	wData = 0;
	switch( Range )
	{
	case 0: 
        if (dbData >= 10.24)
            wData = 4095;
        else if (dbData <= -10.24)
            wData = 0;
		else
			wData = (WORD)( ( dbData + 10.24 ) / dbRes );	
		break;
	case 1: 
        if (dbData >= 5.12)
            wData = 4095;
        else if (dbData <= -5.12)
            wData = 0;
		else
			wData = (WORD)( ( dbData +  5.12 ) / dbRes );	
		break;
	case 2: 
        if (dbData >= 2.56)
            wData = 4095;
        else if (dbData <= -2.56)
            wData = 0;
		else 
			wData = (WORD)( ( dbData +  2.56 ) / dbRes );	
		break;
	case 3: 
        if (dbData >= 1.28)
            wData = 4095;
        else if (dbData <= -1.28)
            wData = 0;
		else
			wData = (WORD)( ( dbData +  1.28 ) / dbRes );	
		break;
	case 4: 
        if (dbData >= 0.64)
            wData = 4095;
        else if (dbData <= -0.64)
            wData = 0;
		else
			wData = (WORD)( ( dbData +  0.64 ) / dbRes );	
		break;
	case 5: 
        if (dbData >= 10.24)
            wData = 4095;
        else if (dbData <= 0)
            wData = 0;
		else
			wData = (WORD)( dbData / dbRes );	
		break;
	case 6: 
        if (dbData >= 5.12)
            wData = 4095;
        else if (dbData <= 0)
            wData = 0;
		else
			wData = (WORD)( dbData / dbRes );	
		break;
	case 7: 
        if (dbData >= 2.56)
            wData = 4095;
        else if (dbData <= 0)
            wData = 0;
		else
			wData = (WORD)( dbData / dbRes );	
		break;
	case 8: 
        if (dbData >= 1.28)
            wData = 4095;
        else if (dbData <= 0)
            wData = 0;
		else
			wData = (WORD)( dbData / dbRes );	
		break;
	}

	return wData;
}


void CRSSG2040Dlg::OnBnClickedCancel()
{
	BYTE	iii;

	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	m_StrMsg = "~...";
	UpdateData( FALSE );
	UpdateWindow(); 

	if( fStart )
	{
		// ~
		RSSG2000Stop( hCom );

		for( iii = 0; iii < MaxCount*8; iii+=8  )
		{
			if( ( MacAdrs[iii+0] == 0x00 ) && ( MacAdrs[iii+1] == 0x00 ) && ( MacAdrs[iii+2] == 0x00 ) && ( MacAdrs[iii+3] == 0x00 ) && ( MacAdrs[iii+4] == 0x00 ) && ( MacAdrs[iii+5] == 0x00 ) && ( MacAdrs[iii+6] == 0x00 ) && ( MacAdrs[iii+7] == 0x00 ) )
				;
			else
			{
				// 폜
				RSSG2000DeleteMacAdrs( hCom, (PUCHAR)( MacAdrs + iii) );
			}
		}

		// N[Y
		RSSG2000Close( hCom );
		hCom = INVALID_HANDLE_VALUE;
	}

	CDialogEx::OnCancel();
}
