using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices;	// "DllImport"p邽߂̖O
using System.Globalization;				// "NumberStyles"p邽߂̖O

namespace RSSG2000
{
    public class DLL
    {
        ////////////////////////////////////////////////////////////////////////////////
        //// 
        public struct RsUshortData
        {
            public UInt16 Ushortcode_0;
            public UInt16 Ushortcode_1;
            public UInt16 Ushortcode_2;
            public UInt16 Ushortcode_3;
            public UInt16 Ushortcode_4;
            public UInt16 Ushortcode_5;
            public UInt16 Ushortcode_6;
            public UInt16 Ushortcode_7;
        }
        ////////////////////////////////////////////////////////////////////////////////
        //// GP40ݒ
        [StructLayout(LayoutKind.Explicit, Size = 42)]
        unsafe public struct GP40Setting
        {
            [FieldOffset(0)] public Byte ChannelEnable;
            [FieldOffset(1)] public Byte AlarmEnable;
            [FieldOffset(2)] public UInt16 SampTime;
            [FieldOffset(4)] public Byte Trigger;
            [FieldOffset(5)] public Byte Reserved;
            [FieldOffset(6)] public UInt32 ChannelRange;
            [FieldOffset(10)] public RsUshortData ChUpperThreshold;
            [FieldOffset(26)] public RsUshortData ChLowerThreshold;
        }
        ////////////////////////////////////////////////////////////////////////////////
        //// GP60ݒ
        [StructLayout(LayoutKind.Explicit, Size = 8)]
        unsafe public struct GP60Setting
        {
            [FieldOffset(0)] public Byte BaudRate;
            [FieldOffset(1)] public Byte DataBit;
            [FieldOffset(2)] public Byte Parity;
            [FieldOffset(3)] public Byte StopBit;
            [FieldOffset(4)] public Byte Flow;
            [FieldOffset(5)] public Byte Reserved1;
            [FieldOffset(6)] public UInt16 Latency;
        }
        ////////////////////////////////////////////////////////////////////////////////
        //// GP70ݒ
        [StructLayout(LayoutKind.Explicit, Size = 8)]
        unsafe public struct GP70Setting
        {
            [FieldOffset(0)] public Byte BaudRate;
            [FieldOffset(1)] public Byte DataBit;
            [FieldOffset(2)] public Byte Parity;
            [FieldOffset(3)] public Byte StopBit;
            [FieldOffset(4)] public Byte Flow;
            [FieldOffset(5)] public Byte Reserved1;
            [FieldOffset(6)] public UInt16 Latency;
        }
        ////////////////////////////////////////////////////////////////////////////////
        //// GP90ݒ
        [StructLayout(LayoutKind.Explicit, Size = 8)]
        unsafe public struct GP90Setting
        {
            [FieldOffset(0)] public Byte PWMNo;
            [FieldOffset(1)] public UInt16 PWM_OnCount;
            [FieldOffset(3)] public Byte FULL_ON;
            [FieldOffset(4)] public UInt16 PWM_OffCount;
            [FieldOffset(6)] public Byte FULL_OFF;
            [FieldOffset(7)] public Byte PreScale;
        }
        ////////////////////////////////////////////////////////////////////////////////
        //// GP90pXݒ
        [StructLayout(LayoutKind.Explicit, Size = 9)]
        unsafe public struct GP90PulseSetting
        {
            [FieldOffset(0)] public Byte Channel;
            [FieldOffset(1)] public UInt16 Mode;
            [FieldOffset(3)] public UInt16 CompA;
            [FieldOffset(5)] public UInt16 CompB;
            [FieldOffset(7)] public UInt16 CompC;
        }

				// CallBack֐
        unsafe public delegate void ErrorCallback(Byte* pData);
        unsafe public delegate void TriggerCallback(Byte* pData);
        unsafe public delegate void TimerDataCallback(Byte* pData);
        unsafe public delegate void AlarmCallback(Byte* pData);
        unsafe public delegate void RecvCallback(Byte* pData);
        unsafe public delegate void RegistCallback(Byte* pData);
        //
        // API ֐`
        //
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RSSG2000Open(Byte ComNo, Byte bChannel, Byte MaxSG2000Count, RegistCallback pRegistFunc);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RSSG2000Close(UInt32 hCom);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RSSG2000Start(UInt32 hCom);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RSSG2000Stop(UInt32 hCom);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RSSG2000Reset(UInt32 hCom);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RSSG2000GetVersion(UInt32 hCom, Byte[] pMacAdrs, Byte[] pVersion);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RSSG2000GetRSSI(UInt32 hCom, Byte[] pMacAdrs, SByte* pRSSI);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RSSG2000GetTemp(UInt32 hCom, Byte[] pMacAdrs, double* pTemp, double* pHumidity);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RSSG2000SendRecv(UInt32 hCom, UInt32* pStatus, Byte[] pMacAdrs, Byte[] pSendData, UInt32 SendDataLength, Byte[] pRecvData, UInt32 RecvDataLength, Boolean Notify);

        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RSSG2000GetCount(UInt32 hCom);

        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RSSG2000GetMacAdrs(UInt32 hCom, Byte[] pMacAdrs);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RSSG2000RegistMacAdrs(UInt32 hCom, Byte[] pMacAdrs);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RSSG2000DeleteMacAdrs(UInt32 hCom, Byte[] pMacAdrs);

        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RSSG2000GetAlarmData(Byte[] pAlarmData);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RSSG2000GetTimerData(Byte[] pOneShotData);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RSSG2000GetRecvData(Byte[] pRecvData);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RSSG2000GetTriggerData(Byte[] pTriggerData);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RSSG2000GetErrorData(Byte[] pErrorData);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RSSG2000GetRegistData(Byte[] pRegistData);

        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP10Open(UInt32 hCom, Byte[] pMacAdrs, TriggerCallback pTriggerFunc, ErrorCallback pErrorFunc);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP10Close(UInt32 hCom, Byte[] pMacAdrs );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP10OutPort(UInt32 hCom, Byte[] pMacAdrs, Byte bData, Byte bMask, Byte bStrobe );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP10InPort(UInt32 hCom, Byte[] pMacAdrs, Byte* pData );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RPiGP10StrobeSetting(UInt32 hCom, Byte[] pMacAdrs, Boolean Logic, UInt32 wPulse);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP10StrobeOutput(UInt32 hCom, Byte[] pMacAdrs );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RPiGP10Trigger(UInt32 hCom, Byte[] pMacAdrs, Boolean Enable, Byte bOutData, Byte bMask);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32 RPiGP10TriggerChatter(UInt32 hCom, Byte[] pMacAdrs, Boolean Enable, Byte bOutData, Byte bMask, UInt16 wChattering);

        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP40Open(UInt32 hCom, Byte[] pMacAdrs, TimerDataCallback pTimerDataFunc, AlarmCallback pAlarmFunc, ErrorCallback pErrorFunc);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP40Close(UInt32 hCom, Byte[] pMacAdrs );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP40SetSetting(UInt32 hCom, Byte[] pMacAdrs, GP40Setting SettingData );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP40GetSetting(UInt32 hCom, Byte[] pMacAdrs, GP40Setting* pSettingData );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP40OneShot(UInt32 hCom, Byte[] pMacAdrs, RsUshortData* pChData );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP40TimerData(UInt32 hCom, Byte[] pMacAdrs, Byte bStart, Byte bTime );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP40OutPort(UInt32 hCom, Byte[] pMacAdrs, Byte bData);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP40InPort(UInt32 hCom, Byte[] pMacAdrs, Byte* pData);

        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP60Open(UInt32 hCom, Byte[] pMacAdrs, RecvCallback pRecvFunc, ErrorCallback pErrorFunc );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP60Close(UInt32 hCom, Byte[] pMacAdrs );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP60SetSetting(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, Byte Channel, GP60Setting SettingData );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP60GetSetting(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, Byte Channel, GP60Setting* pSettingData );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP60Send(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, Byte Channel, Byte[] pSendData, UInt32 SendDataLength, UInt32* pWriteDataLength );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP60FIFOReset(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, Byte Channel );

        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP70Open(UInt32 hCom, Byte[] pMacAdrs, RecvCallback pRecvFunc, ErrorCallback pErrorFunc);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP70Close(UInt32 hCom, Byte[] pMacAdrs );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP70SetSetting(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, Byte Channel, GP70Setting SettingData);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP70GetSetting(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, Byte Channel, GP70Setting* pSettingData);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP70Send(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, Byte Channel, Byte[] pSendData, UInt32 SendDataLength, UInt32* pWriteDataLength);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP70FIFOReset(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, Byte Channel);

        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP90Open(UInt32 hCom, Byte[] pMacAdrs, ErrorCallback pErrorFunc);
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP90Close(UInt32 hCom, Byte[] pMacAdrs  );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP90PWMSetting(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, GP90Setting SettingData );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP90PWMPulseSetting(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, GP90PulseSetting SettingData );
        [DllImport("RSSG2000", SetLastError = true)]
        unsafe public static extern UInt32  RPiGP90GetStatus(UInt32 hCom, Byte[] pMacAdrs, Byte SlaveAdrs, UInt16* pwData);
   }
}