#pragma pack(1)

// GP40ݒ
typedef struct _GP40Setting {
	BYTE	ChannelEnable;
	BYTE	AlarmEnable;
	WORD	SampTime;
	BYTE	Trigger;
	BYTE	Reserved;
	DWORD	ChannelRange;
	WORD	ChUpperThreshold[8];
	WORD	ChLowerThreshold[8];
} GP40Setting, *PGP40Setting;

// GP40`l̃f[^
typedef struct _GP40ChannelData {
	WORD	ChData[8];
} GP40ChannelData, *PGP40ChannelData;

// GP60ݒ
typedef struct _GP60Setting {
	BYTE	BaudRate;
	BYTE	DataBit;
	BYTE	Parity;
	BYTE	StopBit;
	BYTE	Flow;
	BYTE	Reserved1;
	WORD	Latency;
} GP60Setting, *PGP60Setting;

// GP70ݒ
typedef struct _GP70Setting {
	BYTE	BaudRate;
	BYTE	DataBit;
	BYTE	Parity;
	BYTE	StopBit;
	BYTE	Flow;
	BYTE	Reserved1;
	WORD	Latency;
} GP70Setting, *PGP70Setting;

// GP90ݒ
typedef struct _GP90Setting {
	BYTE	PWMNo;
	WORD	PWM_OnCount;
	BYTE	FULL_ON;
	WORD	PWM_OffCount;
	BYTE	FULL_OFF;
	BYTE	PreScale;
} GP90Setting, *PGP90Setting;

// GP90pXݒ
typedef struct _GP90PulseSetting {
	BYTE	Channel;
	WORD	Mode;
	WORD	CompA;
	WORD	CompB;
	WORD	Count;
} GP90PulseSetting, *PGP90PulseSetting;

#pragma pack()


typedef VOID (CALLBACK* ERROR_PROC)(PUCHAR);
typedef VOID (CALLBACK* TRIGGER_PROC)(PUCHAR);
typedef VOID (CALLBACK* TIMERDATA_PROC)(PUCHAR);
typedef VOID (CALLBACK* ALARM_PROC)(PUCHAR);
typedef VOID (CALLBACK* RECV_PROC)(PUCHAR);
typedef VOID (CALLBACK* REGIST_PROC)(PUCHAR);


// DLLO֐̎QƐ錾
#define DLLAPI __declspec(dllimport)

#ifdef __cplusplus
extern "C" {
#endif

DLLAPI HANDLE APIENTRY RSSG2000Open( UCHAR ComNo, UCHAR bChannel, UCHAR MaxSG2000Count, REGIST_PROC pRegistFunc );
DLLAPI DWORD APIENTRY RSSG2000Close( HANDLE hCom );
DLLAPI DWORD APIENTRY RSSG2000Start( HANDLE hCom );
DLLAPI DWORD APIENTRY RSSG2000Stop( HANDLE hCom );
DLLAPI DWORD APIENTRY RSSG2000Reset( HANDLE hCom );
DLLAPI DWORD APIENTRY RSSG2000GetVersion( HANDLE hCom, PUCHAR pMacAdrs, PUCHAR pVersion );
DLLAPI DWORD APIENTRY RSSG2000GetRSSI( HANDLE hCom, PUCHAR pMacAdrs, PCHAR pRSSI );
DLLAPI DWORD APIENTRY RSSG2000GetTemp( HANDLE hCom, PUCHAR pMacAdrs, double* pTemp, double* pHumidity );
DLLAPI DWORD APIENTRY RSSG2000SendRecv( HANDLE hCom, PULONG pStatus, PUCHAR pMacAdrs, PUCHAR pSendData, DWORD SendDataLength, PUCHAR pRecvData, DWORD RecvDataLength, BOOL Notify );

DLLAPI DWORD APIENTRY RSSG2000GetMacAdrs( HANDLE hCom, PUCHAR pMacAdrs );
DLLAPI DWORD APIENTRY RSSG2000RegistMacAdrs( HANDLE hCom, PUCHAR pMacAdrs );
DLLAPI DWORD APIENTRY RSSG2000DeleteMacAdrs( HANDLE hCom, PUCHAR pMacAdrs );

DLLAPI DWORD APIENTRY RSSG2000GetAlarmData( PUCHAR pAlarmData );
DLLAPI DWORD APIENTRY RSSG2000GetTimerData( PUCHAR pOneShotData );
DLLAPI DWORD APIENTRY RSSG2000GetRecvData( PUCHAR pRecvData );
DLLAPI DWORD APIENTRY RSSG2000GetTriggerData( PUCHAR pTriggerData );
DLLAPI DWORD APIENTRY RSSG2000GetErrorData( PUCHAR pErrorData );
DLLAPI DWORD APIENTRY RSSG2000GetRegistData( PUCHAR pRegistData );

DLLAPI DWORD APIENTRY RPiGP10Open( HANDLE hCom, PUCHAR pMacAdrs, TRIGGER_PROC pTriggerFunc, ERROR_PROC pErrorFunc );
DLLAPI DWORD APIENTRY RPiGP10Close( HANDLE hCom, PUCHAR pMacAdrs );
DLLAPI DWORD APIENTRY RPiGP10OutPort( HANDLE hCom, PUCHAR pMacAdrs, UCHAR bData, UCHAR bMask, UCHAR bStrobe );
DLLAPI DWORD APIENTRY RPiGP10InPort( HANDLE hCom, PUCHAR pMacAdrs, PUCHAR pData );
DLLAPI DWORD APIENTRY RPiGP10StrobeSetting( HANDLE hCom, PUCHAR pMacAdrs, BOOL Logic, DWORD wPulse );
DLLAPI DWORD APIENTRY RPiGP10StrobeOutput( HANDLE hCom, PUCHAR pMacAdrs );
DLLAPI DWORD APIENTRY RPiGP10Trigger( HANDLE hCom, PUCHAR pMacAdrs, BOOL Enable, UCHAR bOutData, UCHAR bMask );
DLLAPI DWORD APIENTRY RPiGP10TriggerChatter( HANDLE hCom, PUCHAR pMacAdrs, BOOL Enable, UCHAR bOutData, UCHAR bMask, WORD wChattering );

DLLAPI DWORD APIENTRY RPiGP40Open( HANDLE hCom, PUCHAR pMacAdrs, TIMERDATA_PROC pTimerDataFunc, ALARM_PROC pAlarmFunc, ERROR_PROC pErrorFunc );
DLLAPI DWORD APIENTRY RPiGP40Close( HANDLE hCom, PUCHAR pMacAdrs );
DLLAPI DWORD APIENTRY RPiGP40SetSetting( HANDLE hCom, PUCHAR pMacAdrs, GP40Setting SettingData );
DLLAPI DWORD APIENTRY RPiGP40GetSetting( HANDLE hCom, PUCHAR pMacAdrs, PGP40Setting pSettingData );
DLLAPI DWORD APIENTRY RPiGP40OneShot( HANDLE hCom, PUCHAR pMacAdrs, PGP40ChannelData pChData );
DLLAPI DWORD APIENTRY RPiGP40TimerData( HANDLE hCom, PUCHAR pMacAdrs, UCHAR bStart, UCHAR bTime );
DLLAPI DWORD APIENTRY RPiGP40OutPort( HANDLE hCom, PUCHAR pMacAdrs, UCHAR bData );
DLLAPI DWORD APIENTRY RPiGP40InPort( HANDLE hCom, PUCHAR pMacAdrs, PUCHAR pData );

DLLAPI DWORD APIENTRY RPiGP60Open( HANDLE hCom, PUCHAR pMacAdrs, RECV_PROC pRecvFunc, ERROR_PROC pErrorFunc );
DLLAPI DWORD APIENTRY RPiGP60Close( HANDLE hCom, PUCHAR pMacAdrs );
DLLAPI DWORD APIENTRY RPiGP60SetSetting( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, UCHAR Channel, GP60Setting SettingData );
DLLAPI DWORD APIENTRY RPiGP60GetSetting( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, UCHAR Channel, PGP60Setting pSettingData );
DLLAPI DWORD APIENTRY RPiGP60Send( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, UCHAR Channel, PUCHAR pSendData, ULONG SendDataLength, PULONG pWriteDataLength );
DLLAPI DWORD APIENTRY RPiGP60FIFOReset( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, UCHAR Channel );

DLLAPI DWORD APIENTRY RPiGP70Open( HANDLE hCom, PUCHAR pMacAdrs, RECV_PROC pRecvFunc, ERROR_PROC pErrorFunc );
DLLAPI DWORD APIENTRY RPiGP70Close( HANDLE hCom, PUCHAR pMacAdrs );
DLLAPI DWORD APIENTRY RPiGP70SetSetting( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, UCHAR Channel, GP70Setting SettingData );
DLLAPI DWORD APIENTRY RPiGP70GetSetting( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, UCHAR Channel, PGP70Setting pSettingData );
DLLAPI DWORD APIENTRY RPiGP70Send( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, UCHAR Channel, PUCHAR pSendData, ULONG SendDataLength, PULONG pWriteDataLength );
DLLAPI DWORD APIENTRY RPiGP70FIFOReset( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, UCHAR Channel );

DLLAPI DWORD APIENTRY RPiGP90Open( HANDLE hCom, PUCHAR pMacAdrs, ERROR_PROC pErrorFunc );
DLLAPI DWORD APIENTRY RPiGP90Close( HANDLE hCom, PUCHAR pMacAdrs );
DLLAPI DWORD APIENTRY RPiGP90PWMSetting( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, GP90Setting SettingData );
DLLAPI DWORD APIENTRY RPiGP90PWMPulseSetting( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, GP90PulseSetting SettingData );
DLLAPI DWORD APIENTRY RPiGP90GetStatus( HANDLE hCom, PUCHAR pMacAdrs, UCHAR SlaveAdrs, WORD* pwData );

#ifdef __cplusplus
}
#endif
