Option Strict Off
Option Explicit On
Imports System.Runtime.InteropServices

Module RSSG2000Lib

    '////////////////////////////////////////////////////////////////////////////////
    '//// 
    Public Structure RsUshortData
        Public Ushortcode_0 As UShort
        Public Ushortcode_1 As UShort
        Public Ushortcode_2 As UShort
        Public Ushortcode_3 As UShort
        Public Ushortcode_4 As UShort
        Public Ushortcode_5 As UShort
        Public Ushortcode_6 As UShort
        Public Ushortcode_7 As UShort
    End Structure

    '////////////////////////////////////////////////////////////////////////////////
    '//// GP40ݒ
    <StructLayout(LayoutKind.Explicit, Size:=42, CharSet:=CharSet.Ansi)> _
    Public Structure GP40Setting
        <FieldOffset(0)> Dim ChannelEnable As Byte
        <FieldOffset(1)> Dim AlarmEnable As Byte
        <FieldOffset(2)> Dim SampTime As UShort
        <FieldOffset(4)> Dim Trigger As Byte
        <FieldOffset(5)> Dim Reserved As Byte
        <FieldOffset(6)> Dim ChannelRange As UInt32
        <FieldOffset(10)> Dim ChUpperThreshold As RsUshortData
        <FieldOffset(26)> Dim ChLowerThreshold As RsUshortData
    End Structure

    '////////////////////////////////////////////////////////////////////////////////
    '//// GP60ݒ
    <StructLayout(LayoutKind.Explicit, Size:=6, CharSet:=CharSet.Ansi)> _
    Public Structure GP60Setting
        <FieldOffset(0)> Dim BaudRate As Byte
        <FieldOffset(1)> Dim DataBit As Byte
        <FieldOffset(2)> Dim Parity As Byte
        <FieldOffset(3)> Dim StopBit As Byte
        <FieldOffset(4)> Dim Flow As Byte
        <FieldOffset(5)> Dim Reserved1 As Byte
        <FieldOffset(6)> Dim Latency As UShort
    End Structure
    '////////////////////////////////////////////////////////////////////////////////
    '//// GP70ݒ
    <StructLayout(LayoutKind.Explicit, Size:=6, CharSet:=CharSet.Ansi)> _
    Public Structure GP70Setting
        <FieldOffset(0)> Dim BaudRate As Byte
        <FieldOffset(1)> Dim DataBit As Byte
        <FieldOffset(2)> Dim Parity As Byte
        <FieldOffset(3)> Dim StopBit As Byte
        <FieldOffset(4)> Dim Flow As Byte
        <FieldOffset(5)> Dim Reserved1 As Byte
        <FieldOffset(6)> Dim Latency As UShort
    End Structure

    '////////////////////////////////////////////////////////////////////////////////
    '//// GP90ݒ
    <StructLayout(LayoutKind.Explicit, Size:=8, CharSet:=CharSet.Ansi)> _
    Public Structure GP90Setting
        <FieldOffset(0)> Dim PWMNo As Byte
        <FieldOffset(1)> Dim PWM_OnCount As UShort
        <FieldOffset(3)> Dim FULL_ON As Byte
        <FieldOffset(4)> Dim PWM_OffCount As UShort
        <FieldOffset(6)> Dim FULL_OFF As Byte
        <FieldOffset(7)> Dim PreScale As Byte
    End Structure

    '////////////////////////////////////////////////////////////////////////////////
    '//// GP90pXݒ
    <StructLayout(LayoutKind.Explicit, Size:=9, CharSet:=CharSet.Ansi)> _
    Public Structure GP90PulseSetting
        <FieldOffset(0)> Dim Channel As Byte
        <FieldOffset(1)> Dim Mode As UShort
        <FieldOffset(3)> Dim CompA As UShort
        <FieldOffset(5)> Dim CompB As UShort
        <FieldOffset(7)> Dim CompC As UShort
    End Structure


    ' CallBack֐
    Delegate Sub ErrorCallback(ByRef pData As Byte)
    Delegate Sub TriggerCallback(ByRef pData As Byte)
    Delegate Sub TimerDataCallback(ByRef pData As Byte)
    Delegate Sub AlarmCallback(ByRef pData As Byte)
    Delegate Sub RecvCallback(ByRef pData As Byte)
    Delegate Sub RegistCallback(ByRef pData As Byte)

    'DLLO֐̎QƐ錾
    Declare Function RSSG2000Open Lib "RSSG2000.dll" (ByVal ComNo As Byte, ByVal bChannel As Byte, ByVal MaxSG2000Count As Byte, ByVal pRegistFunc As RegistCallback) As UInt32
    Declare Function RSSG2000Close Lib "RSSG2000.dll" (ByVal hCom As UInt32) As UInt32
    Declare Function RSSG2000Start Lib "RSSG2000.dll" (ByVal hCom As UInt32) As UInt32
    Declare Function RSSG2000Stop Lib "RSSG2000.dll" (ByVal hCom As UInt32) As UInt32
    Declare Function RSSG2000Reset Lib "RSSG2000.dll" (ByVal hCom As UInt32) As UInt32
    Declare Function RSSG2000GetVersion Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByRef pVersion As Byte) As UInt32
    Declare Function RSSG2000GetRSSI Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByRef pRSSI As SByte) As UInt32
    Declare Function RSSG2000GetTemp Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByRef pTemp As double, ByRef pHumidity As double) As UInt32
    Declare Function RSSG2000SendRecv Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pStatus As UInt32, ByRef pMacAdrs As Byte, ByRef pSendData As Byte, ByVal SendDataLength As UInt32, ByRef pRecvData As Byte, ByVal RecvDataLength As UInt32, ByVal Notify As Boolean) As UInt32

    Declare Function RSSG2000GetMacAdrs Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte) As UInt32
    Declare Function RSSG2000RegistMacAdrs Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte) As UInt32
    Declare Function RSSG2000DeleteMacAdrs Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte) As UInt32

    Declare Function RSSG2000GetAlarmData Lib "RSSG2000.dll" (ByVal pAlarmData As Byte()) As UInt32
    Declare Function RSSG2000GetTimerData Lib "RSSG2000.dll" (ByVal pOneShotData As Byte()) As UInt32
    Declare Function RSSG2000GetRecvData Lib "RSSG2000.dll" (ByVal pRecvData As Byte()) As UInt32
    Declare Function RSSG2000GetTriggerData Lib "RSSG2000.dll" (ByVal pTriggerData As Byte()) As UInt32
    Declare Function RSSG2000GetErrorData Lib "RSSG2000.dll" (ByVal pErrorData As Byte()) As UInt32
    Declare Function RSSG2000GetRegistData Lib "RSSG2000.dll" (ByVal pRegistData As Byte()) As UInt32

    Declare Function RPiGP10Open Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal pTriggerFunc As TriggerCallback, ByVal pErrorFunc As ErrorCallback) As UInt32
    Declare Function RPiGP10Close Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte) As UInt32
    Declare Function RPiGP10OutPort Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal bData As Byte, ByVal bMask As Byte, ByVal bStrobe As Byte) As UInt32
    Declare Function RPiGP10InPort Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByRef pData As Byte) As UInt32
    Declare Function RPiGP10StrobeSetting Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal Logic As Boolean, ByVal wPulse As UInt32) As UInt32
    Declare Function RPiGP10StrobeOutput Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte) As UInt32
    Declare Function RPiGP10Trigger Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal Enable As Boolean, ByVal bOutData As Byte, ByVal bMask As Byte) As UInt32
    Declare Function RPiGP10TriggerChatter Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal Enable As Boolean, ByVal bOutData As Byte, ByVal bMask As Byte, ByVal wChattering As UShort) As UInt32

    Declare Function RPiGP40Open Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal pTimerDataFunc As TimerDataCallback, ByVal pAlarmFunc As AlarmCallback, ByVal pErrorFunc As ErrorCallback) As UInt32
    Declare Function RPiGP40Close Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte) As UInt32
    Declare Function RPiGP40SetSetting Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SettingData As GP40Setting) As UInt32
    Declare Function RPiGP40GetSetting Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByRef pSettingData As GP40Setting) As UInt32
    Declare Function RPiGP40OneShot Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByRef pChData As RsUshortData) As UInt32
    Declare Function RPiGP40TimerData Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal bStart As Byte, ByVal bTime As Byte) As UInt32
    Declare Function RPiGP40OutPort Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal bData As Byte) As UInt32
    Declare Function RPiGP40InPort Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByRef pData As Byte) As UInt32

    Declare Function RPiGP60Open Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal pRecvFunc As RecvCallback, ByVal pErrorFunc As ErrorCallback) As UInt32
    Declare Function RPiGP60Close Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte) As UInt32
    Declare Function RPiGP60SetSetting Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByVal Channel As Byte, ByVal SettingData As GP60Setting) As UInt32
    Declare Function RPiGP60GetSetting Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByVal Channel As Byte, ByRef pSettingData As GP60Setting) As UInt32
    Declare Function RPiGP60Send Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByVal Channel As Byte, ByRef pSendData As Byte, ByVal SendDataLength As UInt32, ByRef pWriteDataLength As UInt32) As UInt32
    Declare Function RPiGP60FIFOReset Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByVal Channel As Byte) As UInt32

    Declare Function RPiGP70Open Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal pRecvFunc As RecvCallback, ByVal pErrorFunc As ErrorCallback) As UInt32
    Declare Function RPiGP70Close Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte) As UInt32
    Declare Function RPiGP70SetSetting Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByVal Channel As Byte, ByVal SettingData As GP70Setting) As UInt32
    Declare Function RPiGP70GetSetting Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByVal Channel As Byte, ByRef pSettingData As GP70Setting) As UInt32
    Declare Function RPiGP70Send Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByVal Channel As Byte, ByRef pSendData As Byte, ByVal SendDataLength As UInt32, ByRef pWriteDataLength As UInt32) As UInt32
    Declare Function RPiGP70FIFOReset Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByVal Channel As Byte) As UInt32

    Declare Function RPiGP90Open Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal pErrorFunc As ErrorCallback) As UInt32
    Declare Function RPiGP90Close Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte) As UInt32
    Declare Function RPiGP90PWMSetting Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByVal SettingData As GP90Setting) As UInt32
    Declare Function RPiGP90PWMPulseSetting Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByVal SettingData As GP90PulseSetting) As UInt32
    Declare Function RPiGP90GetStatus Lib "RSSG2000.dll" (ByVal hCom As UInt32, ByRef pMacAdrs As Byte, ByVal SlaveAdrs As Byte, ByRef pwData As UShort) As UInt32

End Module